/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.mylyn;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.IResourceSelector;
import org.polarion.team.svn.ui.action.local.CommitAction;
import org.polarion.team.svn.ui.extension.ExtensionsManager;
import org.polarion.team.svn.ui.extension.factory.ICommentDialogPanel;
import org.polarion.team.svn.ui.extension.factory.ICommitDialog;
import org.polarion.team.svn.ui.panel.local.CommitPanel;
import org.polarion.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.polarion.team.svn.ui.utility.CommitActionUtility;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class SVNCommitWorkflowProvider {
    public boolean hasOutgoingChanges(IResource[] resources) {
        return FileUtility.checkForResourcesPresence((IResource[])resources, (IStateFilter)CommitAction.SF_ANY_CHANGE, (int)0);
    }

    public void commit(final IResource[] resources) {
        CommitActionUtility commitUtility = new CommitActionUtility(new IResourceSelector(){

            public IResource[] getSelectedResources() {
                return resources;
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                return this.getSelectedResources(filter);
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                return this.getSelectedResources(filter);
            }

            public IResource[] getSelectedResources(IStateFilter filter) {
                return FileUtility.getResourcesRecursive((IResource[])this.getSelectedResources(), (IStateFilter)filter, (int)0);
            }
        });
        String proposedComment = SVNChangeSetCapability.getProposedComment((IResource[])commitUtility.getAllResources());
        CommitPanel commitPanel = new CommitPanel(commitUtility.getAllResources(), 0, proposedComment);
        Shell shell = UIMonitorUtility.getShell();
        ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(shell, (Collection)commitUtility.getAllResourcesSet(), (ICommentDialogPanel)commitPanel);
        if (commitDialog.open() == 0) {
            IResource[] selectedResources = commitPanel.getSelectedResources();
            IWorkbenchWindow window = SVNTeamUIPlugin.instance().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPart part = window == null ? null : window.getPartService().getActivePart();
            CompositeOperation op = commitUtility.getCompositeCommitOperation(selectedResources, commitDialog.getMessage(), commitPanel.getKeepLocks(), shell, part);
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        }
    }
}

