/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.File;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;

public class UnMnemonicProperties
extends FastProperties {
    private static final long serialVersionUID = -4066795589235888438L;
    public static final String MNEMONIC_CHARS = "[\\w\\.@]";
    public static final String NO_MNEMONIC = "%NO_MNEMONIC%";

    public UnMnemonicProperties() {
    }

    public UnMnemonicProperties(String path) {
        super(path);
    }

    public UnMnemonicProperties(File file) {
        super(file);
    }

    public String put(String key, String value) {
        return super.put(this.removeMnemonic(key), this.removeMnemonic(value));
    }

    private String removeMnemonic(String value) {
        value = value.replaceFirst("\\(\\&[\\w\\.@]\\)", "");
        value = value.replaceFirst("\\(\\&\\)", "");
        value = UnMnemonicProperties.removeEnMnemonic(value);
        return value;
    }

    public static String removeEnMnemonic(String enValue) {
        if (UnMnemonicProperties.hasEnMnemonic(enValue) && !enValue.startsWith(NO_MNEMONIC)) {
            return enValue.replaceFirst("\\&([\\w\\.@])", "$1");
        }
        return enValue;
    }

    public static boolean hasJaMnemonic(String value) {
        return value.matches("(?s)^.*?\\(\\&[\\w\\.@]\\).*$");
    }

    public static boolean hasEnMnemonic(String value) {
        return value.contains("&") && !value.contains("&lt;") && !value.contains("&gt;") && !value.contains("&amp;") && !value.contains("&quot;") && !value.contains("K&R ");
    }

    public static String toPropertyKey(String key) {
        return key.replaceAll("[ :=#!\t\\\\]", "\\\\$0").replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
    }

    public static String toPropertyValue(String value) {
        return value.replaceAll("#", "\\\\$0").replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
    }
}

