/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoXliffUtilChange]̃NX
 */
package blanco.xliff.util.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.xliff.util.task.valueobject.BlancoXliffUtilChangeProcessInput;

/**
 * Apache Ant^XN [BlancoXliffUtilChange]̃NXB
 *
 * [XLIFFΉc[] XLIFF ̕ύXs܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.xliff.util.task]BlancoXliffUtilChangeBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoxliffutilchange&quot; classname=&quot;blanco.xliff.util.task.BlancoXliffUtilChangeTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoXliffUtilChangeTask extends Task {
    /**
     * [XLIFFΉc[] XLIFF ̕ύXs܂B
     */
    protected BlancoXliffUtilChangeProcessInput fInput = new BlancoXliffUtilChangeProcessInput();

    /**
     * [XLIFFΉc[] XLIFF ̕ύXs܂B
     */
    protected boolean fIsFieldXliffdirProcessed = false;

    /**
     * [XLIFFΉc[] XLIFF ̕ύXs܂B
     */
    protected boolean fIsFieldSettargetifnotexistProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[xliffdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * XLIFF (*.xlf) fBNg<br>
     *
     * @param arg Zbgl
     */
    public void setXliffdir(final String arg) {
        fInput.setXliffdir(arg);
        fIsFieldXliffdirProcessed = true;
    }

    /**
     * Ant^XN[xliffdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * XLIFF (*.xlf) fBNg<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getXliffdir() {
        return fInput.getXliffdir();
    }

    /**
     * Ant^XN[settargetifnotexist]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * target ꍇ target Zbg邩ǂB<br>
     *
     * @param arg Zbgl
     */
    public void setSettargetifnotexist(final boolean arg) {
        fInput.setSettargetifnotexist(arg);
        fIsFieldSettargetifnotexistProcessed = true;
    }

    /**
     * Ant^XN[settargetifnotexist]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * target ꍇ target Zbg邩ǂB<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public boolean getSettargetifnotexist() {
        return fInput.getSettargetifnotexist();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoXliffUtilChangeTask begin.");

        // ڔԍ[1]AAgr[g[xliffdir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldXliffdirProcessed == false) {
            throw new BuildException("K{Agr[g[xliffdir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- xliffdir:[" + getXliffdir() + "]");
            System.out.println("- settargetifnotexist:[" + getSettargetifnotexist() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoXliffUtilChangeProcessC^tF[X blanco.xliff.util.taskpbP[W BlancoXliffUtilChangeProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoXliffUtilChangeProcess proc = new BlancoXliffUtilChangeProcessImpl();
            if (proc.execute(fInput) != BlancoXliffUtilChangeBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
