/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FastProperties;
import jp.sourceforge.mergedoc.pleiades.util.Files;

public class RegexDictionary {
    private static final Logger log = Logger.getLogger(RegexDictionary.class);
    public static final String PROP_FILE_NAME = "translation-regex.properties";
    private static final RegexDictionary singleton = new RegexDictionary();
    private final Map<Pattern, String> map = new HashMap<Pattern, String>();

    public static RegexDictionary getInstance() {
        return singleton;
    }

    private RegexDictionary() {
        File file = Files.getResourceFile(PROP_FILE_NAME);
        if (!file.exists()) {
            FileNotFoundException e = new FileNotFoundException(file.getPath());
            IllegalStateException ise = new IllegalStateException("\u7ffb\u8a33\u6b63\u898f\u8868\u73fe\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", e);
            Pleiades.abort(ise);
        }
        FastProperties prop = new FastProperties(file);
        for (Map.Entry entry : prop.entrySet()) {
            this.map.put(Pattern.compile((String)entry.getKey()), (String)entry.getValue());
        }
        log.info("\u7ffb\u8a33\u6b63\u898f\u8868\u73fe\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.map.size());
    }

    public String lookup(String enValue) {
        for (Map.Entry<Pattern, String> entry : this.map.entrySet()) {
            Pattern pattern = entry.getKey();
            Matcher matcher = pattern.matcher(Matcher.quoteReplacement(enValue));
            try {
                if (!matcher.matches()) continue;
                String replacement = entry.getValue();
                return matcher.replaceFirst(replacement);
            }
            catch (RuntimeException e) {
                log.error("\u6b63\u898f\u8868\u73fe\u7ffb\u8a33\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + pattern, e);
                break;
            }
        }
        return null;
    }
}

