/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import jp.sourceforge.mergedoc.pleiades.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationResult;
import junit.framework.TestCase;

public class TranslationDictionaryTest
extends TestCase {
    private final TranslationDictionary target = new TranslationDictionary();

    public void testLookup() {
        TranslationResult result = null;
        String input = null;
        input = "... undefined string in dictionary ...";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)input, (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)false, (boolean)result.isFound());
        input = "Label";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "L&abel";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb(&A)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Left";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u5de6(&L)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Search results for {0}:";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"{0} \u306e\u691c\u7d22\u7d50\u679c:", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Remo&ve Buildfile";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30d3\u30eb\u30c9\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u9664\u53bb(&V)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Error reading configuration";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u69cb\u6210\u306e\u8aad\u307f\u53d6\u308a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Extension....";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u62e1\u5f35(&E)....", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        result = this.target.lookupIgnoreMnemonic("Label");
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "L&abel";
        result = this.target.lookupIgnoreMnemonic(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)input, (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)false, (boolean)result.isFound());
        input = "&Next >";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u6b21\u3078(&N) >", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Next >>";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u6b21\u3078(&N) >>", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "<< &Previous";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"<< \u524d\u3078(&P)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Using {0} - <a>Select other...</a>";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"{0} \u3092\u4f7f\u7528\u4e2d - <a>\u305d\u306e\u4ed6\u306e\u9078\u629e(&U)...</a>", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Add -->";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u8ffd\u52a0(&A) -->", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Color:";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u8272(&C):", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Add &Include@Ctrl+Shift+N";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"Include \u306e\u8ffd\u52a0(&I)@Ctrl+Shift+N", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Go to &Line...@Ctrl+L";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u6307\u5b9a\u884c\u3078\u30b8\u30e3\u30f3\u30d7(&L)...@Ctrl+L", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "A resource named \"&1\" already exists.";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30ea\u30bd\u30fc\u30b9 \"&1\" \u306f\u3059\u3067\u306b\u5b58\u5728\u3057\u307e\u3059\u3002", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "K&R [built-in]";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"K&R [\u30d3\u30eb\u30c8\u30a4\u30f3]", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&nbsp;&nbsp;Go&nbsp;&nbsp;";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"&nbsp;&nbsp;\u5b9f\u884c&nbsp;&nbsp;", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Ignore '&&' in &Java properties files";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"Java \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u306e '&&' \u3092\u7121\u8996(&J)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
    }
}

