/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.task;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

import blanco.commons.io.Native2AsciiWriter;
import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.nlpack.generator.BlancoNLpackGeneratorConstants;
import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorResultCsvWriter;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorResultDetailCsvWriter;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultCsvRecord;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultDetailCsvRecord;
import blanco.nlpack.generator.message.BlancoNLpackGeneratorMessage;
import blanco.nlpack.generator.resourcebundle.BlancoNLpackGeneratorResourceBundle;
import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorConvertXliff2PropertiesProcessInput;
import blanco.properties.BlancoPropertiesDirectoryParser;
import blanco.properties.BlancoPropertiesUtil;
import blanco.properties.manifest.BlancoPropertiesManifestWriter;
import blanco.properties.manifest.valueobject.BlancoPropertiesManifest;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.stringgroup.BlancoXliffStateStringGroup;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoNLpackGeneratorConvertXliff2PropertiesProcessImpl extends
        BlancoPropertiesDirectoryParser implements
        BlancoNLpackGeneratorConvertXliff2PropertiesProcess {
    private BlancoNLpackGeneratorConvertXliff2PropertiesProcessInput fInput = null;

    /**
     * bZ[WIuWFNgB
     */
    private final BlancoNLpackGeneratorMessage fMsg = new BlancoNLpackGeneratorMessage();

    private final BlancoNLpackGeneratorResourceBundle fBundle = new BlancoNLpackGeneratorResourceBundle();

    private String fPrevBundleSymbolicName = null;

    private BlancoXliff fXliff = null;

    private BlancoNLpackGeneratorResultCsvWriter fLogSummaryWriter = null;

    private BlancoNLpackGeneratorResultDetailCsvWriter fLogDetailWriter = null;

    private String fPropertiesNameWithPath = null;

    /**
     * qbgB
     */
    private int fReplaceHitCount = 0;

    /**
     * j[jbNϊB
     */
    private int fReplaceMnemonicCount = 0;

    /**
     * OB
     */
    private int fReplaceOmitCount = 0;

    /**
     * ~XB
     */
    private int fReplaceMissCount = 0;

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     * 
     * @param input
     *            ̓̓p[^B
     * @return ̎sʁB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(
            final BlancoNLpackGeneratorConvertXliff2PropertiesProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        // LbṼNAB
        fPrevBundleSymbolicName = null;

        System.out.println("babel: begin: [" + fInput.getSourcedir() + "]->["
                + fInput.getTargetdir() + "].");

        {
            // o͐fBNg쐬B
            final File fileTarget = new File(fInput.getTargetdir());
            if (fileTarget.exists() == false) {
                fileTarget.mkdirs();
            }

            final File fileTmpDir = new File(fInput.getTmpdir() + "/log");
            fileTmpDir.mkdirs();
        }

        // TODO Ot@C̊OB
        final File fileLogSummary = new File(fInput.getTmpdir()
                + "/log/blancoNLpackGeneratorResult.csv");
        try {
            final BufferedWriter writer = new BufferedWriter(
                    new BufferedWriter(new FileWriter(fileLogSummary, true)));
            writer.write("[[" + BlancoNLpackGeneratorConstants.PRODUCT_NAME
                    + " (" + BlancoNLpackGeneratorConstants.VERSION + ")"
                    + "]]: " + fInput.getSourcedir());
            writer.newLine();

            fLogSummaryWriter = new BlancoNLpackGeneratorResultCsvWriter(writer);
            fLogSummaryWriter.writeTitle();
        } catch (IOException ex) {
            throw new IllegalArgumentException(fMsg.getMbebi004(fileLogSummary
                    .getAbsolutePath(), ex.toString()));
        }

        // TODO Ot@C̊OB
        final File fileLogDetail = new File(fInput.getTmpdir()
                + "/log/blancoNLpackGeneratorResultDetail.csv");
        try {
            final BufferedWriter writer = new BufferedWriter(
                    new BufferedWriter(new FileWriter(fileLogDetail, true)));
            writer.write("[[" + BlancoNLpackGeneratorConstants.PRODUCT_NAME
                    + " (" + BlancoNLpackGeneratorConstants.VERSION + ")"
                    + "]]: " + fInput.getSourcedir());
            writer.newLine();

            fLogDetailWriter = new BlancoNLpackGeneratorResultDetailCsvWriter(
                    writer);
            fLogDetailWriter.writeTitle();
        } catch (IOException ex) {
            throw new IllegalArgumentException(fMsg.getMbebi005(fileLogDetail
                    .getAbsolutePath(), ex.toString()));
        }

        try {
            if (new File(fInput.getSourcedir()).exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbebi001(fInput
                        .getSourcedir()));
            }

            parse(new File(fInput.getSourcedir()));
        } finally {
            if (fLogSummaryWriter != null) {
                fLogSummaryWriter.close();
                fLogSummaryWriter = null;
            }

            if (fLogDetailWriter != null) {
                fLogDetailWriter.close();
                fLogDetailWriter = null;
            }
        }

        System.out.println("babel: end.");

        return 0;
    }

    @Override
    protected void beginProperties(final String bundleURI,
            final Properties inputProps,
            final String argPropertiesNameWithPath,
            final BufferedWriter bufPropsWriter) throws IOException {
        fReplaceHitCount = 0;
        fReplaceMissCount = 0;
        fReplaceMnemonicCount = 0;
        fReplaceOmitCount = 0;

        final String nextBundleSymbolicName = BlancoPropertiesUtil
                .getHostFromBabelURI(bundleURI);
        if (nextBundleSymbolicName.equals(fPrevBundleSymbolicName)) {
            // LbVqbg܂B[h܂B
        } else {
            fXliff = BlancoXliffUtil.getXliffInstance(new File(fInput
                    .getXliffdir()), nextBundleSymbolicName);
            fPrevBundleSymbolicName = nextBundleSymbolicName;
        }

        fPropertiesNameWithPath = argPropertiesNameWithPath;
        if (BlancoStringUtil.null2Blank(fBundle.getPropertiesHeader()).length() > 0) {
            // lHIɃwb_[t^܂B
            bufPropsWriter.write(fBundle.getPropertiesHeader());
            bufPropsWriter.newLine();
            bufPropsWriter.newLine();
        }
    }

    @Override
    protected boolean processPropertiesKey(String bundleURI,
            Properties inputProps, String key, BufferedWriter bufPropsWriter)
            throws IOException {
        boolean isReplaced = false;
        final BlancoNLpackGeneratorResultDetailCsvRecord record = new BlancoNLpackGeneratorResultDetailCsvRecord();
        record.setBundleUri(bundleURI + "?key=" + key);
        record.setKey(key);
        record.setInput((String) inputProps.get(key));

        final BlancoXliffTransUnit transUnit = getTransUnitInstance(fXliff,
                bundleURI + "?key=" + key);
        if (transUnit == null) {
            // ꂸ
            fReplaceMissCount++;
            record.setAction("miss.n");
        } else if (transUnit.getTranslate() == false) {
            // |ΏۊOB
            fReplaceOmitCount++;
            record.setAction("omit");
        } else if (BlancoStringUtil.null2Blank(transUnit.getSource()).equals(
                (String) inputProps.get(key)) == false) {
            //  trans-unit ̂ɁAsource قȂ܂B
            fReplaceMissCount++;
            record.setAction("miss.s");

            // FIXME sourceقȂ̏ꍇ̏ɂāAǂ̂悤ȎxXgȂ̂ȂƁB
            System.out
                    .println("trace:  trans-unit ̂ɁAsource قȂ܂B: "
                            + record.getBundleUri());
        } else if (transUnit.getTarget() != null
                && transUnit.getTarget().getTarget() != null) {
            isReplaced = true;

            // state ɂ铮ύX{܂B
            // {I target ͗̕p܂B
            switch (new BlancoXliffStateStringGroup()
                    .convertToInt(BlancoStringUtil.null2Blank(transUnit
                            .getTarget().getState()))) {
            case BlancoXliffStateStringGroup.NEW:
            case BlancoXliffStateStringGroup.NEEDS_TRANSLATION:
                // |̂̂ɂāAtarget ͗̕p̂ miss ƂăJEg܂B
                fReplaceMissCount++;
                record.setAction("miss.y");
                break;
            default:
                // |ł܂B
                fReplaceHitCount++;
                record.setAction("hit");
                break;
            }

        } else {
            fReplaceMissCount++;
            record.setAction("miss.t");
        }

        if (isReplaced) {
            bufPropsWriter
                    .write(Native2AsciiWriter.encodeNative2AsciiValue(transUnit
                            .getTarget().getTarget()));
            record.setOutput(transUnit.getTarget().getTarget());
        } else {
            bufPropsWriter.write(Native2AsciiWriter
                    .encodeNative2AsciiValue((String) inputProps.get(key)));
        }
        bufPropsWriter.newLine();

        try {
            fLogDetailWriter.writeRecord(record);
        } catch (BlancoCsvIOException e) {
            throw new IllegalArgumentException("CSVo͗O", e);
        }

        return isReplaced;
    }

    @Override
    protected void endProperties(String bundleURI, Properties inputProps,
            BlancoPropertiesManifest manifest, byte[] bufPropsBytes,
            boolean isReplaced) throws IOException {
        final BlancoNLpackGeneratorResultCsvRecord record = new BlancoNLpackGeneratorResultCsvRecord();
        record.setBundleSymbolicName(BlancoPropertiesUtil
                .getHostFromBabelURI(bundleURI));
        record.setBundleUri(bundleURI);
        record.setReplaceHitCount(fReplaceHitCount);
        record.setReplaceMissCount(fReplaceMissCount);
        record.setReplaceOmitCount(fReplaceOmitCount);

        final String displayPath = BlancoPropertiesUtil
                .getHostFromBabelURI(bundleURI)
                + ": " + BlancoPropertiesUtil.getPathFromBabelURI(bundleURI);

        if (isReplaced) {
            final File fileTarget = new File(fInput.getTargetdir()
                    + "/"
                    + BlancoPropertiesUtil.getPluginNameWithSuffix(manifest,
                            fBundle.getTargetLocale())
                    + fPropertiesNameWithPath.substring(0,
                            fPropertiesNameWithPath.length()
                                    - ".properties".length()) + "_"
                    + fBundle.getTargetLocale() + ".properties");
            fileTarget.getParentFile().mkdirs();
            switch (BlancoFileUtil.bytes2FileIfNecessary(bufPropsBytes,
                    fileTarget)) {
            case 1:
                if (fInput.getVerbose()) {
                    System.out.println("xliff: x2p: create: " + displayPath);
                }
                record.setAction("create");
                break;
            case 2:
                if (fInput.getVerbose()) {
                    System.out.println("xliff: x2p: update: " + displayPath);
                }
                record.setAction("update");
                break;
            case 0:
                if (fInput.getVerbose()) {
                    System.out.println("xliff: x2p: none  : " + displayPath);
                }
                record.setAction("none");
                break;
            }

            // |󏈗{ꂽꍇɂ MANIFEST.MF֘At@C𐶐܂B
            new BlancoPropertiesManifestWriter().write(manifest, new File(
                    fInput.getTargetdir()
                            + "/"
                            + BlancoPropertiesUtil.getPluginNameWithSuffix(
                                    manifest, fBundle.getTargetLocale())));
        } else {
            if (fInput.getVerbose()) {
                System.out.println("xliff: x2p: skip  : " + displayPath);
            }
            record.setAction("skip");
        }

        try {
            fLogSummaryWriter.writeRecord(record);
        } catch (BlancoCsvIOException e) {
            throw new IOException(fMsg.getMbebc001(e.toString()));
        }
    }

    private BlancoXliffTransUnit getTransUnitInstance(final BlancoXliff xliff,
            final String id) {
        BlancoXliffTransUnit transUnit = BlancoXliffUtil
                .getTransUnit(xliff, id);
        if (transUnit != null) {
            // w肳ꂽidɂ trans-unit ɂ ԋpB
            return transUnit;
        }

        // ݂Ȃꍇ͏܂B
        return null;
    }
}
