/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.lang.reflect.Field;
import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class DynamicTranslationLoggingDictionary
extends DynamicTranslationDictionary
implements ITimingLogger {
    private static final Logger log = Logger.getLogger(DynamicTranslationLoggingDictionary.class);
    private volatile long applyConverterTime;
    private volatile long applyConverterCall;
    private volatile long lookupTime;
    private volatile long lookupCall;
    private volatile long lookupIgnoreMnemonicTime;
    private volatile long lookupIgnoreMnemonicCall;
    private volatile long getValueTime;
    private volatile long getValueCall;
    private volatile long getValueToTrimTime;
    private volatile long getValueToTrimCall;
    private volatile long getValueByRegexTime;
    private volatile long getValueByRegexCall;
    private volatile long isNoTranslationTime;
    private volatile long isNoTranslationCall;
    private volatile long editMnemonicEnToJaTime;
    private volatile long editMnemonicEnToJaCall;

    DynamicTranslationLoggingDictionary() {
        Pleiades.registTimingLogger(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyConverter() {
        long startTime = System.currentTimeMillis();
        super.applyConverter();
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.applyConverterTime += System.currentTimeMillis() - startTime;
            ++this.applyConverterCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookup(String enValue, JointPoint jointPoint) {
        long startTime = System.currentTimeMillis();
        String result = super.lookup(enValue, jointPoint);
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.lookupTime += System.currentTimeMillis() - startTime;
            ++this.lookupCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupIgnoreMnemonic(String enValue, JointPoint jointPoint) {
        long startTime = System.currentTimeMillis();
        String result = super.lookupIgnoreMnemonic(enValue, jointPoint);
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.lookupIgnoreMnemonicTime += System.currentTimeMillis() - startTime;
            ++this.lookupIgnoreMnemonicCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getValue(String enNoMnemonic) {
        long startTime = System.currentTimeMillis();
        String result = super.getValue(enNoMnemonic);
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.getValueTime += System.currentTimeMillis() - startTime;
            ++this.getValueCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getValueToTrim(String enNoMnemonic) {
        long startTime = System.currentTimeMillis();
        String result = super.getValueToTrim(enNoMnemonic);
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.getValueToTrimTime += System.currentTimeMillis() - startTime;
            ++this.getValueToTrimCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getValueByRegex(String enNoMnemonic) {
        long startTime = System.currentTimeMillis();
        String result = super.getValueByRegex(enNoMnemonic);
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.getValueByRegexTime += System.currentTimeMillis() - startTime;
            ++this.getValueByRegexCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isNoTranslation(String enValueNonMnemonic, JointPoint jointPoint) {
        long startTime = System.currentTimeMillis();
        boolean result = super.isNoTranslation(enValueNonMnemonic, jointPoint);
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.isNoTranslationTime += System.currentTimeMillis() - startTime;
            ++this.isNoTranslationCall;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String editMnemonicEnToJa(String enValue, String enValueNonMnemonic, String result) {
        long startTime = System.currentTimeMillis();
        String jaResult = super.editMnemonicEnToJa(enValue, enValueNonMnemonic, result);
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            this.editMnemonicEnToJaTime += System.currentTimeMillis() - startTime;
            ++this.editMnemonicEnToJaCall;
        }
        return jaResult;
    }

    public long logTime() {
        String msg = "%-30s %8d \u56de\u547c\u51fa\u8a08 %6.3f \u79d2";
        log.debug(String.format(msg, "applyConverter", this.applyConverterCall, (double)this.applyConverterTime / 1000.0));
        log.debug(String.format(msg, "lookupIgnoreMnemonic", this.lookupIgnoreMnemonicCall, (double)this.lookupIgnoreMnemonicTime / 1000.0));
        log.debug(String.format(msg, "lookup", this.lookupCall, (double)this.lookupTime / 1000.0));
        log.debug(String.format(msg, "  editMnemonicEnToJa", this.editMnemonicEnToJaCall, (double)this.editMnemonicEnToJaTime / 1000.0));
        log.debug(String.format(msg, "  getValue", this.getValueCall, (double)this.getValueTime / 1000.0));
        log.debug(String.format(msg, "    isNoTranslation", this.isNoTranslationCall, (double)this.isNoTranslationTime / 1000.0));
        log.debug(String.format(msg, "    getValueToTrim", this.getValueToTrimCall, (double)this.getValueToTrimTime / 1000.0));
        log.debug(String.format(msg, "      getValueByRegex", this.getValueByRegexCall, (double)this.getValueByRegexTime / 1000.0));
        long summuryTime = this.applyConverterTime + this.lookupIgnoreMnemonicTime + this.lookupTime + this.editMnemonicEnToJaTime + this.getValueTime + this.isNoTranslationTime + this.getValueToTrimTime + this.getValueByRegexTime;
        log.debug(String.format("\u30af\u30e9\u30b9\u8a08 %6.3f \u79d2", (double)summuryTime / 1000.0));
        return summuryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        DynamicTranslationLoggingDictionary dynamicTranslationLoggingDictionary = this;
        synchronized (dynamicTranslationLoggingDictionary) {
            Field[] fields = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (field.getType() == Long.TYPE) {
                    try {
                        field.setAccessible(true);
                        field.set(this, 0L);
                    }
                    catch (Exception e) {
                        log.error("\u30d5\u30a3\u30fc\u30eb\u30c9\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                    }
                }
                ++i;
            }
        }
    }
}

