/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.task;

import java.io.IOException;

import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput;
import blanco.nlpack.generator.util.BlancoNLpackGeneratorTranslationFragmentToPleiades;

/**
 * |tOg`̃t@C Pleiades`t@Cɕϊ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessImpl
        implements BlancoNLpackGeneratorTranslationFragmentToPleiadesProcess {

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     * 
     * @param input
     *            ̓̓p[^B
     * @return ̎sʁB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(
            final BlancoNLpackGeneratorTranslationFragmentToPleiadesProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("nlpack: TranslationFragment -> Pleiades: begin");

        try {
            new BlancoNLpackGeneratorTranslationFragmentToPleiades()
                    .process(input);
        } catch (BlancoCsvIOException ex) {
            throw new IOException("CSVt@C͂ŗO:" + ex.toString());
        }

        System.out.println("nlpack: TranslationFragment -> Pleiades: end");

        return BlancoNLpackGeneratorTranslationFragmentToPleiadesBatchProcess.END_SUCCESS;
    }
}
