/**
 * c[NX̌BDiffResultDetailPleiades`ɕϊ郆[eBeB
 */
package blanco.nlpack.generator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import blanco.nlpack.generator.BlancoNLpackGeneratorResultDetailUtil;
import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorDiffResultDetailCsvReader;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorDiffResultDetailCsvRecord;
import blanco.properties.BlancoPropertiesUtil;

/**
 * NX͖B
 */
public class DiffResultDetailToPleiades {
    public static final void main(final String[] args) throws IOException,
            BlancoCsvIOException {
        System.out.println("vpeB: begin");
        new DiffResultDetailToPleiades()
                .process(
                        new File(
                                "tmp/phase4.diff/ResultDetailDiffEclipse3.3to3.4Selected.csv"),
                        new File(
                                "tmp/phase4.diff/ResultDetailDiffEclipse3.3to3.4Selected.properties"));
        System.out.println("vpeB: end");
    }

    public void process(final File fileInput, final File fileOutput)
            throws IOException, BlancoCsvIOException {
        final BlancoNLpackGeneratorDiffResultDetailCsvReader reader = new BlancoNLpackGeneratorDiffResultDetailCsvReader(
                new BufferedReader(new InputStreamReader(new FileInputStream(
                        fileInput), "Windows-31J")));
        final BufferedWriter writer = new BufferedWriter(new BufferedWriter(
                new OutputStreamWriter(new FileOutputStream(fileOutput),
                        "UTF-8")));
        for (;;) {
            if (BlancoNLpackGeneratorResultDetailUtil
                    .checkValidResultDetailRecordByFieldBundleUri(reader
                            .getReader()) == false) {
                // ̍s͓ǂݔ΂܂B
                reader.getReader().readLine();
                continue;
            }
            final BlancoNLpackGeneratorDiffResultDetailCsvRecord record = reader
                    .readRecord();
            if (record == null) {
                break;
            }

            writer.write("# uri  : " + record.getBundleUri());
            writer.newLine();
            writer.write("# left : " + record.getLeftAction());
            writer.newLine();
            writer.write(BlancoPropertiesUtil.getPropertiesLine(record
                    .getLeftInput(), record.getLeftOutput()));
            writer.newLine();
            writer.write("# right: " + record.getRightAction());
            writer.newLine();
            writer.write(BlancoPropertiesUtil.getPropertiesLine(record
                    .getRightInput(), record.getRightOutput()));
            writer.newLine();
            writer.newLine();
        }
        reader.close();
        writer.close();
    }
}
