/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.logmessage.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.logmessage.BlancoLogMessageConstants;
import blanco.logmessage.BlancoLogMessageMeta2Xml;
import blanco.logmessage.BlancoLogMessageXml2SourceFile;
import blanco.logmessage.message.BlancoLogMessageMessage;
import blanco.logmessage.task.valueobject.BlancoLogMessageProcessInput;

public class BlancoLogMessageProcessImpl implements BlancoLogMessageProcess {
    /**
     * bZ[WB
     */
    private final BlancoLogMessageMessage fMsg = new BlancoLogMessageMessage();

    public int execute(BlancoLogMessageProcessInput input) throws IOException,
            IllegalArgumentException {
        System.out.println("- " + BlancoLogMessageConstants.PRODUCT_NAME + " ("
                + BlancoLogMessageConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbmsga01(input
                        .getMetadir()));
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoLogMessageConstants.TARGET_SUBDIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoLogMessageMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoLogMessageConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoLogMessageConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoLogMessageXml2SourceFile().process(fileMeta2[index],
                        input.getTargetlang(), new File(input.getTargetdir()));
            }

            return BlancoLogMessageBatchProcess.END_SUCCESS;
        } catch (TransformerException ex) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + ex.toString());
        }
    }
}
