/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.omegat.core.segmentation.DefaultRules;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class SRX
implements Serializable,
Cloneable {
    private static SRX srx = null;
    private static final String CONF_SENTSEG = "segmentation.conf";
    private static final File configFile = new File(StaticUtils.getConfigDir() + "segmentation.conf");
    private static final String DEFAULT_RULES_PATTERN = ".*";
    private static final String ENGLISH_RULES_PATTERN = "EN.*";
    private static final String JAPANESE_RULES_PATTERN = "JA.*";
    private static final String RUSSIAN_RULES_PATTERN = "RU.*";
    private static final String GERMAN_RULES_PATTERN = "DE.*";
    private boolean segmentSubflows = true;
    private boolean includeStartingTags;
    private boolean includeEndingTags = true;
    private boolean includeIsolatedTags;
    private List mappingRules = new ArrayList();
    public static String INITIAL_VERSION = "0.2";
    public static String OT160RC8_VERSION = "0.2.1";
    public static String OT160RC9_VERSION;
    public static String CURRENT_VERSION;
    private String version;

    public static SRX getSRX() {
        if (srx == null) {
            srx = SRX.load();
        }
        return srx;
    }

    public static void reload() {
        srx = SRX.load();
    }

    public static void init() {
        srx = new SRX();
        srx.initDefaults();
    }

    public void save() {
        try {
            this.setVersion(CURRENT_VERSION);
            XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(configFile));
            xMLEncoder.writeObject(this);
            xMLEncoder.close();
        }
        catch (IOException iOException) {
            Log.logErrorRB("CORE_SRX_ERROR_SAVING_SEGMENTATION_CONFIG");
            Log.log(iOException);
            JOptionPane.showMessageDialog(null, OStrings.getString("CORE_SRX_ERROR_SAVING_SEGMENTATION_CONFIG") + "\n" + iOException, OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private static SRX load() {
        SRX sRX;
        try {
            MyExceptionListener myExceptionListener = new MyExceptionListener();
            XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(configFile), null, myExceptionListener);
            sRX = (SRX)xMLDecoder.readObject();
            xMLDecoder.close();
            if (myExceptionListener.isExceptionOccured()) {
                StringBuffer stringBuffer = new StringBuffer();
                List list = myExceptionListener.getExceptionsList();
                for (int i = 0; i < list.size(); ++i) {
                    stringBuffer.append("    ");
                    stringBuffer.append(list.get(i));
                    stringBuffer.append("\n");
                }
                Log.logErrorRB("CORE_SRX_EXC_LOADING_SEG_RULES", new Object[]{stringBuffer.toString()});
                sRX = new SRX();
                sRX.initDefaults();
                return sRX;
            }
            if (CURRENT_VERSION.compareTo(sRX.getVersion()) > 0) {
                SRX sRX2 = new SRX();
                sRX2.initDefaults();
                sRX = SRX.merge(sRX, sRX2);
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof FileNotFoundException)) {
                Log.log(exception);
            }
            sRX = new SRX();
            sRX.initDefaults();
        }
        return sRX;
    }

    private static SRX merge(SRX sRX, SRX sRX2) {
        sRX = SRX.upgrade(sRX, sRX2);
        int n = sRX2.getMappingRules().size();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            MapRule mapRule = (MapRule)sRX2.getMappingRules().get(i);
            String string = mapRule.getLanguageCode();
            boolean bl = false;
            int n3 = sRX.getMappingRules().size();
            MapRule mapRule2 = null;
            for (n2 = 0; n2 < n3; ++n2) {
                mapRule2 = (MapRule)sRX.getMappingRules().get(n2);
                object = mapRule2.getLanguageCode();
                if (!string.equals(object)) continue;
                bl = true;
                break;
            }
            if (bl) {
                List list = mapRule2.getRules();
                object = mapRule.getRules();
                for (int j = 0; j < object.size(); ++j) {
                    int n4;
                    Rule rule = (Rule)object.get(j);
                    if (list.contains(rule)) continue;
                    if (rule.isBreakRule()) {
                        list.add(rule);
                        continue;
                    }
                    int n5 = n4 = list.size();
                    for (int k = 0; k < n4; ++k) {
                        Rule rule2 = (Rule)list.get(k);
                        if (!rule2.isBreakRule()) continue;
                        n5 = k;
                        break;
                    }
                    list.add(n5, rule);
                }
                continue;
            }
            n2 = n3;
            for (int j = 0; j < n3; ++j) {
                mapRule2 = (MapRule)sRX.getMappingRules().get(j);
                String string2 = mapRule2.getPattern();
                if (!DEFAULT_RULES_PATTERN.equals(string2)) continue;
                n2 = j;
                break;
            }
            sRX.getMappingRules().add(n2, mapRule);
        }
        return sRX;
    }

    private static SRX upgrade(SRX sRX, SRX sRX2) {
        if (OT160RC9_VERSION.equals(CURRENT_VERSION)) {
            String string = "Default (English)";
            for (int i = 0; i < sRX.getMappingRules().size(); ++i) {
                MapRule mapRule = (MapRule)sRX.getMappingRules().get(i);
                if (!string.equals(mapRule.getLanguageCode())) continue;
                mapRule.setLanguage("Default");
                mapRule.getRules().removeAll(DefaultRules.english());
                mapRule.getRules().removeAll(DefaultRules.textFormat());
                mapRule.getRules().removeAll(DefaultRules.htmlFormat());
            }
        }
        return sRX;
    }

    private void initDefaults() {
        this.getMappingRules().add(new MapRule("German", GERMAN_RULES_PATTERN, DefaultRules.german()));
        this.getMappingRules().add(new MapRule("Russian", RUSSIAN_RULES_PATTERN, DefaultRules.russian()));
        this.getMappingRules().add(new MapRule("Japanese", JAPANESE_RULES_PATTERN, DefaultRules.japanese()));
        this.getMappingRules().add(new MapRule("English", ENGLISH_RULES_PATTERN, DefaultRules.english()));
        this.getMappingRules().add(new MapRule("Default", DEFAULT_RULES_PATTERN, DefaultRules.defaultLingual()));
        this.getMappingRules().add(new MapRule("Text", DEFAULT_RULES_PATTERN, DefaultRules.textFormat()));
        this.getMappingRules().add(new MapRule("HTML", DEFAULT_RULES_PATTERN, DefaultRules.htmlFormat()));
    }

    public List lookupRulesForLanguage(Language language) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.getMappingRules().size(); ++i) {
            MapRule mapRule = (MapRule)this.getMappingRules().get(i);
            if (!mapRule.getCompiledPattern().matcher(language.getLanguage()).matches()) continue;
            arrayList.addAll(mapRule.getRules());
        }
        return arrayList;
    }

    public boolean isSegmentSubflows() {
        return this.segmentSubflows;
    }

    public void setSegmentSubflows(boolean bl) {
        this.segmentSubflows = bl;
    }

    public boolean isIncludeStartingTags() {
        return this.includeStartingTags;
    }

    public void setIncludeStartingTags(boolean bl) {
        this.includeStartingTags = bl;
    }

    public boolean isIncludeEndingTags() {
        return this.includeEndingTags;
    }

    public void setIncludeEndingTags(boolean bl) {
        this.includeEndingTags = bl;
    }

    public boolean isIncludeIsolatedTags() {
        return this.includeIsolatedTags;
    }

    public void setIncludeIsolatedTags(boolean bl) {
        this.includeIsolatedTags = bl;
    }

    public List getMappingRules() {
        return this.mappingRules;
    }

    public void setMappingRules(List list) {
        this.mappingRules = list;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    static {
        CURRENT_VERSION = OT160RC9_VERSION = "0.2.2";
    }

    static class MyExceptionListener
    implements ExceptionListener {
        private List exceptionsList = new ArrayList();
        private boolean exceptionOccured = false;

        MyExceptionListener() {
        }

        public void exceptionThrown(Exception exception) {
            this.exceptionOccured = true;
            this.exceptionsList.add(exception);
        }

        public boolean isExceptionOccured() {
            return this.exceptionOccured;
        }

        public List getExceptionsList() {
            return this.exceptionsList;
        }
    }
}

