/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.ProjectProperties;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.threads.CommandThread;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;

public final class Segmenter {
    private static Pattern DEFAULT_BEFOREBREAK_PATTERN = Pattern.compile(".", 32);
    private static final Set CJK_LANGUAGES = new HashSet();

    private Segmenter() {
    }

    public static List segment(String string, List arrayList, List list) {
        List list2 = Segmenter.breakParagraph(string, list);
        ArrayList<String> arrayList2 = new ArrayList<String>(list2.size());
        if (arrayList == null) {
            arrayList = new ArrayList<StringBuffer>();
        }
        arrayList.clear();
        for (int i = 0; i < list2.size(); ++i) {
            int n;
            int n2;
            String string2 = (String)list2.get(i);
            int n3 = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < n3 && Character.isWhitespace(string2.charAt(n2)); ++n2) {
                stringBuffer.append(string2.charAt(n2));
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n = n3 - 1; n >= n2 && Character.isWhitespace(string2.charAt(n)); --n) {
                stringBuffer2.append(string2.charAt(n));
            }
            stringBuffer2.reverse();
            String string3 = string2.substring(n2, n + 1);
            arrayList2.add(string3);
            if (arrayList == null) continue;
            arrayList.add(stringBuffer);
            arrayList.add(stringBuffer2);
        }
        return arrayList2;
    }

    private static List breakParagraph(String string, List arrayList) {
        String string2;
        Object object;
        Serializable serializable;
        Language language = new Language(Preferences.getPreference("source_lang"));
        List list = SRX.getSRX().lookupRulesForLanguage(language);
        if (arrayList == null) {
            arrayList = new ArrayList<Rule>();
        }
        TreeSet treeSet = new TreeSet();
        TreeSet treeSet2 = new TreeSet();
        for (int i = list.size() - 1; i >= 0; --i) {
            serializable = (Rule)list.get(i);
            List list2 = Segmenter.getBreaks(string, (Rule)serializable);
            if (((Rule)serializable).isBreakRule()) {
                treeSet2.addAll(list2);
                treeSet.removeAll(list2);
                continue;
            }
            treeSet.addAll(list2);
            treeSet2.removeAll(list2);
        }
        treeSet2.removeAll(treeSet);
        Iterator iterator = treeSet2.iterator();
        serializable = new ArrayList();
        arrayList.clear();
        int n = 0;
        while (iterator.hasNext()) {
            object = (BreakPosition)iterator.next();
            string2 = string.substring(n, ((BreakPosition)object).position);
            serializable.add(string2);
            arrayList.add(((BreakPosition)object).reason);
            n = ((BreakPosition)object).position;
        }
        try {
            object = string.substring(n);
            if (((String)object).trim().length() == 0 && serializable.size() > 0) {
                string2 = (String)serializable.get(serializable.size() - 1);
                string2 = string2 + (String)object;
                serializable.set(serializable.size() - 1, string2);
            } else {
                serializable.add(object);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return serializable;
    }

    private static List getBreaks(String string, Rule rule) {
        ArrayList<BreakPosition> arrayList = new ArrayList<BreakPosition>();
        Matcher matcher = null;
        if (rule.getBeforebreak() != null) {
            matcher = rule.getCompiledBeforebreak().matcher(string);
        }
        Matcher matcher2 = null;
        if (rule.getAfterbreak() != null) {
            matcher2 = rule.getCompiledAfterbreak().matcher(string);
        }
        if (matcher == null && matcher2 == null) {
            return arrayList;
        }
        if (matcher2 != null && !matcher2.find()) {
            return arrayList;
        }
        if (matcher == null) {
            matcher = DEFAULT_BEFOREBREAK_PATTERN.matcher(string);
        }
        while (matcher.find()) {
            int n = matcher.end();
            if (matcher2 == null) {
                arrayList.add(new BreakPosition(n, rule));
                continue;
            }
            int n2 = matcher2.start();
            while (n2 < n) {
                boolean bl = matcher2.find();
                if (!bl) {
                    return arrayList;
                }
                n2 = matcher2.start();
            }
            if (n2 != n) continue;
            arrayList.add(new BreakPosition(n, rule));
        }
        return arrayList;
    }

    public static String glue(List list, List list2, List list3) {
        if (list.size() <= 0) {
            return "";
        }
        ProjectProperties projectProperties = CommandThread.core.getProjectProperties();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append((StringBuffer)list2.get(2 * i - 1));
            stringBuffer2.append((StringBuffer)list2.get(2 * i));
            if (CJK_LANGUAGES.contains(projectProperties.getTargetLanguage().getLanguageCode())) {
                Rule rule = (Rule)list3.get(i - 1);
                char c = stringBuffer.charAt(stringBuffer.length() - 1);
                if (!(c == '.' || PatternConsts.SPACY_REGEX.matcher(rule.getBeforebreak()).matches() && PatternConsts.SPACY_REGEX.matcher(rule.getAfterbreak()).matches())) {
                    stringBuffer2.setLength(0);
                }
            } else if (CJK_LANGUAGES.contains(projectProperties.getSourceLanguage().getLanguageCode()) && stringBuffer2.length() == 0) {
                stringBuffer2.append(" ");
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append((String)list.get(i));
        }
        return stringBuffer.toString();
    }

    static {
        CJK_LANGUAGES.add("ZH");
        CJK_LANGUAGES.add("JA");
        CJK_LANGUAGES.add("KO");
    }

    static class BreakPosition
    implements Comparable {
        int position;
        Rule reason;

        BreakPosition(int n, Rule rule) {
            this.position = n;
            this.reason = rule;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof BreakPosition)) {
                return false;
            }
            BreakPosition breakPosition = (BreakPosition)object;
            return this.position == breakPosition.position;
        }

        public int hashCode() {
            return this.position;
        }

        public int compareTo(Object object) {
            BreakPosition breakPosition = (BreakPosition)object;
            return this.position - breakPosition.position;
        }
    }
}

