/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.Handler;
import org.omegat.filters3.xml.Translator;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLReader;
import org.omegat.filters3.xml.XMLWriter;
import org.omegat.util.Log;
import org.omegat.util.PatternConsts;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLFilter
extends AbstractFilter
implements Translator {
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private XMLDialect dialect;
    private String encoding;

    public XMLFilter(XMLDialect xMLDialect) {
        try {
            this.parserFactory.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dialect = xMLDialect;
    }

    public XMLDialect getDialect() {
        return this.dialect;
    }

    public BufferedReader createReader(File file, String string) throws UnsupportedEncodingException, IOException {
        XMLReader xMLReader = new XMLReader(file, string);
        this.encoding = xMLReader.getEncoding();
        return new BufferedReader(xMLReader);
    }

    public BufferedWriter createWriter(File file, String string) throws UnsupportedEncodingException, IOException {
        if (string == null) {
            string = this.encoding;
        }
        if (file == null) {
            return new BufferedWriter(new StringWriter());
        }
        return new BufferedWriter(new XMLWriter(file, string));
    }

    public List processFile(File file, String string, File file2, String string2) throws IOException, TranslationException {
        try {
            BufferedReader bufferedReader = this.createReader(file, string);
            InputSource inputSource = new InputSource(bufferedReader);
            inputSource.setSystemId("file:///" + file.getCanonicalPath().replace(File.separatorChar, '/'));
            SAXParser sAXParser = this.parserFactory.newSAXParser();
            Handler handler = new Handler(sAXParser, this, this.dialect, file, string, file2, string2);
            sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            sAXParser.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            sAXParser.parse(inputSource, (DefaultHandler)handler);
            bufferedReader.close();
            return handler.getProcessedFiles();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TranslationException(parserConfigurationException.getLocalizedMessage());
        }
        catch (SAXException sAXException) {
            Log.log(sAXException);
            throw new TranslationException(sAXException.getLocalizedMessage());
        }
    }

    protected void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException, TranslationException {
        throw new UnsupportedOperationException("XMLFilter.processFile(BufferedReader,BufferedWriter) should never be called!");
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public String translate(String string) {
        return super.processEntry(string);
    }

    public boolean isFileSupported(BufferedReader bufferedReader) {
        if (this.dialect.getConstraints() == null || this.dialect.getConstraints().size() == 0) {
            return true;
        }
        try {
            Pattern pattern;
            char[] cArray = new char[8192];
            int n = bufferedReader.read(cArray);
            String string = new String(cArray, 0, n);
            Matcher matcher = PatternConsts.XML_DOCTYPE.matcher(string);
            if (matcher.find()) {
                pattern = (Pattern)this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_DOCTYPE);
                if (!(pattern == null || matcher.group(1) != null && pattern.matcher(matcher.group(1)).matches())) {
                    return false;
                }
                Pattern pattern2 = (Pattern)this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_PUBLIC_DOCTYPE);
                if (!(pattern2 == null || matcher.group(3) != null && pattern2.matcher(matcher.group(3)).matches())) {
                    return false;
                }
                Pattern pattern3 = (Pattern)this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_SYSTEM_DOCTYPE);
                if (!(pattern3 == null || matcher.group(5) != null && pattern3.matcher(matcher.group(5)).matches())) {
                    return false;
                }
            } else if (this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_DOCTYPE) || this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_PUBLIC_DOCTYPE) || this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_SYSTEM_DOCTYPE)) {
                return false;
            }
            return !((matcher = PatternConsts.XML_ROOTTAG.matcher(string)).find() ? (pattern = (Pattern)this.dialect.getConstraints().get(XMLDialect.CONSTRAINT_ROOT)) != null && (matcher.group(1) == null || !pattern.matcher(matcher.group(1)).matches()) : this.dialect.getConstraints().containsKey(XMLDialect.CONSTRAINT_ROOT));
        }
        catch (Exception exception) {
            return false;
        }
    }
}

