/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xhtml;

import java.awt.Dialog;
import java.io.File;
import java.io.Serializable;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.xhtml.EditXOptionsDialog;
import org.omegat.filters3.xml.xhtml.XHTMLDialect;
import org.omegat.filters3.xml.xhtml.XHTMLOptions;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class XHTMLFilter
extends XMLFilter {
    private boolean do_not_send_to_core = false;

    public XHTMLFilter() {
        super(new XHTMLDialect());
    }

    public String getFileFormatName() {
        return OStrings.getString("XHTML_FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.html", "UTF-8", "UTF-8"), new Instance("*.xhtml", "UTF-8", "UTF-8")};
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileSupported(File file, String string) {
        boolean bl = super.isFileSupported(file, string);
        if (bl) {
            try {
                this.do_not_send_to_core = true;
                XHTMLDialect xHTMLDialect = (XHTMLDialect)this.getDialect();
                xHTMLDialect.defineDialect((XHTMLOptions)this.getOptions());
                super.processFile(file, string, null, null);
            }
            catch (Exception exception) {
                Log.log("XHTML file " + file.getName() + " is not valid.");
                bl = false;
            }
            finally {
                this.do_not_send_to_core = false;
            }
        }
        return bl;
    }

    public String translate(String string) {
        if (this.do_not_send_to_core) {
            return string;
        }
        return super.translate(string);
    }

    public boolean hasOptions() {
        return true;
    }

    public Serializable changeOptions(Dialog dialog, Serializable serializable) {
        try {
            XHTMLOptions xHTMLOptions = (XHTMLOptions)serializable;
            EditXOptionsDialog editXOptionsDialog = new EditXOptionsDialog(dialog, xHTMLOptions);
            editXOptionsDialog.setVisible(true);
            if (1 == editXOptionsDialog.getReturnStatus()) {
                return editXOptionsDialog.getOptions();
            }
            return serializable;
        }
        catch (Exception exception) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS");
            Log.log(exception);
            return serializable;
        }
    }
}

