/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.util.ArrayList;
import org.omegat.util.xml.XMLAttribute;

public class XMLBlock {
    private String m_text;
    private String m_shortcut;
    private boolean m_isClose;
    private boolean m_isComment;
    private boolean m_isStandalone;
    private boolean m_isTag;
    private boolean m_hasText;
    private char m_typeChar;
    private ArrayList m_attrList;
    private int shortcutNumber;

    public XMLBlock() {
        this.reset();
    }

    private void reset() {
        this.m_text = "";
        this.m_isClose = false;
        this.m_isStandalone = false;
        this.m_isComment = false;
        this.m_isTag = false;
        this.m_typeChar = '\u0000';
        this.m_hasText = false;
        this.m_shortcut = "";
        if (this.m_attrList != null) {
            this.m_attrList.clear();
        }
    }

    public void setAttribute(String string, String string2) {
        XMLAttribute xMLAttribute = new XMLAttribute(string, string2);
        this.setAttribute(xMLAttribute);
    }

    private void setAttribute(XMLAttribute xMLAttribute) {
        if (this.m_attrList == null) {
            this.m_attrList = new ArrayList(8);
        }
        this.m_attrList.add(xMLAttribute);
    }

    public void setText(String string) {
        this.setTag(false);
        this.m_text = string;
        this.m_hasText = false;
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (c != '\t' && c != '\n' && c != '\r' && c != ' ') {
                this.m_hasText = true;
            }
        } else {
            this.m_hasText = true;
        }
    }

    public void setTypeChar(char c) {
        this.m_typeChar = c;
    }

    public void setShortcut(String string) {
        this.m_shortcut = string;
    }

    public String getShortcut() {
        if (this.m_shortcut != null && !this.m_shortcut.equals("")) {
            if (this.m_isClose) {
                return "/" + this.m_shortcut;
            }
            if (this.m_isComment) {
                return "!comment";
            }
        }
        return this.m_shortcut;
    }

    public void setCloseFlag() {
        this.m_isClose = true;
        this.m_isStandalone = false;
    }

    public void setStandaloneFlag() {
        this.m_isStandalone = true;
        this.m_isClose = false;
    }

    public void setComment() {
        this.m_isTag = true;
        this.setTypeChar('!');
        this.m_isComment = true;
        this.m_isClose = false;
        this.m_isStandalone = false;
    }

    public void setTagName(String string) {
        this.setTag(true);
        this.m_text = string;
    }

    private void setTag(boolean bl) {
        this.m_isTag = bl;
    }

    public boolean hasText() {
        return this.m_hasText;
    }

    public boolean isTag() {
        return this.m_isTag;
    }

    public boolean isStandalone() {
        return this.m_isStandalone;
    }

    public boolean isClose() {
        return this.m_isClose;
    }

    public boolean isComment() {
        return this.m_isComment;
    }

    public String getText() {
        if (this.m_typeChar == '?') {
            String string = "<?" + this.m_text;
            if (this.m_attrList != null) {
                for (int i = 0; i < this.m_attrList.size(); ++i) {
                    XMLAttribute xMLAttribute = (XMLAttribute)this.m_attrList.get(i);
                    string = string + " " + xMLAttribute.name + "=\"" + xMLAttribute.value + "\"";
                }
            }
            string = string + "?>";
            return string;
        }
        if (this.m_typeChar == '!') {
            String string = "<!";
            if (this.m_text.equals("CDATA")) {
                string = string + "[";
                string = string + this.m_text;
                string = string + "[";
            } else if (this.m_text.equals("]]")) {
                string = "]]>";
            } else if (this.m_isComment) {
                string = string + "-- ";
                string = string + this.m_text;
                string = string + " -->";
            } else {
                string = string + this.m_text + " ";
                if (this.m_attrList != null && this.m_attrList.size() > 0) {
                    string = string + ((XMLAttribute)this.m_attrList.get((int)0)).name;
                }
                string = string + '>';
            }
            return string;
        }
        if (this.isTag()) {
            String string = "<";
            if (this.m_isClose) {
                string = string + '/';
            }
            string = string + this.m_text;
            if (this.m_attrList != null) {
                for (int i = 0; i < this.m_attrList.size(); ++i) {
                    XMLAttribute xMLAttribute = (XMLAttribute)this.m_attrList.get(i);
                    string = string + " " + xMLAttribute.name + "=\"" + xMLAttribute.value + "\"";
                }
            }
            if (this.m_isStandalone) {
                string = string + " /";
            }
            string = string + '>';
            return string;
        }
        return this.m_text;
    }

    public String getTagName() {
        if (this.isTag()) {
            return this.m_text;
        }
        return "";
    }

    public int numAttributes() {
        if (this.m_attrList == null) {
            return 0;
        }
        return this.m_attrList.size();
    }

    public XMLAttribute getAttribute(int n) {
        if (n < 0 || !this.isTag() || this.m_attrList == null || n > this.m_attrList.size()) {
            return null;
        }
        return (XMLAttribute)this.m_attrList.get(n);
    }

    public String getAttribute(String string) {
        if (!this.isTag() || this.m_attrList == null) {
            return null;
        }
        XMLAttribute xMLAttribute = null;
        for (int i = 0; i < this.m_attrList.size(); ++i) {
            xMLAttribute = (XMLAttribute)this.m_attrList.get(i);
            if (xMLAttribute.name.equals(string)) break;
            xMLAttribute = null;
        }
        if (xMLAttribute == null) {
            return null;
        }
        return xMLAttribute.value;
    }

    public String toString() {
        return this.getText();
    }

    public int getShortcutNumber() {
        return this.shortcutNumber;
    }

    public void setShortcutNumber(int n) {
        this.shortcutNumber = n;
    }
}

