/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;

public class BlancoEclipsePluginGenExpandPluginUtil {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(packageName + ".editors",
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.getLangDoc().getDescriptionList().add(
                "EclipsevOC [" + pluginName + "]̃[eBeBNX");

        fCgClass = fCgFactory
                .createClass(BlancoNameAdjuster.toClassName(pluginName)
                        + "PluginUtil", "EclipsevOC [" + pluginName
                        + "]̃[eBeBNXB");
        fCgSourceFile.getClassList().add(fCgClass);

        if (description != null) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    BlancoJavaSourceUtil.escapeStringAsJavaDoc(description)
                            + "<br>");
        }

        fCgSourceFile.getImportList().add("org.eclipse.core.resources.IFile");
        fCgSourceFile.getImportList().add("org.eclipse.core.resources.IFolder");
        fCgSourceFile.getImportList().add(
                "org.eclipse.core.resources.IResource");
        fCgSourceFile.getImportList().add(
                "org.eclipse.core.runtime.CoreException");
        fCgSourceFile.getImportList().add(
                "org.eclipse.core.runtime.IProgressMonitor");

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "refreshFolder", "vWFNg wtH_XV܂B");
            fCgClass.getMethodList().add(method);

            method.setStatic(true);

            method.getParameterList().add(
                    fCgFactory.createParameter("input",
                            "org.eclipse.core.resources.IFile",
                            "GfB^ݏĂt@C"));
            method.getParameterList().add(
                    fCgFactory.createParameter("monitor",
                            "org.eclipse.core.runtime.IProgressMonitor",
                            "Eclipse̐ij^"));
            method.getParameterList().add(
                    fCgFactory.createParameter("folderName",
                            "java.lang.String", "Ώۂ̃tH_"));
            method.setReturn(fCgFactory.createReturn("boolean", ""));
            method.getThrowList().add(
                    fCgFactory.createException(
                            "org.eclipse.core.runtime.CoreException", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine
                    .add("IFolder folderCheck = input.getProject().getFolder(folderName);");
            listLine.add("// LbVmɃNAB");
            listLine.add("folderCheck.clearHistory(monitor);");
            listLine.add("if (folderCheck.exists()) {");
            listLine
                    .add("folderCheck.refreshLocal(IResource.DEPTH_INFINITE, monitor);");
            listLine.add("return true;");
            listLine.add("}");
            listLine.add("return false;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "createFolder", "vWFNg wtH_쐬܂B");
            fCgClass.getMethodList().add(method);

            method.setStatic(true);

            method.getParameterList().add(
                    fCgFactory.createParameter("input",
                            "org.eclipse.core.resources.IFile",
                            "GfB^ݏĂt@C"));
            method.getParameterList().add(
                    fCgFactory.createParameter("monitor",
                            "org.eclipse.core.runtime.IProgressMonitor",
                            "Eclipse̐ij^"));
            method.getParameterList().add(
                    fCgFactory.createParameter("argFolderName",
                            "java.lang.String", "Ώۂ̃tH_"));
            method.getThrowList().add(
                    fCgFactory.createException(
                            "org.eclipse.core.runtime.CoreException", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("IFolder folderCurrent = null;");
            listLine.add("String folderName = argFolderName;");
            listLine.add("for (boolean found = false; found == false;) {");
            listLine.add("if (folderName.indexOf('/') < 0) {");
            listLine.add("found = true;");
            listLine.add("if (folderCurrent == null) {");
            listLine
                    .add("folderCurrent = input.getProject().getFolder(folderName);");
            listLine.add("} else {");
            listLine
                    .add("folderCurrent = folderCurrent.getFolder(folderName);");
            listLine.add("}");
            listLine.add("} else {");
            listLine
                    .add("String nextFolder = folderName.substring(0, folderName.indexOf('/'));");
            listLine
                    .add("folderName = folderName.substring(folderName.indexOf('/') + 1);");
            listLine.add("if (folderCurrent == null) {");
            listLine
                    .add("folderCurrent = input.getProject().getFolder(nextFolder);");
            listLine.add("} else {");
            listLine
                    .add("folderCurrent = folderCurrent.getFolder(nextFolder);");
            listLine.add("}");
            listLine.add("}");
            listLine.add("if (folderCurrent.exists() == false) {");
            listLine.add("folderCurrent.create(true, true, monitor);");
            listLine.add("}");
            listLine.add("}");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod("findFolder",
                    "vWFNg wtH_܂B");
            fCgClass.getMethodList().add(method);

            method.setStatic(true);

            method.getParameterList().add(
                    fCgFactory.createParameter("input",
                            "org.eclipse.core.resources.IFile",
                            "GfB^ݏĂt@C"));
            method.getParameterList().add(
                    fCgFactory.createParameter("monitor",
                            "org.eclipse.core.runtime.IProgressMonitor",
                            "Eclipse̐ij^"));
            method.getParameterList().add(
                    fCgFactory.createParameter("argFolderName",
                            "java.lang.String", "Ώۂ̃tH_"));
            method.setReturn(fCgFactory.createReturn(
                    "org.eclipse.core.resources.IFolder", ""));
            method.getThrowList().add(
                    fCgFactory.createException(
                            "org.eclipse.core.runtime.CoreException", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("IFolder folderCurrent = null;");
            listLine.add("String folderName = argFolderName;");
            listLine.add("for (boolean found = false; found == false;) {");
            listLine.add("if (folderName.indexOf('/') < 0) {");
            listLine.add("found = true;");
            listLine.add("if (folderCurrent == null) {");
            listLine
                    .add("folderCurrent = input.getProject().getFolder(folderName);");
            listLine.add("} else {");
            listLine
                    .add("folderCurrent = folderCurrent.getFolder(folderName);");
            listLine.add("}");
            listLine.add("} else {");
            listLine
                    .add("String nextFolder = folderName.substring(0, folderName.indexOf('/'));");
            listLine
                    .add("folderName = folderName.substring(folderName.indexOf('/') + 1);");
            listLine.add("if (folderCurrent == null) {");
            listLine
                    .add("folderCurrent = input.getProject().getFolder(nextFolder);");
            listLine.add("} else {");
            listLine
                    .add("folderCurrent = folderCurrent.getFolder(nextFolder);");
            listLine.add("}");
            listLine.add("}");
            listLine.add("}");
            listLine.add("return folderCurrent;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "deleteFolder", "vWFNg wtH_폜܂B");
            fCgClass.getMethodList().add(method);

            method.setStatic(true);

            method.getParameterList().add(
                    fCgFactory.createParameter("input",
                            "org.eclipse.core.resources.IFile",
                            "GfB^ݏĂt@C"));
            method.getParameterList().add(
                    fCgFactory.createParameter("monitor",
                            "org.eclipse.core.runtime.IProgressMonitor",
                            "Eclipse̐ij^"));
            method.getParameterList().add(
                    fCgFactory.createParameter("folderName",
                            "java.lang.String", "Ώۂ̃tH_"));

            method.getThrowList().add(
                    fCgFactory.createException(
                            "org.eclipse.core.runtime.CoreException", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine
                    .add("IFolder folder = findFolder(input, monitor, folderName);");
            listLine.add("if (folder != null) {");
            listLine.add("folder.delete(true, monitor);");
            listLine.add("}");
        }

        // \[XR[hۂɐ܂B
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
