/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.ibatis.task;

import java.io.IOException;

import blanco.ibatis.task.valueobject.BlancoIBatisSqlMap2RowProcessInput;

/**
 * ob`NX [BlancoIBatisSqlMap2RowBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.ibatis.task.BlancoIBatisSqlMap2RowBatchProcess -help
 * </code>
 */
public class BlancoIBatisSqlMap2RowBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoIBatisSqlMap2RowBatchProcess batchProcess = new BlancoIBatisSqlMap2RowBatchProcess();

        // ob`̈B
        final BlancoIBatisSqlMap2RowProcessInput input = new BlancoIBatisSqlMap2RowProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourcedirProcessed = false;
        boolean isFieldJdbcdriverProcessed = false;
        boolean isFieldJdbcurlProcessed = false;
        boolean isFieldJdbcuserProcessed = false;
        boolean isFieldJdbcpasswordProcessed = false;
        boolean isFieldPackageProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcedir=")) {
                input.setSourcedir(arg.substring(11));
                isFieldSourcedirProcessed = true;
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.startsWith("-encoding=")) {
                input.setEncoding(arg.substring(10));
            } else if (arg.startsWith("-jdbcdriver=")) {
                input.setJdbcdriver(arg.substring(12));
                isFieldJdbcdriverProcessed = true;
            } else if (arg.startsWith("-jdbcurl=")) {
                input.setJdbcurl(arg.substring(9));
                isFieldJdbcurlProcessed = true;
            } else if (arg.startsWith("-jdbcuser=")) {
                input.setJdbcuser(arg.substring(10));
                isFieldJdbcuserProcessed = true;
            } else if (arg.startsWith("-jdbcpassword=")) {
                input.setJdbcpassword(arg.substring(14));
                isFieldJdbcpasswordProcessed = true;
            } else if (arg.startsWith("-package=")) {
                input.setPackage(arg.substring(9));
                isFieldPackageProcessed = true;
            } else if (arg.startsWith("-isbindparameter=")) {
                input.setIsbindparameter(Boolean.valueOf(arg.substring(17)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoIBatisSqlMap2RowBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourcedirProcessed == false) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcdriverProcessed == false) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcdriver]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcurlProcessed == false) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcurl]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcuserProcessed == false) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcuser]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcpasswordProcessed == false) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcpassword]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldPackageProcessed == false) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[package]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoIBatisSqlMap2RowProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoIBatisSqlMap2RowProcessC^tF[X blanco.ibatis.taskpbP[W BlancoIBatisSqlMap2RowProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoIBatisSqlMap2RowProcess process = new BlancoIBatisSqlMap2RowProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoIBatisSqlMap2RowProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoIBatisSqlMap2RowBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoIBatisSqlMap2RowBatchProcess: Usage:");
        System.out.println("  java blanco.ibatis.task.BlancoIBatisSqlMap2RowBatchProcess -verbose=l1 -sourcedir=l2 -targetdir=l3 -tmpdir=l4 -encoding=l5 -jdbcdriver=l6 -jdbcurl=l7 -jdbcuser=l8 -jdbcpassword=l9 -package=l10 -isbindparameter=l11");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcedir");
        System.out.println("      [sqlMap t@Ci[fBNgw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetdir");
        System.out.println("      [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[blanco]");
        System.out.println("    -tmpdir");
        System.out.println("      [e|tH_w肵܂Bw̏ꍇɂ́AJgtmpp܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[tmp]");
        System.out.println("    -encoding");
        System.out.println("      [\[Xt@C̕GR[fBOw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("    -jdbcdriver");
        System.out.println("      [JDBChCow肵܂Bex. org.postgresql.Driver]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcurl");
        System.out.println("      [JDBCڑURLw肵܂Bex. jdbc:postgresql]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcuser");
        System.out.println("      [ex. postgres]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcpassword");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -package");
        System.out.println("      [Row o[IuWFNgɕt^pbP[Ww肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -isbindparameter");
        System.out.println("      [p[^oCh邩ǂBoChȂĂ삷̂ł false ̗p]܂BoChȂƓ삵Ȃ JDBC hCoȀꍇɂ true ɐݒ肷KvB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoIBatisSqlMap2RowProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourcedir() == null) {
            throw new IllegalArgumentException("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcedir]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcdriver() == null) {
            throw new IllegalArgumentException("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcdriver]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcurl() == null) {
            throw new IllegalArgumentException("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcurl]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcuser() == null) {
            throw new IllegalArgumentException("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcuser]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcpassword() == null) {
            throw new IllegalArgumentException("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcpassword]ɒlݒ肳Ă܂B");
        }
        if (input.getPackage() == null) {
            throw new IllegalArgumentException("BlancoIBatisSqlMap2RowBatchProcess: JnsB̓p[^[input]̕K{tB[hl[package]ɒlݒ肳Ă܂B");
        }
    }
}
