/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.svnconf;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.svnconf.message.BlancoSvnConfMessage;
import blanco.svnconf.valueobject.BlancoSvnConfStructure;
import blanco.svnconf.valueobject.BlancoSvnConfUserStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uSubversion|Wg`vExcell𒊏o܂B
 * 
 * ̃NX́AXMLt@C\̏𒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoSvnConfParser {
    /**
     * bZ[W`B
     */
    protected final BlancoSvnConfMessage fMsg = new BlancoSvnConfMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoSvnConfStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoSvnConfStructure[] parse(final BlancoXmlDocument argXmlDocument) {
        final List<BlancoSvnConfStructure> listStructure = new ArrayList<BlancoSvnConfStructure>();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List<BlancoXmlElement> listSheet = BlancoXmlBindingUtil
                .getElementsByTagName(elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            final BlancoSvnConfStructure structure = parseElementSheet(elementSheet);
            if (structure != null) {
                // ꂽL܂B
                listStructure.add(structure);
            }
        }

        final BlancoSvnConfStructure[] result = new BlancoSvnConfStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoSvnConfStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoSvnConfStructure structure = new BlancoSvnConfStructure();
        // ̓p[^擾܂B

        final List<BlancoXmlElement> listCommon = BlancoXmlBindingUtil
                .getElementsByTagName(argElementSheet, "blancosvnconf-common");
        if (listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        // ŏ̃ACêݏĂ܂B
        final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                .get(0);

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "name"));
        if (BlancoStringUtil.null2Blank(structure.getName()).length() == 0) {
            return null;
        }

        structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "description"));
        structure.setHostname(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "hostname"));
        structure.setBaseDirectory(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "baseDirectory"));
        structure.setAdministratorName(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "administratorName"));
        structure.setValidityPeriodBegin(parseDate(BlancoXmlBindingUtil
                .getTextContent(elementCommon, "validityPeriodBegin")));
        structure.setValidityPeriodEnd(parseDate(BlancoXmlBindingUtil
                .getTextContent(elementCommon, "validityPeriodEnd")));
        structure.setType(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "type"));
        structure.setAnonymousAuth(BlancoXmlBindingUtil.getTextContent(
                elementCommon, "anonymousAuth"));

        if (BlancoStringUtil.null2Blank(structure.getHostname()).length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbsvnc01(structure
                    .getName()));
        }
        if (BlancoStringUtil.null2Blank(structure.getBaseDirectory()).length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbsvnc02(structure
                    .getName()));
        }
        if (structure.getBaseDirectory().endsWith("/")
                || structure.getBaseDirectory().endsWith("\\")) {
            throw new IllegalArgumentException(fMsg.getMbsvnc06(structure
                    .getName(), structure.getBaseDirectory()));
        }
        if (BlancoStringUtil.null2Blank(structure.getAdministratorName())
                .length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbsvnc08(structure
                    .getName()));
        }

        final BlancoXmlElement elementUserList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancosvnconf-list");
        if (elementUserList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List<BlancoXmlElement> listField = BlancoXmlBindingUtil
                .getElementsByTagName(elementUserList, "user");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);
            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;

            final BlancoSvnConfUserStructure userStructure = new BlancoSvnConfUserStructure();

            userStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "no"));
            userStructure.setName(BlancoXmlBindingUtil.getTextContent(
                    elementField, "name"));
            if (BlancoStringUtil.null2Blank(userStructure.getName()).length() == 0) {
                // namew肳ĂȂꍇɂ͏܂B
                continue;
            }

            userStructure.setAuth(BlancoXmlBindingUtil.getTextContent(
                    elementField, "auth"));
            userStructure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementField, "description"));

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < structure.getUserList().size(); indexPast++) {
                final BlancoSvnConfUserStructure fieldPast = (BlancoSvnConfUserStructure) structure
                        .getUserList().get(indexPast);
                if (fieldPast.getName().equals(userStructure.getName())) {
                    throw new IllegalArgumentException(fMsg.getMbsvnc03(
                            structure.getName(), userStructure.getName()));
                }
            }

            if (userStructure.getName().indexOf('*') >= 0) {
                throw new IllegalArgumentException(fMsg.getMbsvnc05(structure
                        .getName(), userStructure.getName()));
            }
            if (BlancoStringUtil.null2Blank(userStructure.getAuth()).length() == 0) {
                throw new IllegalArgumentException(fMsg.getMbsvnc04(structure
                        .getName(), userStructure.getName()));
            }

            structure.getUserList().add(userStructure);
        }

        return structure;
    }

    /**
     * tp[X܂B
     * 
     * @param arg
     * @return
     */
    private Date parseDate(final String arg) {
        if (arg == null) {
            return null;
        }
        try {
            final SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy/MM/dd");
            return sdFormat.parse(arg);
        } catch (ParseException e) {
            // TODO O̎B
            e.printStackTrace();
            return null;
        }
    }
}
