/*
 * blanco Framework Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.uno;

import java.io.File;

import blanco.report.message.BlancoReportMessage;
import blanco.report.resourcebundle.BlancoUnoResourceBundle;

/**
 * UNOC^tF[Xg OpenOffice.orgǂݍ݉\ȓ̓t@Cgqސēt@C`ւƃRo[gs܂B<br>
 * ǂݍ݂ƏõtH[}bg`ɂ͑gݍ킹̐񂪂܂B<br>
 * ۂɓ삷邩ǂ́AOpenOffice.orgpĊmFĂsĂB<br>
 * ȂÃC^tF[Xł Ȃ肳ꂽt@C̃Ro[ĝ݂s\Ȃ悤ɂȂĂ܂B<br>
 * ܂ÃRo[^[s邽߂ɂ OpenOffice.org 2.0ȍ~KvłB<br>
 * 
 * ƂƂOpenOffice.orgRo[g\ȑgݍ킹̏ڍׂɂĂ͉LURLɏڍׂڂĂ܂B<br>
 * http://framework.openoffice.org/files/documents/25/897/filter_description.
 * html
 * 
 * @author IGA Tosiki
 */
public class BlancoUnoConverter {
    /**
     * bZ[WB
     */
    private final BlancoReportMessage fMsg = new BlancoReportMessage();

    private final BlancoUnoResourceBundle bundle = new BlancoUnoResourceBundle();

    /**
     * UNOC^tF[XɂOpenDocumentCalc`\܂
     */
    public static final String CALC = "StarOffice XML (Calc)";

    /**
     * UNOC^tF[XɂExcel(*.xls)`\܂
     */
    public static final String EXCEL97 = "MS Excel 97";

    /**
     * UNOC^tF[XɂCalc̏ꍇPDF`\܂
     */
    public static final String CALC_PDF = "calc_pdf_Export";

    /**
     * OpenOffice.orgCalcpăRo[gs܂B
     * 
     * @param fileSource
     *            ̓t@C (Calcǂݍ݉\ȃt@Cgqł邱ƂKv)
     * @param fileTarget
     *            o̓t@C (t@Cgqods, xls, pdf̂ꂩw\)
     * @throws IllegalArgumentException
     *             eOꍇBUNO֘Ajart@C̃[hɎsۂɂ܂B
     */
    public void convertAsCalc(final File fileSource, final File fileTarget)
            throws IllegalArgumentException {
        final BlancoUnoInstance unoInstance = newBlancoUnoInstance();
        unoInstance.load(fileSource, bundle
                .getUnoConverterShowopenofficewindow().equals("true"));

        String filterName = null;
        if (fileTarget.getName().endsWith(".ods")) {
            filterName = CALC;
        } else if (fileTarget.getName().endsWith(".xls")) {
            filterName = EXCEL97;
        } else if (fileTarget.getName().endsWith(".pdf")) {
            filterName = CALC_PDF;
        } else {
            throw new IllegalArgumentException(fMsg.getMbrptci1(fileTarget
                    .getName()));
        }
        unoInstance.save(filterName, fileTarget);
    }

    /**
     * BlancoUnoInstancẽCX^X𐶐܂B
     * 
     * @return BlancoUnoInstancẽCX^XB
     * @throws IllegalArgumentException
     *             UNO֘ÃNX̃[hɎsۂɔ܂B
     * 
     */
    private BlancoUnoInstance newBlancoUnoInstance()
            throws IllegalArgumentException {
        try {
            return new BlancoUnoInstance();
        } catch (NoClassDefFoundError er) {
            throw new IllegalArgumentException(fMsg.getMbrptci2(er.toString()));
        }
    }
}
