/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.report.task;

import java.io.IOException;

import blanco.report.task.valueobject.BlancoReportConvertCalcProcessInput;

/**
 * ob`NX [BlancoReportConvertCalcBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.report.task.BlancoReportConvertCalcBatchProcess -help
 * </code>
 */
public class BlancoReportConvertCalcBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoReportConvertCalcBatchProcess batchProcess = new BlancoReportConvertCalcBatchProcess();

        // ob`̈B
        final BlancoReportConvertCalcProcessInput input = new BlancoReportConvertCalcProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldInputProcessed = false;
        boolean isFieldOutputProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-input=")) {
                input.setInput(arg.substring(7));
                isFieldInputProcessed = true;
            } else if (arg.startsWith("-output=")) {
                input.setOutput(arg.substring(8));
                isFieldOutputProcessed = true;
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoReportConvertCalcBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldInputProcessed == false) {
            System.out.println("BlancoReportConvertCalcBatchProcess: JnsB̓p[^[input]̕K{tB[hl[input]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldOutputProcessed == false) {
            System.out.println("BlancoReportConvertCalcBatchProcess: JnsB̓p[^[input]̕K{tB[hl[output]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoReportConvertCalcProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoReportConvertCalcProcessC^tF[X blanco.report.taskpbP[W BlancoReportConvertCalcProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoReportConvertCalcProcess process = new BlancoReportConvertCalcProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoReportConvertCalcProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoReportConvertCalcBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoReportConvertCalcBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoReportConvertCalcBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoReportConvertCalcBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoReportConvertCalcBatchProcess: Usage:");
        System.out.println("  java blanco.report.task.BlancoReportConvertCalcBatchProcess -verbose=l1 -input=l2 -output=l3");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -input");
        System.out.println("      [\vZf[^t@C̃t@CB*.xls, *.ods̊gq̃t@C^܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -output");
        System.out.println("      [\vZf[^t@C܂PDFt@C̃t@CB*.xls, *.ods, *.pdf̊gq̃t@C^܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoReportConvertCalcProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getInput() == null) {
            throw new IllegalArgumentException("BlancoReportConvertCalcBatchProcess: JnsB̓p[^[input]̕K{tB[hl[input]ɒlݒ肳Ă܂B");
        }
        if (input.getOutput() == null) {
            throw new IllegalArgumentException("BlancoReportConvertCalcBatchProcess: JnsB̓p[^[input]̕K{tB[hl[output]ɒlݒ肳Ă܂B");
        }
    }
}
