package blanco.report.task;

import java.io.File;
import java.io.IOException;

import blanco.report.message.BlancoReportMessage;
import blanco.report.task.valueobject.BlancoReportConvertCalcBatchProcessInput;
import blanco.uno.BlancoUnoConverter;

/**
 * ob`NX
 * 
 * 
 * ob`̌ĂяoB <code>
 * java -classpath (NXpX) blanco.report.task.BlancoReportConvertCalcBatchProcess -help
 * </code>
 */
public class BlancoReportConvertCalcBatchProcess extends
        AbstractBlancoReportConvertCalcBatchProcess {
    /**
     * bZ[WB
     */
    private final BlancoReportMessage fMsg = new BlancoReportMessage();

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     * 
     * ̃\bhɎۂ̏eLq܂B
     * 
     * @param input
     *            ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION,
     *         END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int process(final BlancoReportConvertCalcBatchProcessInput input)
            throws IOException, IllegalArgumentException {
        final File fileInput = new File(input.getInput());
        final File fileOutput = new File(input.getOutput());

        if (fileInput.exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbrptca1(fileInput
                    .getAbsolutePath()));
        }
        if (fileInput.isFile() == false) {
            throw new IllegalArgumentException(fMsg.getMbrptca2(fileInput
                    .getAbsolutePath()));
        }
        if (fileInput.canRead() == false) {
            throw new IllegalArgumentException(fMsg.getMbrptca3(fileInput
                    .getAbsolutePath()));
        }
        if (fileOutput.exists() && fileOutput.canWrite() == false) {
            throw new IllegalArgumentException(fMsg.getMbrptca4(fileOutput
                    .getAbsolutePath()));
        }

        new BlancoUnoConverter().convertAsCalc(fileInput, fileOutput);

        return END_SUCCESS;
    }
}
