/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoReportConvertCalc]̃NX
 */
package blanco.report.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.report.task.valueobject.BlancoReportConvertCalcBatchProcessInput;

/**
 * Apache Ant^XN [BlancoReportConvertCalc]̃NXB
 *
 * OpenOffice.orgUNOڑoR \vZf[^t@C𑼌`ɕϊ܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.report.task]BlancoReportConvertCalcBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancoreportconvertcalc&quot; classname=&quot;blanco.report.task.BlancoReportConvertCalcTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoReportConvertCalcTask extends Task {
    /**
     * OpenOffice.orgUNOڑoR \vZf[^t@C𑼌`ɕϊ܂B
     */
    protected BlancoReportConvertCalcBatchProcessInput fInput = new BlancoReportConvertCalcBatchProcessInput();

    /**
     * OpenOffice.orgUNOڑoR \vZf[^t@C𑼌`ɕϊ܂B
     */
    protected boolean fIsFieldInputProcessed = false;

    /**
     * OpenOffice.orgUNOڑoR \vZf[^t@C𑼌`ɕϊ܂B
     */
    protected boolean fIsFieldOutputProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[input]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * \vZf[^t@C̃t@CB*.xls, *.ods̊gq̃t@C^܂B<br>
     *
     * @param arg Zbgl
     */
    public void setInput(final String arg) {
        fInput.setInput(arg);
        fIsFieldInputProcessed = true;
    }

    /**
     * Ant^XN[input]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * \vZf[^t@C̃t@CB*.xls, *.ods̊gq̃t@C^܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getInput() {
        return fInput.getInput();
    }

    /**
     * Ant^XN[output]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * \vZf[^t@C܂PDFt@C̃t@CB*.xls, *.ods, *.pdf̊gq̃t@C^܂B<br>
     *
     * @param arg Zbgl
     */
    public void setOutput(final String arg) {
        fInput.setOutput(arg);
        fIsFieldOutputProcessed = true;
    }

    /**
     * Ant^XN[output]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * \vZf[^t@C܂PDFt@C̃t@CB*.xls, *.ods, *.pdf̊gq̃t@C^܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getOutput() {
        return fInput.getOutput();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoReportConvertCalcTask begin.");

        // ڔԍ[1]AAgr[g[input]͕K{͂łB̓`FbNs܂B
        if (fIsFieldInputProcessed == false) {
            throw new BuildException("K{Agr[g[input]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[output]͕K{͂łB̓`FbNs܂B
        if (fIsFieldOutputProcessed == false) {
            throw new BuildException("K{Agr[g[output]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- input:[" + getInput() + "]");
            System.out.println("- output:[" + getOutput() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            if (new BlancoReportConvertCalcBatchProcess().execute(fInput) != BlancoReportConvertCalcBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
