/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser.util;

import java.util.HashMap;
import java.util.Map;

/**
 * HTML 4.0 GeBeBEZbg̃[eBeBENXB
 * 
 * @author IGA Tosiki
 */
public class BlancoHtmlCharacterEntitySetUtil {
    /**
     * GeBeBl擾邽߂̃}bv擾܂B
     * 
     * @return GeBeBlւ̃}bvB
     */
    public static Map<String, String> getName2ValueMap() {
        Map<String, String> result = new HashMap<String, String>();
        for (int index = 0; index < BlancoHtmlCharacterEntitySetConstants.HTML_40_ENTITY_SET.length; index++) {
            final String[] look = BlancoHtmlCharacterEntitySetConstants.HTML_40_ENTITY_SET[index];
            result.put(look[0], look[1]);
        }
        return result;
    }

    /**
     * l當GeBeB擾邽߂̃}bv擾܂B
     * 
     * @return l當GeBeBւ̃}bvB
     */
    public static Map<String, String> getValue2NameMap() {
        Map<String, String> result = new HashMap<String, String>();
        for (int index = 0; index < BlancoHtmlCharacterEntitySetConstants.HTML_40_ENTITY_SET.length; index++) {
            final String[] look = BlancoHtmlCharacterEntitySetConstants.HTML_40_ENTITY_SET[index];
            result.put(look[1], look[0]);
        }
        return result;
    }
}
