/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ant.util.blanco;

import blanco.ant.util.BlancoAntUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * Apache Antbuild.xml̂ blancop̃^XN𐶐邽߂̃[eBeBNXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoAntBlancoUtil {

    /**
     * blancoŗLjar^XNǉ܂B
     * 
     */
    public static void addTaskJar(final BlancoXmlElement element,
            final String argProjectName, final String argTargetMetaNameLower) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "jar");

        BlancoAntUtil.addEcho(elementTarget, "building jar");
        BlancoAntUtil.addNewLine(elementTarget);

        BlancoAntUtil.addComment(elementTarget,
                "`ǍݒXMLt@C(blancoCalcParserp) Rs[܂B");
        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("copy");
            BlancoAntUtil.addAttribute(elementChild, "file", "src/blanco/"
                    + argTargetMetaNameLower + "/"
                    + BlancoNameAdjuster.toClassName(argProjectName)
                    + "Meta2Xml.xml");
            BlancoAntUtil.addAttribute(elementChild, "todir", "bin/blanco/"
                    + argTargetMetaNameLower);
            BlancoAntUtil.addNewLine(elementTarget);
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "file",
                    "${project.main.jar}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("jar");
            BlancoAntUtil.addAttribute(elementChild, "destfile",
                    "${project.main.jar}");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "doc");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "doc");
            }

            BlancoAntUtil.addComment(elementChild, "class̎荞 (sample͏O)");
            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "bin");
                BlancoAntUtil.addAttribute(elementFileset, "includes", "**/*");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "blanco/sample/**");
            }

            BlancoAntUtil.addComment(elementChild,
                    "Java\[XR[h(ʏ)̎荞 (sample͏O)");
            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "src");
                BlancoAntUtil.addAttribute(elementFileset, "includes", "**/*");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "src");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "blanco/sample/**");
            }

            BlancoAntUtil.addComment(elementChild,
                    "Java\[XR[h()̎荞 (sample͏O)");
            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil
                        .addAttribute(elementFileset, "dir", "blanco/main");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "**/*.java");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "src");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "blanco/sample/**");
            }

            BlancoAntUtil.addComment(elementChild, "vpeBt@C̎荞");
            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil
                        .addAttribute(elementFileset, "dir", "blanco/main");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "**/*.properties");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "blanco/sample/**");
            }
        }
        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    /**
     * blancoŗL̃RpC^XNǉ܂B
     * 
     */
    public static void addTaskCompile(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "compile");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "bin");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("mkdir");
            BlancoAntUtil.addAttribute(elementChild, "dir", "bin");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("javac");
            BlancoAntUtil.addAttribute(elementChild, "destdir", "bin");
            BlancoAntUtil.addAttribute(elementChild, "debug", "true");
            BlancoAntUtil.addAttribute(elementChild, "source", "1.5");
            BlancoAntUtil.addAttribute(elementChild, "target", "1.5");
            BlancoAntUtil.addAttribute(elementChild, "fork", "false");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementSrc = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementSrc);
                elementSrc.setLocalName("src");
                BlancoAntUtil.addAttribute(elementSrc, "path", "blanco/main/");
            }
            {
                final BlancoXmlElement elementSrc = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementSrc);
                elementSrc.setLocalName("src");
                BlancoAntUtil.addAttribute(elementSrc, "path", "src/");
            }

            final BlancoXmlElement elementClasspath = new BlancoXmlElement();
            elementChild.getChildNodes().add(elementClasspath);
            elementClasspath.setLocalName("classpath");
            BlancoAntUtil.addComment(elementClasspath, "ChJ[hňꊇ荞");

            final BlancoXmlElement elementFileset = new BlancoXmlElement();
            elementClasspath.getChildNodes().add(elementFileset);
            elementFileset.setLocalName("fileset");

            BlancoAntUtil.addAttribute(elementFileset, "dir", "lib");
            BlancoAntUtil.addAttribute(elementFileset, "includes", "*.jar");

            final BlancoXmlElement elementPathelement = new BlancoXmlElement();
            elementClasspath.getChildNodes().add(elementPathelement);
            elementPathelement.setLocalName("pathelement");

            BlancoAntUtil
                    .addAttribute(elementPathelement, "path",
                            "${eclipse.dir}/plugins/org.junit_3.8.2.v20080602-1318/junit.jar");

            {
                final BlancoXmlElement elementInclude = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementInclude);
                elementInclude.setLocalName("include");
                BlancoAntUtil.addAttribute(elementInclude, "name", "**/*.java");
                BlancoAntUtil.addNewLine(elementChild);
            }
        }

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    /**
     * blancoŗL̃RpC^XNǉ܂B
     * 
     */
    public static void addTaskCompilePlugin(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "compile");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "bin");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("mkdir");
            BlancoAntUtil.addAttribute(elementChild, "dir", "bin");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("javac");
            BlancoAntUtil.addAttribute(elementChild, "destdir", "bin");
            BlancoAntUtil.addAttribute(elementChild, "debug", "true");
            BlancoAntUtil.addAttribute(elementChild, "source", "1.5");
            BlancoAntUtil.addAttribute(elementChild, "target", "1.5");
            BlancoAntUtil.addAttribute(elementChild, "fork", "false");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementSrc = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementSrc);
                elementSrc.setLocalName("src");
                BlancoAntUtil.addAttribute(elementSrc, "path", "blanco/main/");
            }
            {
                final BlancoXmlElement elementSrc = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementSrc);
                elementSrc.setLocalName("src");
                BlancoAntUtil.addAttribute(elementSrc, "path", "src/");
            }

            final BlancoXmlElement elementClasspath = new BlancoXmlElement();
            elementChild.getChildNodes().add(elementClasspath);
            elementClasspath.setLocalName("classpath");
            BlancoAntUtil.addComment(elementClasspath, "ChJ[hňꊇ荞");

            final BlancoXmlElement elementFileset = new BlancoXmlElement();
            elementClasspath.getChildNodes().add(elementFileset);
            elementFileset.setLocalName("fileset");

            BlancoAntUtil.addAttribute(elementFileset, "dir", "lib");
            BlancoAntUtil.addAttribute(elementFileset, "includes", "*.jar");

            final BlancoXmlElement elementPathelement = new BlancoXmlElement();
            elementClasspath.getChildNodes().add(elementPathelement);
            elementPathelement.setLocalName("pathelement");

            BlancoAntUtil
                    .addAttribute(elementPathelement, "path",
                            "${eclipse.dir}/plugins/org.junit_3.8.2.v20080602-1318/junit.jar");

            final String[] jarNames = { "org.eclipse.core.*.jar",
                    "org.eclipse.equinox.common_*.jar",
                    "org.eclipse.equinox.registry_*.jar",
                    "org.eclipse.jface_*.jar", "org.eclipse.osgi_*.jar",
                    "org.eclipse.text_*.jar", "org.eclipse.ui.*.jar" };
            for (int index = 0; index < jarNames.length; index++) {
                final BlancoXmlElement elementFilesetEclipse = new BlancoXmlElement();
                elementClasspath.getChildNodes().add(elementFilesetEclipse);
                elementFilesetEclipse.setLocalName("fileset");

                BlancoAntUtil.addAttribute(elementFilesetEclipse, "dir",
                        "${eclipse.dir}/plugins");
                BlancoAntUtil.addAttribute(elementFilesetEclipse, "includes",
                        jarNames[index]);
            }

            {
                final BlancoXmlElement elementInclude = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementInclude);
                elementInclude.setLocalName("include");
                BlancoAntUtil.addAttribute(elementInclude, "name", "**/*.java");
                BlancoAntUtil.addNewLine(elementChild);
            }
        }

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    /**
     * blancoŗLjavadocǉ܂B
     * 
     */
    public static void addTaskJavadoc(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "javadoc");

        BlancoAntUtil.addEcho(elementTarget, "JavaDoc𐶐܂B");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "javadoc");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("javadoc");
            BlancoAntUtil.addAttribute(elementChild, "destdir", "javadoc");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("fileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "src");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "**/*.java");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("fileset");

                BlancoAntUtil
                        .addAttribute(elementFileset, "dir", "blanco/main");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "**/*.java");
            }

            final BlancoXmlElement elementClasspath = new BlancoXmlElement();
            elementChild.getChildNodes().add(elementClasspath);
            elementClasspath.setLocalName("classpath");

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementClasspath.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("fileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "lib");
                BlancoAntUtil.addAttribute(elementFileset, "includes", "*.jar");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementClasspath.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("fileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "lib.ant");
                BlancoAntUtil.addAttribute(elementFileset, "includes", "*.jar");
            }
        }

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    /**
     * Cupmetaev[g
     * 
     * @param element
     */
    public static void addTaskMeta4Lib(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "meta");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancoanttask");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancoconstants");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancomessage");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancometa2xml");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancoresourcebundle");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "commenttimestamp",
                    "false");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancovalueobject");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        BlancoAntUtil.addNewLine(elementTarget);
        BlancoAntUtil.addComment(elementTarget, "TODO: Ɏgant^XNǉĂB");

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    public static void addTaskMeta4Plugin(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "meta");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancoeclipseplugingen");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("blancoconstants");
            BlancoAntUtil.addAttribute(elementChild, "metadir", "meta/program");
            BlancoAntUtil.addAttribute(elementChild, "encoding", "${encoding}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    /**
     * blancoŗLpack^XNǉ܂B
     * 
     * @param element
     */
    public static void addTaskPack4Lib(final BlancoXmlElement element,
            final String argProjectName) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "pack");

        BlancoAntUtil.addEcho(elementTarget, "packing project");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "file", "${project.zip}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "bin");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "javadoc");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        BlancoAntUtil.addNewLine(elementTarget);

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "tmp");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        BlancoAntUtil.addNewLine(elementTarget);

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("copy");
            BlancoAntUtil.addAttribute(elementChild, "todir", "lib.ant");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("fileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", ".");

                {
                    final BlancoXmlElement elementInclude = new BlancoXmlElement();
                    elementFileset.getChildNodes().add(elementInclude);
                    elementInclude.setLocalName("include");

                    BlancoAntUtil.addAttribute(elementInclude, "name",
                            "${project.lower}-*.jar");
                }
                BlancoAntUtil.addNewLine(elementTarget);
            }
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("fileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", ".");

                {
                    final BlancoXmlElement elementInclude = new BlancoXmlElement();
                    elementFileset.getChildNodes().add(elementInclude);
                    elementInclude.setLocalName("include");

                    BlancoAntUtil.addAttribute(elementInclude, "name",
                            "${project.lower}-*.jar");
                }
                BlancoAntUtil.addNewLine(elementTarget);
            }
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("zip");
            BlancoAntUtil.addAttribute(elementChild, "destfile",
                    "${project.zip}");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", ".");
                BlancoAntUtil.addAttribute(elementFileset, "prefix",
                        "${project}");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "${project.zip},**/*.class");

                BlancoAntUtil.addNewLine(elementTarget);
            }
        }

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    public static void addTaskPack4Plugin(final BlancoXmlElement element,
            final String argProjectName, final String argTargetMetaNameLower) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "pack");

        BlancoAntUtil.addEcho(elementTarget, "packing project");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "file", "${project.zip}");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "file", "bin/blanco"
                    + argTargetMetaNameLower + "plugin.jar");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        BlancoAntUtil.addNewLine(elementTarget);

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "javadoc");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "dir", "tmp");
            BlancoAntUtil.addNewLine(elementTarget);
        }

        BlancoAntUtil.addNewLine(elementTarget);

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("zip");
            BlancoAntUtil.addAttribute(elementChild, "destfile",
                    "${project.zip}");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", ".");
                BlancoAntUtil.addAttribute(elementFileset, "prefix",
                        argProjectName + "Plugin");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "${project.plugin32.jar},${project.zip},**/*.class");
            }
        }

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    /**
     * Cupbuildev[g
     * 
     * @param element
     */
    public static void addTaskBuild4Lib(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "build");
        BlancoAntUtil.addAttribute(elementTarget, "depends",
                "meta,compile,jar,pack");

        BlancoAntUtil.addNewLine(elementTarget);

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    public static void addTaskBuild4Plugin(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "build");
        BlancoAntUtil.addAttribute(elementTarget, "depends",
                "meta,compile,build-plugin,pack");

        BlancoAntUtil.addNewLine(elementTarget);

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    public static void addTaskBuildPlugin(final BlancoXmlElement element,
            final String argProjectName, final String argTargetMetaNameLower) {
        BlancoAntUtil.addIndentTab(element);

        final BlancoXmlElement elementTarget = new BlancoXmlElement();
        element.getChildNodes().add(elementTarget);
        elementTarget.setLocalName("target");

        BlancoAntUtil.addAttribute(elementTarget, "name", "build-plugin");

        BlancoAntUtil.addEcho(elementTarget, "building plugin");
        BlancoAntUtil.addNewLine(elementTarget);
        BlancoAntUtil.addEcho(elementTarget, "OɃRpCĂ邱ƂKvł");

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "file",
                    "bin/${project.plugin.main.jar}");
        }

        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("jar");
            BlancoAntUtil.addAttribute(elementChild, "destfile",
                    "bin/${project.plugin.main.jar}");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "bin");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "${project.plugin.jar},${project.plugin.main.jar}");
            }

            BlancoAntUtil.addComment(elementChild, "Java\[XR[h(ʏ)̎荞");
            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "src");
                BlancoAntUtil.addAttribute(elementFileset, "includes", "**/*");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "src");
            }

            BlancoAntUtil.addComment(elementChild,
                    "Java\[XR[h()̎荞 (sample͏O)");
            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil
                        .addAttribute(elementFileset, "dir", "blanco/main");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "**/*.java");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "src");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "blanco/sample/**");
            }

            BlancoAntUtil.addComment(elementChild, "vpeBt@C̎荞");
            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil
                        .addAttribute(elementFileset, "dir", "blanco/main");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "**/*.properties");
                BlancoAntUtil.addAttribute(elementFileset, "excludes",
                        "blanco/sample/**");
            }
        }

        BlancoAntUtil.addNewLine(elementTarget);
        BlancoAntUtil
                .addComment(elementTarget, "Eclipse 3.2p JARt@CƂăA[JCu");
        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("delete");
            BlancoAntUtil.addAttribute(elementChild, "file",
                    "${project.plugin32.jar}");
        }
        {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            elementTarget.getChildNodes().add(elementChild);
            elementChild.setLocalName("jar");
            BlancoAntUtil.addAttribute(elementChild, "destfile",
                    "${project.plugin32.jar}");
            BlancoAntUtil.addAttribute(elementChild, "manifest",
                    "META-INF/MANIFEST.MF");
            BlancoAntUtil.addNewLine(elementTarget);

            {
                // MANIFESTZNVB
                final BlancoXmlElement elementManifest = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementManifest);
                elementManifest.setLocalName("manifest");

                final BlancoXmlElement elementAttribute = new BlancoXmlElement();
                elementManifest.getChildNodes().add(elementAttribute);
                elementAttribute.setLocalName("attribute");
                BlancoAntUtil.addAttribute(elementAttribute, "name",
                        "Bundle-Version");
                BlancoAntUtil.addAttribute(elementAttribute, "value",
                        "${version}");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "icons");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "icons");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "lib");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "lib");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "blanco*.jar,jxl*.jar");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "doc");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "doc");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "meta");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "meta");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "file", "bin/blanco"
                        + argTargetMetaNameLower + "plugin.jar");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "lib");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", "bin");
                BlancoAntUtil.addAttribute(elementFileset, "prefix", "lib");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "${project.plugin.jar}");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", ".");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "plugin.xml");
            }

            {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementChild.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("zipfileset");

                BlancoAntUtil.addAttribute(elementFileset, "dir", ".");
                BlancoAntUtil.addAttribute(elementFileset, "includes",
                        "about.html");
            }
        }

        BlancoAntUtil.addNewLine(element);
        BlancoAntUtil.addNewLine(element);
    }

    /**
     * DotNetɂRpCB
     * 
     * @param element
     */
    public static void addTaskDotNetCompile(final BlancoXmlElement element) {
        BlancoAntUtil.addIndentTab(element);

        BlancoAntUtil.addComment(element,
                ".NET Framework SDK ɂRpC̃ZNV:begin");

        {
            final BlancoXmlElement elementTarget = new BlancoXmlElement();
            element.getChildNodes().add(elementTarget);
            elementTarget.setLocalName("target");

            BlancoAntUtil.addAttribute(elementTarget, "name", "compile.cs");

            {
                final BlancoXmlElement elementChild = new BlancoXmlElement();
                elementTarget.getChildNodes().add(elementChild);
                elementChild.setLocalName("exec");
                BlancoAntUtil.addAttribute(elementChild, "executable",
                        "${dotnet.dir}\\csc.exe");

                {
                    BlancoXmlElement elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/target:library");
                    elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/out:tmp/blancolib.dll");
                    elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/doc:tmp/blancolib.xml");
                    elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/recurse:*.cs");
                    BlancoAntUtil.addNewLine(elementChild);
                }
            }

            BlancoAntUtil.addNewLine(element);
            BlancoAntUtil.addNewLine(element);
        }

        {
            final BlancoXmlElement elementTarget = new BlancoXmlElement();
            element.getChildNodes().add(elementTarget);
            elementTarget.setLocalName("target");

            BlancoAntUtil.addAttribute(elementTarget, "name", "compile.vb");

            {
                final BlancoXmlElement elementChild = new BlancoXmlElement();
                elementTarget.getChildNodes().add(elementChild);
                elementChild.setLocalName("exec");
                BlancoAntUtil.addAttribute(elementChild, "executable",
                        "${dotnet.dir}\\vbc.exe");

                {
                    BlancoXmlElement elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/target:library");
                    elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/out:tmp/blancolib.dll");
                    elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/doc:tmp/blancolib.xml");
                    elementArg = new BlancoXmlElement();
                    elementChild.getChildNodes().add(elementArg);
                    elementArg.setLocalName("arg");
                    BlancoAntUtil.addAttribute(elementArg, "line",
                            "/recurse:*.vb");
                    BlancoAntUtil.addNewLine(elementChild);
                }
            }

            BlancoAntUtil.addNewLine(element);
        }

        BlancoAntUtil.addComment(element,
                ".NET Framework SDK ɂRpC̃ZNV:end");
    }
}
