/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.WordIterator;
import org.omegat.util.PatternConsts;
import org.omegat.util.Token;

public class Tokenizer
implements ITokenizer {
    private static Map<String, Token[]> tokenCache = new HashMap<String, Token[]>(5000);
    private static final Token[] EMPTY_TOKENS_LIST = new Token[0];

    public Tokenizer() {
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                if (pROJECT_CHANGE_TYPE == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                    Map map = tokenCache;
                    synchronized (map) {
                        tokenCache.clear();
                    }
                }
            }
        });
    }

    public Token[] tokenizeWordsForSpelling(String string) {
        return Tokenizer.tokenizeTextNoCache(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token[] tokenizeWords(String string, ITokenizer.StemmingMode stemmingMode) {
        Token[] tokenArray;
        Map<String, Token[]> map = tokenCache;
        synchronized (map) {
            tokenArray = tokenCache.get(string);
        }
        if (tokenArray != null) {
            return tokenArray;
        }
        tokenArray = Tokenizer.tokenizeTextNoCache(string, false);
        map = tokenCache;
        synchronized (map) {
            tokenCache.put(string, tokenArray);
        }
        return tokenArray;
    }

    public Token[] tokenizeAllExactly(String string) {
        return Tokenizer.tokenizeTextNoCache(string, true);
    }

    private static Token[] tokenizeTextNoCache(String string, boolean bl) {
        if (string.length() == 0) {
            return EMPTY_TOKENS_LIST;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>(64);
        String string2 = string.toLowerCase();
        BreakIterator breakIterator = Tokenizer.getWordBreaker();
        breakIterator.setText(string2);
        int n = breakIterator.first();
        int n2 = breakIterator.next();
        while (n2 != -1) {
            String string3 = string2.substring(n, n2);
            boolean bl2 = false;
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (!Character.isLetter(c)) continue;
                bl2 = true;
                break;
            }
            if (bl || bl2 && !PatternConsts.OMEGAT_TAG.matcher(string3).matches()) {
                Token token = new Token(string3, n);
                arrayList.add(token);
            }
            n = n2;
            n2 = breakIterator.next();
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    public static BreakIterator getWordBreaker() {
        return new WordIterator();
    }

    public static boolean isContains(Token[] tokenArray, Token token) {
        for (Token token2 : tokenArray) {
            if (!token.equals(token2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsAll(Token[] tokenArray, Token[] tokenArray2) {
        for (Token token : tokenArray2) {
            if (Tokenizer.isContains(tokenArray, token)) continue;
            return false;
        }
        return true;
    }
}

