/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Segmenter {
    private static Pattern DEFAULT_BEFOREBREAK_PATTERN = Pattern.compile(".", 32);
    private static final Set<String> CJK_LANGUAGES = new HashSet<String>();

    private Segmenter() {
    }

    public static List<String> segment(Language language, String string, List<StringBuffer> list, List<Rule> list2) {
        List<String> list3 = Segmenter.breakParagraph(language, string, list2);
        ArrayList<String> arrayList = new ArrayList<String>(list3.size());
        if (list == null) {
            list = new ArrayList<StringBuffer>();
        }
        list.clear();
        for (String string2 : list3) {
            int n;
            int n2;
            int n3 = string2.length();
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < n3 && Character.isWhitespace(string2.charAt(n2)); ++n2) {
                stringBuffer.append(string2.charAt(n2));
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n = n3 - 1; n >= n2 && Character.isWhitespace(string2.charAt(n)); --n) {
                stringBuffer2.append(string2.charAt(n));
            }
            stringBuffer2.reverse();
            String string3 = string2.substring(n2, n + 1);
            arrayList.add(string3);
            if (list == null) continue;
            list.add(stringBuffer);
            list.add(stringBuffer2);
        }
        return arrayList;
    }

    private static List<String> breakParagraph(Language language, String string, List<Rule> list) {
        Object object;
        List<Rule> list2 = SRX.getSRX().lookupRulesForLanguage(language);
        if (list == null) {
            list = new ArrayList<Rule>();
        }
        TreeSet<BreakPosition> treeSet = new TreeSet<BreakPosition>();
        TreeSet<BreakPosition> treeSet2 = new TreeSet<BreakPosition>();
        for (int i = list2.size() - 1; i >= 0; --i) {
            Rule rule = list2.get(i);
            object = Segmenter.getBreaks(string, rule);
            if (rule.isBreakRule()) {
                treeSet2.addAll((Collection<BreakPosition>)object);
                treeSet.removeAll((Collection<?>)object);
                continue;
            }
            treeSet.addAll((Collection<BreakPosition>)object);
            treeSet2.removeAll((Collection<?>)object);
        }
        treeSet2.removeAll(treeSet);
        ArrayList<String> arrayList = new ArrayList<String>();
        list.clear();
        int n = 0;
        for (BreakPosition object2 : treeSet2) {
            String string2 = string.substring(n, object2.position);
            arrayList.add(string2);
            list.add(object2.reason);
            n = object2.position;
        }
        try {
            object = string.substring(n);
            if (((String)object).trim().length() == 0 && arrayList.size() > 0) {
                String string4 = (String)arrayList.get(arrayList.size() - 1);
                string4 = string4 + (String)object;
                arrayList.set(arrayList.size() - 1, string4);
            } else {
                arrayList.add((String)object);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return arrayList;
    }

    private static List<BreakPosition> getBreaks(String string, Rule rule) {
        ArrayList<BreakPosition> arrayList = new ArrayList<BreakPosition>();
        Matcher matcher = null;
        if (rule.getBeforebreak() != null) {
            matcher = rule.getCompiledBeforebreak().matcher(string);
        }
        Matcher matcher2 = null;
        if (rule.getAfterbreak() != null) {
            matcher2 = rule.getCompiledAfterbreak().matcher(string);
        }
        if (matcher == null && matcher2 == null) {
            return arrayList;
        }
        if (matcher2 != null && !matcher2.find()) {
            return arrayList;
        }
        if (matcher == null) {
            matcher = DEFAULT_BEFOREBREAK_PATTERN.matcher(string);
        }
        while (matcher.find()) {
            int n = matcher.end();
            if (matcher2 == null) {
                arrayList.add(new BreakPosition(n, rule));
                continue;
            }
            int n2 = matcher2.start();
            while (n2 < n) {
                boolean bl = matcher2.find();
                if (!bl) {
                    return arrayList;
                }
                n2 = matcher2.start();
            }
            if (n2 != n) continue;
            arrayList.add(new BreakPosition(n, rule));
        }
        return arrayList;
    }

    public static String glue(Language language, Language language2, List<String> list, List<StringBuffer> list2, List<Rule> list3) {
        if (list.size() <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(list2.get(2 * i - 1));
            stringBuffer2.append(list2.get(2 * i));
            if (CJK_LANGUAGES.contains(language2.getLanguageCode())) {
                Rule rule = list3.get(i - 1);
                char c = stringBuffer.charAt(stringBuffer.length() - 1);
                if (!(c == '.' || PatternConsts.SPACY_REGEX.matcher(rule.getBeforebreak()).matches() && PatternConsts.SPACY_REGEX.matcher(rule.getAfterbreak()).matches())) {
                    stringBuffer2.setLength(0);
                }
            } else if (CJK_LANGUAGES.contains(language.getLanguageCode()) && stringBuffer2.length() == 0) {
                stringBuffer2.append(" ");
            }
            stringBuffer.append(stringBuffer2);
            stringBuffer.append(list.get(i));
        }
        return stringBuffer.toString();
    }

    static {
        CJK_LANGUAGES.add("ZH");
        CJK_LANGUAGES.add("JA");
        CJK_LANGUAGES.add("KO");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BreakPosition
    implements Comparable<BreakPosition> {
        int position;
        Rule reason;

        BreakPosition(int n, Rule rule) {
            this.position = n;
            this.reason = rule;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof BreakPosition)) {
                return false;
            }
            BreakPosition breakPosition = (BreakPosition)object;
            return this.position == breakPosition.position;
        }

        public int hashCode() {
            return this.position;
        }

        @Override
        public int compareTo(BreakPosition breakPosition) {
            return this.position - breakPosition.position;
        }
    }
}

