/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation.datamodels;

import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.table.AbstractTableModel;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingRulesModel
extends AbstractTableModel {
    private SRX srx;
    private static String[] COLUMN_NAMES = new String[]{OStrings.getString("CORE_SRX_TABLE_HEADER_Language_Name"), OStrings.getString("CORE_SRX_TABLE_HEADER_Language_Pattern")};
    protected List<ExceptionListener> listeners = new ArrayList<ExceptionListener>();

    public MappingRulesModel(SRX sRX) {
        this.srx = sRX;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MapRule mapRule = this.srx.getMappingRules().get(n);
        switch (n2) {
            case 0: {
                return mapRule.getLanguage();
            }
            case 1: {
                return mapRule.getPattern();
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.srx.getMappingRules().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        MapRule mapRule = this.srx.getMappingRules().get(n);
        switch (n2) {
            case 0: {
                mapRule.setLanguage((String)object);
                break;
            }
            case 1: {
                try {
                    mapRule.setPattern((String)object);
                    break;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.fireException(patternSyntaxException);
                }
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    public int addRow() {
        int n = this.srx.getMappingRules().size();
        this.srx.getMappingRules().add(new MapRule(OStrings.getString("SEG_NEW_LN_CO"), "LN-CO", new ArrayList<Rule>()));
        this.fireTableRowsInserted(n, n);
        return n;
    }

    public void removeRow(int n) {
        this.srx.getMappingRules().remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void moveRowUp(int n) {
        MapRule mapRule = this.srx.getMappingRules().get(n - 1);
        MapRule mapRule2 = this.srx.getMappingRules().get(n);
        this.srx.getMappingRules().remove(n - 1);
        this.srx.getMappingRules().add(n, mapRule);
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void moveRowDown(int n) {
        MapRule mapRule = this.srx.getMappingRules().get(n + 1);
        MapRule mapRule2 = this.srx.getMappingRules().get(n);
        this.srx.getMappingRules().remove(n + 1);
        this.srx.getMappingRules().add(n, mapRule);
        this.fireTableRowsUpdated(n, n + 1);
    }

    public void addExceptionListener(ExceptionListener exceptionListener) {
        this.listeners.add(exceptionListener);
    }

    public void removeTableModelListener(ExceptionListener exceptionListener) {
        this.listeners.remove(exceptionListener);
    }

    public void fireException(Exception exception) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ExceptionListener exceptionListener = this.listeners.get(i);
            exceptionListener.exceptionThrown(exception);
        }
    }
}

