/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TransMemory;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class SearchThread
extends Thread {
    private SearchWindow m_window;
    private boolean m_searching;
    private String m_searchDir;
    private boolean m_searchRecursive;
    private String m_curFileName;
    private boolean m_tmSearch;
    private Set<String> m_entrySet;
    private List<Matcher> m_matchers;
    private int m_numFinds;

    public SearchThread(MainWindow mainWindow, SearchWindow searchWindow, String string) {
        this.setPriority(1);
        this.m_window = searchWindow;
        this.m_searchDir = null;
        this.m_searchRecursive = false;
        this.m_searching = false;
        this.m_tmSearch = false;
        this.m_entrySet = null;
        this.m_numFinds = 0;
        this.m_curFileName = "";
    }

    public void requestSearch(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (!this.m_searching) {
            int n;
            this.m_searchDir = string2;
            this.m_searchRecursive = bl;
            this.m_tmSearch = bl6;
            this.m_searching = true;
            this.m_entrySet = new HashSet<String>();
            this.m_matchers = new ArrayList<Matcher>();
            int n2 = n = bl4 ? 0 : 66;
            if (bl2) {
                if (!bl5) {
                    string = StaticUtils.escapeNonRegex(string, false);
                }
                this.m_matchers.add(Pattern.compile(string, n).matcher(""));
            } else if ((string = string.trim()).length() > 0) {
                int n3 = 0;
                while (n3 < string.length()) {
                    String string3;
                    int n4 = string.indexOf(32, n3);
                    String string4 = string3 = n4 == -1 ? string.substring(n3, string.length()).trim() : string.substring(n3, n4).trim();
                    if (string3.length() > 0) {
                        if (!bl5) {
                            string3 = StaticUtils.escapeNonRegex(string3, false);
                        }
                        this.m_matchers.add(Pattern.compile(string3, n).matcher(""));
                    }
                    n3 = n4 == -1 ? string.length() : n4 + 1;
                }
            }
        }
    }

    public void run() {
        boolean bl = true;
        try {
            while (!SearchThread.interrupted()) {
                try {
                    SearchThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
                if (bl) {
                    bl = false;
                    this.m_window.setSearchControlFocus();
                }
                if (!this.m_searching) continue;
                if (this.m_searchDir == null) {
                    this.searchProject();
                } else {
                    try {
                        this.searchFiles();
                    }
                    catch (IOException iOException) {
                        Log.logErrorRB(iOException, "ST_FILE_SEARCH_ERROR", new Object[0]);
                        Core.getMainWindow().displayErrorRB(iOException, "ST_FILE_SEARCH_ERROR", new Object[0]);
                    }
                    catch (TranslationException translationException) {
                        Log.logErrorRB(translationException, "ST_FILE_SEARCH_ERROR", new Object[0]);
                        Core.getMainWindow().displayErrorRB(translationException, "ST_FILE_SEARCH_ERROR", new Object[0]);
                    }
                }
                if (this.m_numFinds == 0) {
                    this.m_window.postMessage(OStrings.getString("ST_NOTHING_FOUND"));
                }
                this.m_window.displayResults();
                this.m_searching = false;
                this.m_entrySet = null;
            }
        }
        catch (RuntimeException runtimeException) {
            Log.logErrorRB(runtimeException, "ST_FATAL_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(runtimeException, "ST_FATAL_ERROR", new Object[0]);
            this.m_window.threadDied();
        }
    }

    private void foundString(int n, String string, String string2, String string3) {
        if (this.m_numFinds++ > 1000) {
            return;
        }
        if (n >= 0) {
            if (!this.m_entrySet.contains(string2 + string3)) {
                this.m_window.addEntry(n + 1, null, n + 1 + "> " + string2, string3);
                this.m_entrySet.add(string2 + string3);
            }
        } else {
            this.m_window.addEntry(n, string, string2, string3);
        }
        if (this.m_numFinds >= 1000) {
            this.m_window.postMessage(StaticUtils.format(OStrings.getString("SW_MAX_FINDS_REACHED"), new Integer(1000)));
        }
    }

    private void searchProject() {
        String string;
        String string2;
        IProject iProject = Core.getProject();
        this.m_numFinds = 0;
        IProject iProject2 = Core.getProject();
        for (int i = 0; i < iProject.getAllEntries().size(); ++i) {
            SourceTextEntry object = iProject2.getAllEntries().get(i);
            string2 = object.getSrcText();
            string = object.getTranslation();
            if (this.searchString(string2) || this.searchString(string)) {
                this.foundString(i, null, string2, string);
            }
            if (this.m_numFinds >= 1000) break;
        }
        if (this.m_tmSearch) {
            for (TransMemory transMemory : Core.getProject().getTransMemory()) {
                string2 = transMemory.source;
                string = transMemory.target;
                if (this.searchString(string2) || this.searchString(string)) {
                    this.foundString(-1, transMemory.file, string2, string);
                }
                if (this.m_numFinds < 1000) continue;
                break;
            }
        }
    }

    private void searchFiles() throws IOException, TranslationException {
        ArrayList<String> arrayList = new ArrayList<String>(256);
        if (!this.m_searchDir.endsWith(File.separator)) {
            this.m_searchDir = this.m_searchDir + File.separator;
        }
        StaticUtils.buildFileList(arrayList, new File(this.m_searchDir), this.m_searchRecursive);
        FilterMaster filterMaster = FilterMaster.getInstance();
        HashSet<File> hashSet = new HashSet<File>();
        for (String string : arrayList) {
            File file = new File(string);
            if (hashSet.contains(file)) continue;
            this.m_curFileName = string.substring(this.m_searchDir.length());
            filterMaster.loadFile(string, hashSet, new ParseEntry(Core.getProject().getProjectProperties()){

                protected String processSingleEntry(String string) {
                    SearchThread.this.searchText(string);
                    return string;
                }
            });
        }
    }

    private boolean searchString(String string) {
        if (string == null || this.m_matchers == null || this.m_matchers.isEmpty()) {
            return false;
        }
        for (Matcher matcher : this.m_matchers) {
            matcher.reset(string);
            if (matcher.find()) continue;
            return false;
        }
        return true;
    }

    public void searchText(String string) {
        if (this.m_numFinds >= 1000) {
            return;
        }
        if (this.searchString(string)) {
            this.foundString(-1, this.m_curFileName, string, null);
        }
    }
}

