/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Matcher;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.PatternConsts;

public class HTMLWriter
extends Writer {
    private StringWriter writer;
    private BufferedWriter realWriter;
    private String HTML_META;
    private String XML_HEADER;
    private String encoding;
    private HTMLOptions options;
    private final int minHeaderedBufferSize = 4096;
    private final int maxBufferSize = 65536;
    private boolean signalClosing = false;
    private boolean signalAlreadyFlushed = false;

    public HTMLWriter(String string, String string2, HTMLOptions hTMLOptions) throws FileNotFoundException, UnsupportedEncodingException {
        this.encoding = string2;
        this.options = hTMLOptions != null ? hTMLOptions : new HTMLOptions();
        this.writer = new StringWriter();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter((OutputStream)fileOutputStream, string2) : new OutputStreamWriter(fileOutputStream);
        this.realWriter = new BufferedWriter(outputStreamWriter);
    }

    public void close() throws IOException {
        this.signalClosing = true;
        this.flush();
        this.realWriter.close();
    }

    public void flush() throws IOException {
        StringBuffer stringBuffer = this.writer.getBuffer();
        if (this.signalAlreadyFlushed || this.encoding == null) {
            this.realWriter.write(stringBuffer.toString());
            stringBuffer.setLength(0);
        } else if (this.signalClosing || stringBuffer.length() >= 4096) {
            this.signalAlreadyFlushed = true;
            String string = stringBuffer.toString();
            if (this.options.getRewriteEncoding() != 4) {
                Matcher matcher = PatternConsts.XML_HEADER.matcher(string);
                boolean bl = false;
                if (matcher.find()) {
                    this.XML_HEADER = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>";
                    string = matcher.replaceFirst(this.XML_HEADER);
                    bl = true;
                }
                this.HTML_META = "<meta http-equiv=\"content-type\" content=\"text/html; charset=" + this.encoding + "\"";
                this.HTML_META = bl ? this.HTML_META + " />" : this.HTML_META + ">";
                Matcher matcher2 = PatternConsts.HTML_ENCODING.matcher(string);
                if (matcher2.find()) {
                    string = matcher2.replaceFirst(this.HTML_META);
                } else if (this.options.getRewriteEncoding() != 3) {
                    Matcher matcher3 = PatternConsts.HTML_HEAD.matcher(string);
                    if (matcher3.find()) {
                        string = matcher3.replaceFirst("<head>\n    " + this.HTML_META);
                    } else if (this.options.getRewriteEncoding() != 2) {
                        Matcher matcher4 = PatternConsts.HTML_HTML.matcher(string);
                        string = matcher4.find() ? matcher4.replaceFirst("<html>\n<head>\n    " + this.HTML_META + "\n</head>\n") : "<html>\n<head>\n    " + this.HTML_META + "\n</head>\n" + string;
                    }
                }
            }
            this.realWriter.write(string);
            stringBuffer.setLength(0);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
        if (this.writer.getBuffer().length() >= 65536) {
            this.flush();
        }
    }
}

