/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.hhc.HHCFilter2;
import org.omegat.filters2.html2.HTMLFilter2;
import org.omegat.filters2.master.Filters;
import org.omegat.filters2.master.OneFilter;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.filters2.po.PoFilter;
import org.omegat.filters2.subtitles.SrtFilter;
import org.omegat.filters2.text.TextFilter;
import org.omegat.filters2.text.bundles.ResourceBundleFilter;
import org.omegat.filters2.text.ini.INIFilter;
import org.omegat.filters2.xtagqxp.XtagFilter;
import org.omegat.filters3.xml.docbook.DocBookFilter;
import org.omegat.filters3.xml.opendoc.OpenDocFilter;
import org.omegat.filters3.xml.openxml.OpenXMLFilter;
import org.omegat.filters3.xml.xhtml.XHTMLFilter;
import org.omegat.filters3.xml.xliff.XLIFFFilter;
import org.omegat.util.LFileCopy;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMaster {
    private static final String FILE_FILTERS = "filters.conf";
    public static String INITIAL_VERSION = new String();
    public static String OT160RC12a_VERSION = "1.6 RC12a";
    public static String OT160FINAL_VERSION = "1.6.0";
    public static String OT161_VERSION = "1.6.1";
    public static String OT170_VERSION = "1.7.0";
    public static String CURRENT_VERSION = "2.0";
    private Filters filters;
    private static FilterMaster master = null;
    private static List<String> supportedEncodings = null;
    private File configFile = new File(StaticUtils.getConfigDir() + "filters.conf");

    public Filters getFilters() {
        return this.filters;
    }

    private FilterMaster() {
        PluginUtils.loadPlugins();
        if (this.configFile.exists()) {
            this.loadConfig();
        } else {
            this.filters = this.setupBuiltinFilters();
        }
        this.loadFilterClassesFromPlugins();
        this.saveConfig();
    }

    public static FilterMaster getInstance() {
        if (master == null) {
            master = new FilterMaster();
        }
        return master;
    }

    public boolean loadFile(String string, Set<File> set, IParseCallback iParseCallback) throws IOException, TranslationException {
        try {
            LookupInformation lookupInformation = this.lookupFilter(string);
            if (lookupInformation == null) {
                return false;
            }
            File file = new File(string);
            String string2 = lookupInformation.inEncoding;
            AbstractFilter abstractFilter = lookupInformation.filterObject;
            abstractFilter.setParseCallback(iParseCallback);
            List<File> list = abstractFilter.processFile(file, string2, null, null);
            if (list != null) {
                set.addAll(list);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IOException(string + "\n" + iOException);
        }
        return true;
    }

    public void translateFile(String string, String string2, String string3, Set<File> set, IParseCallback iParseCallback) throws IOException, TranslationException {
        LookupInformation lookupInformation = this.lookupFilter(string + File.separator + string2);
        if (lookupInformation == null) {
            LFileCopy.copy(string + File.separator + string2, string3 + File.separator + string2);
            return;
        }
        File file = new File(string + File.separator + string2);
        String string4 = lookupInformation.inEncoding;
        String string5 = file.getName();
        String string6 = string2.substring(0, string2.length() - string5.length());
        Instance instance = lookupInformation.instance;
        File file2 = new File(string3 + File.separator + string6 + File.separator + this.constructTargetFilename(instance.getSourceFilenameMask(), string5, instance.getTargetFilenamePattern()));
        String string7 = instance.getTargetEncoding();
        AbstractFilter abstractFilter = lookupInformation.filterObject;
        abstractFilter.setParseCallback(iParseCallback);
        List<File> list = abstractFilter.processFile(file, string4, file2, string7);
        if (list != null) {
            set.addAll(list);
        }
    }

    private LookupInformation lookupFilter(String string) throws TranslationException, IOException {
        File file = new File(string);
        String string2 = file.getName();
        String string3 = file.getParent();
        if (string3 == null) {
            string3 = "";
        }
        block0: for (int i = 0; i < this.getFilters().getFilter().length; ++i) {
            OneFilter oneFilter = this.getFilters().getFilter(i);
            if (!oneFilter.isOn()) continue;
            for (int j = 0; j < oneFilter.getInstance().length; ++j) {
                String string4;
                Instance instance = oneFilter.getInstance(j);
                if (!this.matchesMask(string2, instance.getSourceFilenameMask())) continue;
                AbstractFilter abstractFilter = PluginUtils.instantiateFilter(oneFilter);
                if (!abstractFilter.isFileSupported(file, string4 = instance.getSourceEncoding())) continue block0;
                return new LookupInformation(oneFilter, instance, abstractFilter, string4);
            }
        }
        return null;
    }

    public static List<String> getSupportedEncodings() {
        if (supportedEncodings == null) {
            supportedEncodings = new ArrayList<String>();
            supportedEncodings.add(AbstractFilter.ENCODING_AUTO_HUMAN);
            supportedEncodings.addAll(Charset.availableCharsets().keySet());
        }
        return supportedEncodings;
    }

    public void revertFiltersConfigToDefaults() {
        this.filters = this.setupBuiltinFilters();
        PluginUtils.loadPlugins();
        this.loadFilterClassesFromPlugins();
        this.saveConfig();
    }

    public void loadConfig() {
        try {
            MyExceptionListener myExceptionListener = new MyExceptionListener();
            XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(this.configFile), this, myExceptionListener);
            this.filters = (Filters)xMLDecoder.readObject();
            xMLDecoder.close();
            if (myExceptionListener.isExceptionOccured()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Exception exception : myExceptionListener.getExceptionsList()) {
                    stringBuffer.append("    ");
                    stringBuffer.append(exception);
                    stringBuffer.append("\n");
                }
                throw new Exception("Exceptions occured while loading file filters:\n" + stringBuffer.toString());
            }
            this.checkIfAllFilterPluginsAreAvailable();
            if (CURRENT_VERSION.compareTo(Preferences.getPreference("filters_version")) > 0) {
                Filters filters = this.setupBuiltinFilters();
                this.filters = this.upgradeFilters(this.filters, filters);
            }
        }
        catch (Exception exception) {
            Log.logErrorRB("FILTERMASTER_ERROR_LOADING_FILTERS_CONFIG", new Object[0]);
            Log.log(exception);
            this.filters = this.setupBuiltinFilters();
        }
    }

    private Filters upgradeFilters(Filters filters, Filters filters2) {
        int n;
        OneFilter oneFilter;
        String string = Preferences.getPreference("filters_version");
        if (!string.equals(OT160FINAL_VERSION) && !string.equals(OT161_VERSION) && string.compareTo(OT160RC12a_VERSION) < 0) {
            for (int i = 0; i < filters.getFilter().length; ++i) {
                OneFilter oneFilter2 = filters.getFilter(i);
                if (!oneFilter2.getClassName().equals("org.omegat.filters2.xml.openoffice.OOFilter")) continue;
                oneFilter = new OneFilter(new OpenDocFilter(), false);
                block1: for (int j = 0; j < oneFilter2.getInstance().length; ++j) {
                    Instance instance = oneFilter2.getInstance(j);
                    for (int k = 0; k < oneFilter.getInstance().length; ++k) {
                        Instance instance2 = oneFilter.getInstance(k);
                        if (!instance2.getSourceFilenameMask().equals(instance.getSourceFilenameMask())) continue;
                        oneFilter.setInstance(k, instance);
                        continue block1;
                    }
                }
                filters.setFilter(i, oneFilter);
                break;
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < filters.getFilter().length; ++n) {
            hashSet.add(filters.getFilter(n).getClassName());
        }
        for (n = 0; n < filters2.getFilter().length; ++n) {
            oneFilter = filters2.getFilter(n);
            if (hashSet.contains(oneFilter.getClassName())) continue;
            filters.addFilter(oneFilter);
        }
        return filters;
    }

    private void checkIfAllFilterPluginsAreAvailable() {
        ClassLoader classLoader = PluginUtils.getPluginsClassloader();
        List<List<Object>> list = PluginUtils.getPlugins();
        int n = 0;
        while (n < this.filters.filtersSize()) {
            OneFilter oneFilter = this.filters.getFilter(n);
            if (!oneFilter.isFromPlugin()) {
                ++n;
                continue;
            }
            for (List<Object> list2 : list) {
                for (int i = 1; i < list2.size(); ++i) {
                    String string = (String)list2.get(i);
                    if (!oneFilter.getClass().getName().equals(string)) continue;
                    try {
                        Class<?> clazz = classLoader.loadClass(string);
                        Constructor<?> constructor = clazz.getConstructor(null);
                        Object obj = constructor.newInstance(null);
                        if (!(obj instanceof AbstractFilter)) continue;
                        ++n;
                        continue;
                    }
                    catch (Exception exception) {
                        this.filters.removeFilter(n);
                    }
                }
            }
            this.filters.removeFilter(n);
        }
    }

    private Filters setupBuiltinFilters() {
        Filters filters = new Filters();
        filters.addFilter(new OneFilter(new TextFilter(), false));
        filters.addFilter(new OneFilter(new PoFilter(), false));
        filters.addFilter(new OneFilter(new ResourceBundleFilter(), false));
        filters.addFilter(new OneFilter(new XHTMLFilter(), false));
        filters.addFilter(new OneFilter(new HTMLFilter2(), false));
        filters.addFilter(new OneFilter(new HHCFilter2(), false));
        filters.addFilter(new OneFilter(new INIFilter(), false));
        filters.addFilter(new OneFilter(new DocBookFilter(), false));
        filters.addFilter(new OneFilter(new OpenDocFilter(), false));
        filters.addFilter(new OneFilter(new OpenXMLFilter(), false));
        filters.addFilter(new OneFilter(new XLIFFFilter(), false));
        filters.addFilter(new OneFilter(new SrtFilter(), false));
        filters.addFilter(new OneFilter(new XtagFilter(), false));
        return filters;
    }

    private void loadFilterClassesFromPlugins() {
        ClassLoader classLoader = PluginUtils.getPluginsClassloader();
        List<List<Object>> list = PluginUtils.getPlugins();
        for (int i = 0; i < list.size(); ++i) {
            List<Object> list2 = list.get(i);
            for (int j = 1; j < list2.size(); ++j) {
                try {
                    Class<?> clazz = classLoader.loadClass((String)list2.get(j));
                    Constructor<?> constructor = clazz.getConstructor(null);
                    Object obj = constructor.newInstance(null);
                    if (!(obj instanceof AbstractFilter)) continue;
                    OneFilter oneFilter = new OneFilter((AbstractFilter)obj, true);
                    this.filters.addFilter(oneFilter);
                    continue;
                }
                catch (Exception exception) {
                    Log.logErrorRB("FILTERMASTER_ERROR_LOADING_FILTER", list2.get(j), ((URL)list2.get(0)).getFile());
                }
            }
        }
    }

    public void saveConfig() {
        try {
            XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(this.configFile));
            xMLEncoder.writeObject(this.filters);
            xMLEncoder.close();
            Preferences.setPreference("filters_version", CURRENT_VERSION);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.logErrorRB("FILTERMASTER_ERROR_SAVING_FILTERS_CONFIG", new Object[0]);
            Log.log(fileNotFoundException);
            JOptionPane.showMessageDialog(null, OStrings.getString("FILTERMASTER_ERROR_SAVING_FILTERS_CONFIG") + "\n" + fileNotFoundException, OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private boolean matchesMask(String string, String string2) {
        string2 = string2.replaceAll("\\.", "\\\\.");
        string2 = string2.replaceAll("\\*", ".*");
        string2 = string2.replaceAll("\\?", ".");
        return string.matches("(?iu)" + string2);
    }

    private String constructTargetFilename(String string, String string2, String string3) {
        int n = string.lastIndexOf(42);
        int n2 = 0;
        if (n >= 0) {
            int n3 = string.indexOf(46, n);
            int n4 = string.length() - n3;
            n2 = string2.length() - n4;
        } else {
            n2 = string2.lastIndexOf(46);
        }
        String string4 = string2;
        String string5 = "";
        if (n2 >= 0) {
            string4 = string2.substring(0, n2);
            string5 = string2.substring(n2 + 1);
        }
        String string6 = string3;
        string6 = string6.replaceAll(this.targetRegexer("${filename}"), string2);
        string6 = string6.replaceAll(this.targetRegexer("${nameOnly}"), string4);
        string6 = string6.replaceAll(this.targetRegexer("${extension}"), string5);
        Language language = Core.getProject().getProjectProperties().getTargetLanguage();
        string6 = string6.replaceAll(this.targetRegexer("${targetLocale}"), language.getLocaleCode());
        string6 = string6.replaceAll(this.targetRegexer("${targetLanguage}"), language.getLanguage());
        string6 = string6.replaceAll(this.targetRegexer("${targetLanguageCode}"), language.getLanguageCode());
        string6 = string6.replaceAll(this.targetRegexer("${targetCoutryCode}"), language.getCountryCode());
        return string6;
    }

    private String targetRegexer(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\\$", "\\\\\\$");
        string2 = string2.replaceAll("\\{", "\\\\{");
        string2 = string2.replaceAll("\\}", "\\\\}");
        string2 = "(?i)" + string2;
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyExceptionListener
    implements ExceptionListener {
        private List<Exception> exceptionsList = new ArrayList<Exception>();
        private boolean exceptionOccured = false;

        MyExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception exception) {
            this.exceptionOccured = true;
            this.exceptionsList.add(exception);
        }

        public boolean isExceptionOccured() {
            return this.exceptionOccured;
        }

        public List<Exception> getExceptionsList() {
            return this.exceptionsList;
        }
    }

    class LookupInformation {
        public OneFilter filter;
        public Instance instance;
        public AbstractFilter filterObject;
        public String inEncoding;

        public LookupInformation(OneFilter oneFilter, Instance instance, AbstractFilter abstractFilter, String string) {
            this.filter = oneFilter;
            this.instance = instance;
            this.filterObject = abstractFilter;
            this.inEncoding = string;
        }
    }
}

