/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.xtagqxp;

import org.omegat.filters3.Element;

public class Xtag
implements Element {
    private String tag;
    private String shortcut;
    private int index;

    public Xtag(String string, int n) {
        this.tag = string;
        this.shortcut = this.makeShortcut(string);
        this.index = n;
    }

    private String makeShortcut(String string) {
        char c = ' ';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (!Character.isLetter(c)) continue;
            c = Character.toLowerCase(c);
            return String.valueOf(c);
        }
        if (c == '<') {
            return "<";
        }
        if (c == '>') {
            return ">";
        }
        return "x";
    }

    public String getTag() {
        return this.tag;
    }

    public String getShortcut() {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        return Character.toString(this.getTag().charAt(0));
    }

    public int getIndex() {
        return this.index;
    }

    public String toShortcut() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getShortcut().equals("<")) {
            return "<";
        }
        if (this.getShortcut().equals(">")) {
            return ">";
        }
        stringBuffer.append("<");
        stringBuffer.append(this.getShortcut());
        stringBuffer.append(this.getIndex());
        stringBuffer.append("/");
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String toOriginal() {
        return "<" + this.getTag() + ">";
    }

    public String toTMX() {
        return "";
    }
}

