/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class XMLReader
extends Reader {
    private BufferedReader reader;
    private String encoding;
    boolean readFirstTime = true;

    public String getEncoding() {
        return this.encoding;
    }

    public XMLReader(File file) throws IOException {
        this(file, null);
    }

    public XMLReader(File file, String string) throws IOException {
        this.reader = new BufferedReader(this.createReader(file, string));
    }

    private Reader createReader(File file, String string) throws IOException {
        String string2;
        Matcher matcher;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        bufferedInputStream.mark(8192);
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        int n3 = bufferedInputStream.read();
        this.encoding = null;
        if (n == 254 && n2 == 255) {
            this.encoding = "UTF-16BE";
        }
        if (n == 255 && n2 == 254) {
            this.encoding = "UTF-16LE";
        }
        if (n == 239 && n2 == 187 && n3 == 191) {
            this.encoding = "UTF-8";
        }
        bufferedInputStream.reset();
        if (this.encoding != null) {
            return new InputStreamReader((InputStream)bufferedInputStream, this.encoding);
        }
        bufferedInputStream.mark(8192);
        byte[] byArray = new byte[8192];
        int n4 = bufferedInputStream.read(byArray);
        if (n4 > 0 && (matcher = PatternConsts.XML_ENCODING.matcher(string2 = new String(byArray, 0, n4))).find()) {
            this.encoding = matcher.group(1);
        }
        bufferedInputStream.reset();
        if (this.encoding != null) {
            return new InputStreamReader((InputStream)bufferedInputStream, this.encoding);
        }
        try {
            return new InputStreamReader((InputStream)bufferedInputStream, "UTF-8");
        }
        catch (Exception exception) {
            return new InputStreamReader(bufferedInputStream);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.readFirstTime) {
            this.readFirstTime = false;
            this.reader.mark(1);
            int n3 = this.reader.read();
            if (n3 != 65279) {
                this.reader.reset();
            }
        }
        return this.reader.read(cArray, n, n2);
    }
}

