/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

public class DictionaryInstallerDialog
extends JDialog {
    private DictionaryManager dicMan;
    private DefaultListModel listModel;
    private JButton closeButton;
    private JList dictionaryList;
    private JTextArea infoTextArea;
    private JButton installButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel listLabel;

    public DictionaryInstallerDialog(JDialog jDialog, DictionaryManager dictionaryManager) throws IOException {
        super((Dialog)jDialog, true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DictionaryInstallerDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.dicMan = dictionaryManager;
        this.initComponents();
        this.UiInitComponents();
        List<String> list = dictionaryManager.getInstallableDictionaryNameList();
        this.listModel = new DefaultListModel();
        for (String string : list) {
            this.listModel.addElement(string);
        }
        this.dictionaryList.setModel(this.listModel);
        this.dictionaryList.setEnabled(true);
        if (!list.isEmpty()) {
            this.installButton.setEnabled(true);
            this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_GO"));
        } else {
            this.installButton.setEnabled(false);
            this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_NOTHING"));
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.dictionaryList = new JList();
        this.closeButton = new JButton();
        this.installButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.infoTextArea = new JTextArea();
        this.listLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("GUI_DICTIONARY_INSTALLER_TITLE"));
        this.jScrollPane2.setViewportView(this.dictionaryList);
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)OStrings.getString("BUTTON_CLOSE"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DictionaryInstallerDialog.this.closeButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.installButton, (String)OStrings.getString("GUI_DICTIONARY_INSTALLER_INSTALL"));
        this.installButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DictionaryInstallerDialog.this.installButtonActionPerformed(actionEvent);
            }
        });
        this.infoTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.infoTextArea.setColumns(20);
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setFont(new Font("Dialog", 1, 12));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setRows(5);
        this.infoTextArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.infoTextArea);
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)OStrings.getString("GUI_DICTIONARY_INSTALLER_AVAILABLE"));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.listLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 304, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.installButton, -1, -1, Short.MAX_VALUE).add((Component)this.closeButton, -1, 84, Short.MAX_VALUE))).add((Component)this.jScrollPane1, -1, 394, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, -1, -2).add(9, 9, 9).add((Component)this.listLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.installButton).addPreferredGap(0, 125, Short.MAX_VALUE).add((Component)this.closeButton)).add((Component)this.jScrollPane2, -1, 171, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void installButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.dictionaryList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            String string2 = string.substring(0, string.indexOf(" "));
            try {
                this.dicMan.installRemoteDictionary(string2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, malformedURLException.getLocalizedMessage(), "Error", 0);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void UiInitComponents() {
        this.infoTextArea.setText(OStrings.getString("GUI_DICTIONARY_INSTALLER_TEXT_WAIT"));
        this.installButton.setEnabled(false);
        this.dictionaryList.setEnabled(false);
    }
}

