/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.data.stat.StatisticsInfo;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.DocumentSegment;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorSpellChecking;
import org.omegat.gui.editor.EditorTextArea;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.SegmentHistory;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorController
implements IEditor {
    private static final String IMPOSSIBLE = "Should not have happened, report to http://sf.net/tracker/?group_id=68187&atid=520347";
    private final int WITH_END_MARKERS = 1;
    private final int IS_NOT_TRANSLATED = 2;
    private final DockableScrollPane pane;
    private final EditorTextArea editor;
    private String introPaneTitle;
    private String emptyProjectPaneTitle;
    private JTextPane introPane;
    private JTextPane emptyProjectPane;
    protected final MainWindow mw;
    private SourceTextEntry m_curEntry;
    protected int m_curEntryNum = 0;
    protected int m_segmentStartOffset;
    protected int m_sourceDisplayLength;
    protected int m_segmentEndInset;
    protected int m_xlFirstEntry;
    protected int m_xlLastEntry;
    protected boolean m_docReady;
    protected DocumentSegment[] m_docSegList;
    private boolean entryActivated = false;
    private boolean m_segmentTagHasNumber;
    private SegmentHistory history = new SegmentHistory();
    private final EditorSettings settings;
    private String previousFileName;

    public EditorController(MainWindow mainWindow) {
        this.mw = mainWindow;
        this.editor = new EditorTextArea();
        this.editor.setFont(Core.getMainWindow().getApplicationFont());
        this.pane = new DockableScrollPane("EDITOR", " ", this.editor, false);
        this.pane.setMinimumSize(new Dimension(100, 100));
        Core.getMainWindow().addDockable(this.pane);
        this.editor.controller = this;
        this.settings = new EditorSettings(this);
        String string = OConsts.segmentStartStringFull;
        int n = string.lastIndexOf(48);
        this.m_segmentTagHasNumber = n > 4 && string.charAt(n - 1) == '0' && string.charAt(n - 2) == '0' && string.charAt(n - 3) == '0';
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                SHOW_TYPE sHOW_TYPE;
                switch (pROJECT_CHANGE_TYPE) {
                    case CREATE: 
                    case LOAD: {
                        EditorController.this.history.clear();
                        if (!Core.getProject().getAllEntries().isEmpty()) {
                            sHOW_TYPE = SHOW_TYPE.FIRST_ENTRY;
                            break;
                        }
                        sHOW_TYPE = SHOW_TYPE.EMPTY_PROJECT;
                        break;
                    }
                    case CLOSE: {
                        EditorController.this.history.clear();
                        sHOW_TYPE = SHOW_TYPE.INTRO;
                        break;
                    }
                    default: {
                        sHOW_TYPE = SHOW_TYPE.NO_CHANGE;
                    }
                }
                EditorController.this.updateState(sHOW_TYPE);
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String string) {
                EditorController.this.updateState(SHOW_TYPE.NO_CHANGE);
            }

            public void onEntryActivated(StringEntry stringEntry) {
            }
        });
        this.createAdditionalPanes();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorController.this.updateState(SHOW_TYPE.INTRO);
                EditorController.this.pane.requestFocus();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font font) {
                EditorController.this.editor.setFont(font);
                EditorController.this.emptyProjectPane.setFont(font);
            }
        });
    }

    private void updateState(SHOW_TYPE sHOW_TYPE) {
        UIThreadsUtil.mustBeSwingThread();
        JTextPane jTextPane = null;
        String string = null;
        switch (sHOW_TYPE) {
            case INTRO: {
                jTextPane = this.introPane;
                string = this.introPaneTitle;
                break;
            }
            case EMPTY_PROJECT: {
                jTextPane = this.emptyProjectPane;
                string = this.emptyProjectPaneTitle;
                break;
            }
            case FIRST_ENTRY: {
                this.m_curEntryNum = 0;
                this.m_xlFirstEntry = -1;
                this.m_xlLastEntry = -1;
                this.previousFileName = null;
                string = StaticUtils.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                jTextPane = this.editor;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorController.this.loadDocument();
                        EditorController.this.activateEntry();
                    }
                });
                break;
            }
            case NO_CHANGE: {
                string = StaticUtils.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                jTextPane = this.editor;
            }
        }
        this.pane.setName(string);
        if (this.pane.getViewport().getView() != jTextPane) {
            this.pane.setViewportView(jTextPane);
        }
    }

    public void requestFocus() {
        this.pane.getViewport().getView().requestFocusInWindow();
    }

    public SourceTextEntry getCurrentEntry() {
        return this.m_curEntry;
    }

    public int getCurrentEntryNumber() {
        return this.m_curEntryNum;
    }

    public String getCurrentFile() {
        try {
            String string = Core.getProject().getAllEntries().get((int)this.m_curEntryNum).getSrcFile().name;
            return string.substring(Core.getProject().getProjectProperties().getSourceRoot().length());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void exportCurrentSegment() {
        String string = this.m_curEntry.getSrcText();
        String string2 = this.m_curEntry.getTranslation();
        FileUtil.writeScriptFile(string, "source.txt");
        FileUtil.writeScriptFile(string2, "target.txt");
    }

    protected void loadDocument() {
        UIThreadsUtil.mustBeSwingThread();
        this.m_docReady = false;
        this.editor.setText(new String());
        List<SourceTextEntry> list = Core.getProject().getAllEntries();
        this.m_curEntry = list.get(this.m_curEntryNum);
        this.m_xlFirstEntry = this.m_curEntry.getFirstInFile();
        this.m_xlLastEntry = this.m_curEntry.getLastInFile();
        int n = 1 + this.m_xlLastEntry - this.m_xlFirstEntry;
        this.m_docSegList = new DocumentSegment[n];
        int n2 = 0;
        AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
        AttributeSet attributeSet = this.settings.getTranslatedAttributeSet();
        AttributeSet attributeSet2 = this.settings.getUntranslatedAttributeSet();
        if (this.settings.isDisplaySegmentSources()) {
            attributeSet2 = Styles.GREEN;
        }
        for (int i = 0; i < n; ++i) {
            DocumentSegment documentSegment = new DocumentSegment();
            SourceTextEntry sourceTextEntry = list.get(i + this.m_xlFirstEntry);
            String string = sourceTextEntry.getSrcText();
            String string2 = sourceTextEntry.getTranslation();
            boolean bl = false;
            if (string2.length() == 0) {
                if (!this.settings.isDisplaySegmentSources()) {
                    string2 = sourceTextEntry.getSrcText();
                    attributeSet = this.settings.getUntranslatedAttributeSet();
                }
            } else {
                bl = true;
                attributeSet = this.settings.getTranslatedAttributeSet();
            }
            try {
                if (this.settings.isDisplaySegmentSources()) {
                    abstractDocument.insertString(n2, string + "\n", attributeSet2);
                    n2 += string.length() + 1;
                }
                abstractDocument.insertString(n2, string2, attributeSet);
                if (bl && this.settings.isAutoSpellChecking()) {
                    EditorSpellChecking.checkSpelling(n2, string2, this, this.editor);
                }
                abstractDocument.insertString(n2 += string2.length(), "\n\n", Styles.PLAIN);
                n2 += 2;
                if (this.settings.isDisplaySegmentSources()) {
                    string2 = string + "\n" + string2;
                }
                string2 = string2 + "\n\n";
            }
            catch (BadLocationException badLocationException) {
                Log.log(IMPOSSIBLE);
                Log.log(badLocationException);
            }
            documentSegment.length = string2.length();
            this.m_docSegList[i] = documentSegment;
        }
    }

    public void activateEntry() {
        int n;
        int n2;
        UIThreadsUtil.mustBeSwingThread();
        if (this.pane.getViewport().getView() != this.editor) {
            return;
        }
        IProject iProject = Core.getProject();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        int n3 = 0;
        for (int i = this.m_xlFirstEntry; i <= this.m_xlLastEntry; ++i) {
            if (!iProject.getAllEntries().get(i).isTranslated()) continue;
            ++n3;
        }
        StatisticsInfo statisticsInfo = iProject.getStatistics();
        String string = " " + Integer.toString(n3) + "/" + Integer.toString(this.m_xlLastEntry - this.m_xlFirstEntry + 1) + " (" + Integer.toString(statisticsInfo.numberofTranslatedSegments) + "/" + Integer.toString(statisticsInfo.numberOfUniqueSegments) + ", " + Integer.toString(statisticsInfo.numberOfSegmentsTotal) + ") ";
        Core.getMainWindow().showProgressMessage(string);
        String string2 = " " + Integer.toString(this.m_curEntry.getSrcText().length()) + "/" + Integer.toString(this.m_curEntry.getTranslation().length()) + " ";
        Core.getMainWindow().showLengthMessage(string2);
        this.history.insertNew(this.m_curEntryNum);
        this.mw.menu.gotoHistoryBackMenuItem.setEnabled(this.history.hasPrev());
        this.mw.menu.gotoHistoryForwardMenuItem.setEnabled(this.history.hasNext());
        if (this.m_curEntryNum < this.m_xlFirstEntry) {
            Log.log("ERROR: Current entry # lower than first entry #");
            Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
        }
        if (this.m_curEntryNum > this.m_xlLastEntry) {
            Log.log("ERROR: Current entry # greater than last entry #");
            Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
        }
        this.m_curEntry = iProject.getAllEntries().get(this.m_curEntryNum);
        String string3 = this.m_curEntry.getSrcText();
        this.m_sourceDisplayLength = string3.length();
        this.m_segmentStartOffset = 0;
        int n4 = this.m_curEntryNum - this.m_xlFirstEntry;
        DocumentSegment documentSegment = null;
        try {
            for (int i = 0; i < n4; ++i) {
                documentSegment = this.m_docSegList[i];
                this.m_segmentStartOffset += documentSegment.length;
            }
            documentSegment = this.m_docSegList[n4];
        }
        catch (Exception exception) {
            Log.log("ERROR: exception while calculating character offset:");
            Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
            Log.log(exception);
            return;
        }
        this.m_segmentEndInset = this.editor.getTextLength() - (this.m_segmentStartOffset + documentSegment.length - 2);
        String string4 = this.m_curEntry.getTranslation();
        if (string4 == null || string4.length() == 0) {
            string4 = this.m_curEntry.getSrcText();
            if (Preferences.isPreference("wf_noSourceText")) {
                string4 = new String();
            }
        }
        int n5 = this.replaceEntry(this.m_segmentStartOffset, documentSegment.length, string3, string4, 1);
        int n6 = 0;
        int n7 = this.m_curEntryNum - this.m_xlFirstEntry;
        try {
            for (n2 = Math.max(0, n7 - 3); n2 < n7; ++n2) {
                documentSegment = this.m_docSegList[n2];
                n6 += documentSegment.length;
            }
        }
        catch (Exception exception) {
            Log.log("ERROR: exception while calculating previous offset:");
            Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
            Log.log(exception);
            return;
        }
        n2 = this.m_segmentStartOffset - n6;
        int n8 = 0;
        int n9 = this.m_xlLastEntry - this.m_xlFirstEntry;
        try {
            for (n = n7 + 1; n < n7 + 4 && n <= n9; ++n) {
                documentSegment = this.m_docSegList[n];
                n8 += documentSegment.length;
            }
        }
        catch (Exception exception) {
            Log.log("ERROR: exception while calculating next offset:");
            Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
            Log.log(exception);
            return;
        }
        n = this.m_segmentStartOffset + n5 + n8;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    EditorController.this.editor.setCaretPosition(n);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                EditorController.this.editor.setCaretPosition(n2);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        EditorController.this.checkCaret();
                                    }
                                });
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        if (!this.m_docReady) {
            this.m_docReady = true;
        }
        this.editor.cancelUndo();
        this.checkSpelling(true);
        if (Preferences.isPreference("wf_exportCurrentSegment")) {
            this.exportCurrentSegment();
        }
        this.entryActivated = true;
        if (this.previousFileName == null || !this.previousFileName.equals(this.getCurrentFile())) {
            this.previousFileName = this.getCurrentFile();
            CoreEvents.fireEntryNewFile(this.previousFileName);
        }
        CoreEvents.fireEntryActivated(this.m_curEntry.getStrEntry());
    }

    public void commitAndDeactivate() {
        String string;
        String string2;
        UIThreadsUtil.mustBeSwingThread();
        IProject iProject = Core.getProject();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (!this.entryActivated) {
            return;
        }
        this.entryActivated = false;
        AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
        AttributeSet attributeSet = this.settings.getTranslatedAttributeSet();
        int n = this.getTranslationStart();
        int n2 = this.getTranslationEnd();
        boolean bl = true;
        List<Token> list = null;
        int n3 = 2;
        if (n == n2) {
            string2 = new String();
            bl = false;
            if (!this.settings.isDisplaySegmentSources()) {
                string = this.m_curEntry.getSrcText();
                attributeSet = this.settings.getUntranslatedAttributeSet();
            } else {
                string = new String();
            }
        } else {
            try {
                string2 = abstractDocument.getText(n, n2 - n);
                if (string2.equals(this.m_curEntry.getSrcText()) && !Preferences.isPreference("wf_allowTransEqualToSrc")) {
                    attributeSet = this.settings.getUntranslatedAttributeSet();
                    bl = false;
                } else {
                    attributeSet = this.settings.getTranslatedAttributeSet();
                    n3 = 0;
                }
            }
            catch (BadLocationException badLocationException) {
                Log.log(IMPOSSIBLE);
                Log.log(badLocationException);
                string2 = new String();
                bl = false;
            }
            string = string2;
        }
        int n4 = this.m_segmentStartOffset;
        int n5 = this.m_sourceDisplayLength + OConsts.segmentStartStringFull.length() + string2.length() + OConsts.segmentEndStringFull.length() + 2;
        int n6 = this.m_curEntryNum - this.m_xlFirstEntry;
        DocumentSegment documentSegment = this.m_docSegList[n6];
        documentSegment.length = string.length() + "\n\n".length();
        String string3 = null;
        if (this.settings.isDisplaySegmentSources()) {
            int n7 = this.m_sourceDisplayLength + 1;
            n4 += n7;
            documentSegment.length += n7;
            string3 = this.m_curEntry.getSrcText();
        }
        documentSegment.length = this.replaceEntry(this.m_segmentStartOffset, n5, string3, string, n3);
        if (bl && this.settings.isAutoSpellChecking()) {
            list = EditorSpellChecking.checkSpelling(n4, string, this, this.editor);
        }
        String string4 = this.m_curEntry.getTranslation();
        if (string2.equals(this.m_curEntry.getSrcText()) && !Preferences.isPreference("wf_allowTransEqualToSrc")) {
            iProject.setTranslation(this.m_curEntry, new String());
        } else {
            iProject.setTranslation(this.m_curEntry, string2);
        }
        if (!this.m_curEntry.getTranslation().equals(string4)) {
            int n8 = 1 + this.m_xlLastEntry - this.m_xlFirstEntry;
            int[] nArray = new int[n8];
            int n9 = 0;
            for (int i = 0; i < n8; ++i) {
                nArray[i] = n9;
                documentSegment = this.m_docSegList[i];
                n9 += documentSegment.length;
            }
            for (SourceTextEntry sourceTextEntry : this.m_curEntry.getStrEntry().getParentList()) {
                int n10 = sourceTextEntry.entryNum();
                if (n10 > this.m_xlLastEntry) continue;
                if (n10 < this.m_xlFirstEntry) break;
                if (n10 == this.m_curEntryNum) continue;
                int n11 = n10 - this.m_xlFirstEntry;
                int n12 = nArray[n11];
                documentSegment = this.m_docSegList[n11];
                documentSegment.length = this.replaceEntry(n12, documentSegment.length, string3, string, n3);
                int n13 = 0;
                if (this.settings.isDisplaySegmentSources()) {
                    n13 = sourceTextEntry.getSrcText().length() + "\n".length();
                }
                if (!bl || list == null) continue;
                for (Token token : list) {
                    int n14 = token.getOffset();
                    String string5 = token.getTextFromString(string);
                    try {
                        abstractDocument.replace(n12 + n13 + n14, token.getLength(), string5, Styles.applyStyles(attributeSet, Styles.MISSPELLED));
                    }
                    catch (BadLocationException badLocationException) {
                        Log.log(badLocationException);
                    }
                }
            }
        }
        this.editor.cancelUndo();
    }

    public void commitAndLeave() {
        this.commitAndDeactivate();
        this.activateEntry();
    }

    public void nextEntry() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.commitAndDeactivate();
        ++this.m_curEntryNum;
        if (this.m_curEntryNum > this.m_xlLastEntry) {
            if (this.m_curEntryNum >= Core.getProject().getAllEntries().size()) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        }
        this.activateEntry();
    }

    public void prevEntry() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.commitAndDeactivate();
        --this.m_curEntryNum;
        if (this.m_curEntryNum < this.m_xlFirstEntry) {
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = Core.getProject().getAllEntries().size() - 1;
            }
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        }
        this.activateEntry();
    }

    public void nextUntranslatedEntry() {
        SourceTextEntry sourceTextEntry;
        int n;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.commitAndDeactivate();
        IProject iProject = Core.getProject();
        int n2 = iProject.getAllEntries().size();
        boolean bl = false;
        for (n = this.m_curEntryNum + 1; n < n2; ++n) {
            sourceTextEntry = iProject.getAllEntries().get(n);
            if (sourceTextEntry == null || sourceTextEntry.getTranslation().length() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n = 0; n < this.m_curEntryNum; ++n) {
                sourceTextEntry = iProject.getAllEntries().get(n);
                if (sourceTextEntry == null || sourceTextEntry.getTranslation().length() != 0) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.m_curEntryNum = n;
            if (this.m_curEntryNum < this.m_xlFirstEntry || this.m_curEntryNum > this.m_xlLastEntry) {
                this.loadDocument();
            }
        }
        this.activateEntry();
    }

    public void gotoEntry(int n) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.commitAndDeactivate();
        IProject iProject = Core.getProject();
        this.m_curEntryNum = n - 1;
        if (this.m_curEntryNum < this.m_xlFirstEntry) {
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = iProject.getAllEntries().size() - 1;
            }
            if (this.m_curEntryNum < 0) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        } else if (this.m_curEntryNum > this.m_xlLastEntry) {
            if (this.m_curEntryNum >= iProject.getAllEntries().size()) {
                this.m_curEntryNum = 0;
            }
            this.loadDocument();
        }
        this.activateEntry();
    }

    public void changeCase(IEditor.CHANGE_CASE_TO cHANGE_CASE_TO) {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.editor.getSelectionStart();
        int n2 = this.editor.getSelectionEnd();
        int n3 = this.editor.getCaretPosition();
        int n4 = this.getTranslationStart();
        int n5 = this.getTranslationEnd();
        if (n2 < n4 || n > n5) {
            return;
        }
        if (n < n4 && n2 <= n5) {
            n = n4;
        }
        if (n2 > n5 && n >= n4) {
            n2 = n5;
        }
        try {
            int n6;
            if (n == n2) {
                n = Utilities.getWordStart(this.editor, n);
                n2 = Utilities.getWordEnd(this.editor, n2);
            }
            this.editor.setSelectionStart(n);
            this.editor.setSelectionEnd(n2);
            String string = this.editor.getText(n, n2 - n);
            Token[] tokenArray = Core.getTokenizer().tokenizeWordsForSpelling(string);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (cHANGE_CASE_TO == IEditor.CHANGE_CASE_TO.CYCLE) {
                n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (Token token : tokenArray) {
                    String string2 = token.getTextFromString(string);
                    if (StringUtil.isLowerCase(string2)) {
                        ++n6;
                        continue;
                    }
                    if (StringUtil.isTitleCase(string2)) {
                        ++n8;
                        continue;
                    }
                    if (StringUtil.isUpperCase(string2)) {
                        ++n7;
                        continue;
                    }
                    ++n9;
                }
                if (n6 == 0 && n8 == 0 && n7 == 0 && n9 == 0) {
                    return;
                }
                if (n6 != 0 && n8 == 0 && n7 == 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.TITLE;
                }
                if (n6 == 0 && n8 != 0 && n7 == 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.UPPER;
                }
                if (n6 == 0 && n8 == 0 && n7 != 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.LOWER;
                }
                if (n9 != 0) {
                    cHANGE_CASE_TO = IEditor.CHANGE_CASE_TO.UPPER;
                }
            }
            n6 = 0;
            for (Token token : tokenArray) {
                String string3 = this.doChangeCase(token.getTextFromString(string), cHANGE_CASE_TO);
                stringBuffer.replace(token.getOffset() + n6, token.getLength() + token.getOffset() + n6, string3);
                n6 += string3.length() - token.getLength();
            }
            this.editor.replaceSelection(stringBuffer.toString());
            this.editor.setCaretPosition(n3);
            this.editor.setSelectionStart(n);
            this.editor.setSelectionEnd(n2);
        }
        catch (BadLocationException badLocationException) {
            Log.log("bad location exception when changing case");
            Log.log(badLocationException);
        }
    }

    private String doChangeCase(String string, IEditor.CHANGE_CASE_TO cHANGE_CASE_TO) {
        Locale locale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        switch (cHANGE_CASE_TO) {
            case LOWER: {
                return string.toLowerCase(locale);
            }
            case UPPER: {
                return string.toUpperCase(locale);
            }
            case TITLE: {
                return Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase(locale);
            }
        }
        return string.toUpperCase(locale);
    }

    protected void checkCaret() {
        int n = this.editor.getSelectionStart();
        int n2 = this.editor.getSelectionEnd();
        int n3 = this.getTranslationStart();
        int n4 = this.getTranslationEnd();
        if (n != n2) {
            if (n < n3) {
                this.editor.setSelectionStart(n3);
            } else if (n > n4) {
                this.editor.setSelectionStart(n4);
            }
            if (n2 > n4) {
                this.editor.setSelectionEnd(n4);
            } else if (n2 < n3) {
                this.editor.setSelectionStart(n3);
            }
        } else if (n < n3) {
            this.editor.setCaretPosition(n3);
        } else if (n > n4) {
            this.editor.setCaretPosition(n4);
        }
    }

    protected boolean checkCaretForDelete(boolean bl) {
        int n = this.editor.getCaretPosition();
        this.checkCaret();
        if (bl) {
            int n2 = this.editor.getTextLength() - this.m_segmentEndInset - OConsts.segmentEndStringFull.length();
            int n3 = this.editor.getSelectionStart();
            int n4 = this.editor.getSelectionEnd();
            if (n >= n2 && n3 >= n2 && n4 >= n2) {
                return false;
            }
        } else {
            int n5 = this.getTranslationStart();
            int n6 = this.editor.getSelectionStart();
            int n7 = this.editor.getSelectionEnd();
            if (n <= n5 && n7 <= n5 && n6 <= n5) {
                return false;
            }
        }
        return true;
    }

    private int replaceEntry(int n, int n2, String string, String string2, int n3) {
        AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
        int n4 = 0;
        AttributeSet attributeSet = (n3 & 2) == 2 ? this.settings.getUntranslatedAttributeSet() : this.settings.getTranslatedAttributeSet();
        try {
            String string3;
            abstractDocument.remove(n, n2);
            abstractDocument.insertString(n, "\n\n", Styles.PLAIN);
            n4 = 2;
            if ((n3 & 1) == 1) {
                string3 = OConsts.segmentEndStringFull;
                abstractDocument.insertString(n, string3, Styles.PLAIN);
                abstractDocument.replace(n + string3.indexOf(OConsts.segmentEndString), OConsts.segmentEndString.length(), OConsts.segmentEndString, Styles.BOLD);
                n4 += string3.length();
            }
            if (string2 != null && !string2.equals("")) {
                abstractDocument.insertString(n, string2, attributeSet);
                n4 += string2.length();
            }
            if ((n3 & 1) == 1) {
                abstractDocument.insertString(n, " ", Styles.PLAIN);
                string3 = new String(OConsts.segmentStartString);
                try {
                    if (this.m_segmentTagHasNumber) {
                        String string4 = String.valueOf(this.m_curEntryNum + 1);
                        int n5 = string3.lastIndexOf(48);
                        string3 = string3.substring(0, n5 - string4.length() + 1) + string4 + string3.substring(n5 + 1, string3.length());
                    }
                }
                catch (Exception exception) {
                    Log.log("ERROR: exception while putting segment # in start tag:");
                    Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                    Log.log(exception);
                }
                abstractDocument.insertString(n, string3, Styles.BOLD);
                n4 += string3.length();
            }
            if (string != null) {
                if ((n3 & 1) != 1) {
                    string = string + "\n";
                }
                abstractDocument.insertString(n, string, Styles.GREEN);
                n4 += string.length();
            }
        }
        catch (BadLocationException badLocationException) {
            Log.log(IMPOSSIBLE);
            Log.log(badLocationException);
        }
        return n4;
    }

    public void replaceEditText(String string) {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.getTranslationStart();
        int n2 = this.getTranslationEnd();
        this.editor.select(n, n2);
        this.editor.replaceSelection(string);
    }

    public void insertText(String string) {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.replaceSelection(string);
    }

    protected int getTranslationStart() {
        return this.m_segmentStartOffset + this.m_sourceDisplayLength + OConsts.segmentStartStringFull.length();
    }

    protected int getTranslationEnd() {
        return this.editor.getTextLength() - this.m_segmentEndInset - OConsts.segmentEndStringFull.length();
    }

    public void gotoHistoryBack() {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.history.back();
        if (n != -1) {
            this.gotoEntry(n + 1);
        }
    }

    public void gotoHistoryForward() {
        UIThreadsUtil.mustBeSwingThread();
        int n = this.history.forward();
        if (n != -1) {
            this.gotoEntry(n + 1);
        }
    }

    protected void checkSpelling(boolean bl) {
        UIThreadsUtil.mustBeSwingThread();
        if (!this.settings.isAutoSpellChecking()) {
            return;
        }
        EditorSpellChecking.checkSpelling(bl, this, this.editor);
    }

    public EditorSettings getSettings() {
        return this.settings;
    }

    public void undo() {
        UIThreadsUtil.mustBeSwingThread();
        try {
            if (this.editor.undoManager.canUndo()) {
                this.editor.undoManager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        UIThreadsUtil.mustBeSwingThread();
        try {
            if (this.editor.undoManager.canRedo()) {
                this.editor.undoManager.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public String getSelectedText() {
        UIThreadsUtil.mustBeSwingThread();
        return this.editor.getSelectedText();
    }

    private void createAdditionalPanes() {
        this.introPaneTitle = OStrings.getString("DOCKING_INSTANT_START_TITLE");
        try {
            String string = this.detectInstantStartLanguage();
            String string2 = StaticUtils.installDir() + File.separator + "docs" + File.separator + string + File.separator + "instantStartGuideNoTOC.html";
            this.introPane = new JTextPane();
            this.introPane.setComponentOrientation(ComponentOrientation.getOrientation(new Locale(string)));
            this.introPane.setEditable(false);
            this.introPane.setPage("file:///" + string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.emptyProjectPaneTitle = OStrings.getString("TF_INTRO_EMPTYPROJECT_FILENAME");
        this.emptyProjectPane = new JTextPane();
        this.emptyProjectPane.setEditable(false);
        this.emptyProjectPane.setText(OStrings.getString("TF_INTRO_EMPTYPROJECT"));
        this.emptyProjectPane.setFont(Core.getMainWindow().getApplicationFont());
    }

    private String detectInstantStartLanguage() {
        String string = Locale.getDefault().getLanguage().toLowerCase();
        String string2 = Locale.getDefault().getCountry().toUpperCase();
        File file = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + string + "_" + string2 + File.separator + "instantStartGuideNoTOC.html");
        if (file.exists()) {
            return string + "_" + string2;
        }
        file = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + string + File.separator + "instantStartGuideNoTOC.html");
        if (file.exists()) {
            return string;
        }
        return "en";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SHOW_TYPE {
        INTRO,
        EMPTY_PROJECT,
        FIRST_ENTRY,
        NO_CHANGE;

    }
}

