/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;
import org.omegat.core.Core;
import org.omegat.gui.editor.DocumentSegment;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorSpellChecking;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.ExtendedEditorKit;

public class EditorTextArea
extends JTextPane
implements MouseListener,
DocumentListener {
    private MainWindow mw;
    protected EditorController controller;
    protected UndoManager undoManager;
    private static final int CTRL_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int CTRL_DEL_MASK = StaticUtils.onMacOSX() ? 8 : CTRL_KEY_MASK;
    int textLength = 0;
    protected JPopupMenu popup;

    public EditorTextArea() {
        this.setEditorKit(new ExtendedEditorKit());
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(new StyleContext());
        defaultStyledDocument.addDocumentListener(this);
        this.undoManager = new UndoManager();
        defaultStyledDocument.addUndoableEditListener(this.undoManager);
        this.setDocument(defaultStyledDocument);
        this.addMouseListener(this);
    }

    public void cancelUndo() {
        this.undoManager.die();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.controller.m_docReady) {
            return;
        }
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
            if (this.createSpellCheckerPopUp(mouseEvent.getPoint())) {
                return;
            }
            if (this.createGoToSegmentPopUp(mouseEvent.getPoint())) {
                return;
            }
        }
        if (mouseEvent.getClickCount() == 2) {
            this.goToSegmentAtCaretLocation();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.processKeyEventBody(keyEvent);
        String string = " " + Integer.toString(this.controller.m_sourceDisplayLength) + "/" + Integer.toString(this.getTextLength() - this.controller.m_segmentEndInset - OStrings.getSegmentEndMarker().length() - (this.controller.m_segmentStartOffset + this.controller.m_sourceDisplayLength + OStrings.getSegmentStartMarker().length())) + " ";
        Core.getMainWindow().showLengthMessage(string);
    }

    protected void processKeyEventBody(KeyEvent keyEvent) {
        int n;
        if (!Core.getProject().isProjectLoaded()) {
            if ((keyEvent.getModifiers() & CTRL_KEY_MASK) == CTRL_KEY_MASK || (keyEvent.getModifiers() & 8) == 8) {
                super.processKeyEvent(keyEvent);
            }
            return;
        }
        int n2 = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (keyEvent.getID() == 402) {
            super.processKeyEvent(keyEvent);
            return;
        }
        if (keyEvent.getID() == 401 && (n2 == 17 || n2 == 18 || n2 == 157 || n2 == 16)) {
            super.processKeyEvent(keyEvent);
            return;
        }
        if (keyEvent.getID() == 401 && (keyEvent.getModifiers() == CTRL_KEY_MASK || keyEvent.getModifiers() == CTRL_KEY_MASK + 1) && n2 == 67 || keyEvent.getModifiers() == CTRL_KEY_MASK && n2 == 70 || keyEvent.getID() == 400 && keyEvent.getModifiers() == CTRL_KEY_MASK && c == '\u0003') {
            super.processKeyEvent(keyEvent);
            return;
        }
        switch (c) {
            case '\b': {
                if (this.controller.checkCaretForDelete(false)) {
                    if (keyEvent.getModifiers() == CTRL_DEL_MASK && keyEvent.getKeyCode() == 8) {
                        try {
                            int n3 = this.getCaretPosition();
                            int n4 = Utilities.getPreviousWord(this, n3);
                            int n5 = Utilities.getWordEnd(this, n4);
                            int n6 = Utilities.getPreviousWord(this, n4);
                            int n7 = Utilities.getWordEnd(this, n6);
                            this.setSelectionEnd(n3);
                            if (n5 != n3 && n5 < n3) {
                                this.setSelectionStart(n4);
                            } else {
                                this.setSelectionStart(n7);
                            }
                            this.controller.checkCaret();
                            this.replaceSelection("");
                            return;
                        }
                        catch (BadLocationException badLocationException) {}
                    } else {
                        super.processKeyEvent(keyEvent);
                    }
                }
                this.controller.checkSpelling(false);
                return;
            }
            case '\u007f': {
                if (this.controller.checkCaretForDelete(true)) {
                    if (keyEvent.getModifiers() == CTRL_DEL_MASK && keyEvent.getKeyCode() == 127) {
                        try {
                            int n8 = this.getCaretPosition();
                            int n9 = Utilities.getNextWord(this, n8);
                            int n10 = Utilities.getWordEnd(this, n8);
                            this.setSelectionStart(n8);
                            if (n9 == n10) {
                                this.setSelectionEnd(n10);
                            } else {
                                this.setSelectionEnd(n9);
                            }
                            this.controller.checkCaret();
                            this.replaceSelection("");
                            return;
                        }
                        catch (BadLocationException badLocationException) {}
                    } else {
                        super.processKeyEvent(keyEvent);
                    }
                }
                this.controller.checkSpelling(false);
                return;
            }
        }
        if (n2 == 36 || n2 == 35) {
            super.processKeyEvent(keyEvent);
            this.controller.checkCaret();
            return;
        }
        if (keyEvent.getModifiers() == CTRL_KEY_MASK && keyEvent.getKeyCode() == 65) {
            int n11 = this.controller.m_segmentStartOffset + this.controller.m_sourceDisplayLength + OConsts.segmentStartStringFull.length();
            int n12 = this.getTextLength() - this.controller.m_segmentEndInset - OConsts.segmentEndStringFull.length();
            this.setSelectionStart(n11);
            this.setSelectionEnd(n12);
            return;
        }
        this.controller.checkCaret();
        if (n2 == 10) {
            if (keyEvent.isShiftDown()) {
                KeyEvent keyEvent2 = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), 0, 10, '\n');
                super.processKeyEvent(keyEvent2);
            } else if (this.controller.getSettings().getAdvancerChar() != n2) {
                return;
            }
        }
        if (n2 == this.controller.getSettings().getAdvancerChar()) {
            if (this.controller.getSettings().getAdvancerChar() == '\n') {
                if ((keyEvent.getModifiers() & CTRL_KEY_MASK) == CTRL_KEY_MASK) {
                    if (keyEvent.getID() == 401) {
                        Core.getEditor().prevEntry();
                    }
                } else if (!keyEvent.isShiftDown() && keyEvent.getID() == 401) {
                    Core.getEditor().nextEntry();
                }
            } else if (this.controller.getSettings().getAdvancerChar() == '\t') {
                if (keyEvent.isShiftDown()) {
                    if (keyEvent.getID() == 401) {
                        Core.getEditor().prevEntry();
                    }
                } else if (keyEvent.getID() == 401) {
                    Core.getEditor().nextEntry();
                }
            }
            return;
        }
        if (keyEvent.isShiftDown()) {
            if (n2 == 38 || n2 == 37 || n2 == 224 || n2 == 226) {
                int n13;
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 401 && (n13 = this.getCaretPosition()) < (n = this.controller.m_segmentStartOffset + this.controller.m_sourceDisplayLength + OConsts.segmentStartStringFull.length())) {
                    this.moveCaretPosition(n);
                }
            } else if (n2 == 40 || n2 == 39 || n2 == 225 || n2 == 227) {
                int n14;
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 401 && (n14 = this.getCaretPosition()) > (n = this.getTextLength() - this.controller.m_segmentEndInset - OConsts.segmentEndStringFull.length())) {
                    this.moveCaretPosition(n);
                }
            }
        }
        if (!keyEvent.isShiftDown()) {
            if (n2 == 38 || n2 == 37 || n2 == 224 || n2 == 226) {
                int n15 = this.getSelectionEnd();
                if (n15 != (n = this.getSelectionStart())) {
                    this.setCaretPosition(n);
                } else {
                    super.processKeyEvent(keyEvent);
                }
                this.controller.checkCaret();
                return;
            }
            if (n2 == 40 || n2 == 39 || n2 == 225 || n2 == 227) {
                int n16 = this.getSelectionEnd();
                if (n16 != (n = this.getSelectionStart())) {
                    this.setCaretPosition(n16);
                } else {
                    super.processKeyEvent(keyEvent);
                }
                this.controller.checkCaret();
                return;
            }
        }
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isActionKey() && n2 == 0 && keyEvent.getModifiers() != CTRL_KEY_MASK) {
            this.controller.checkSpelling(false);
        }
    }

    protected int getTextLength() {
        return this.textLength;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textLength -= documentEvent.getLength();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textLength += documentEvent.getLength();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void replaceSelection(String string) {
        this.controller.checkCaret();
        super.replaceSelection(string);
        this.controller.checkSpelling(true);
    }

    private boolean createSpellCheckerPopUp(Point point) {
        if (!this.controller.getSettings().isAutoSpellChecking()) {
            return false;
        }
        return EditorSpellChecking.createSpellCheckerPopUp(point, this.controller, this);
    }

    private boolean createGoToSegmentPopUp(Point point) {
        final int n = this.viewToModel(point);
        if (n >= this.controller.getTranslationStart() - OConsts.segmentStartStringFull.length() && n <= this.controller.getTranslationEnd() + OConsts.segmentStartStringFull.length()) {
            return false;
        }
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = this.popup.add(OStrings.getString("MW_PROMPT_SEG_NR_TITLE"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorTextArea.this.setCaretPosition(n);
                EditorTextArea.this.goToSegmentAtCaretLocation();
            }
        });
        this.popup.show(this, (int)point.getX(), (int)point.getY());
        return true;
    }

    private void goToSegmentAtCaretLocation() {
        block3: {
            int n;
            block2: {
                n = this.getCaretPosition();
                if (n >= this.controller.m_segmentStartOffset) break block2;
                int n2 = 0;
                for (int i = this.controller.m_xlFirstEntry; i < this.controller.m_curEntryNum; ++i) {
                    DocumentSegment documentSegment = this.controller.m_docSegList[i - this.controller.m_xlFirstEntry];
                    if (n >= (n2 += documentSegment.length)) continue;
                    Core.getEditor().gotoEntry(i + 1);
                    return;
                }
                break block3;
            }
            if (n <= this.getTextLength() - this.controller.m_segmentEndInset) break block3;
            int n3 = this.getTextLength() - this.controller.m_segmentEndInset;
            for (int i = this.controller.m_curEntryNum + 1; i <= this.controller.m_xlLastEntry; ++i) {
                DocumentSegment documentSegment = this.controller.m_docSegList[i - this.controller.m_xlFirstEntry];
                if (n > (n3 += documentSegment.length)) continue;
                Core.getEditor().gotoEntry(i + 1);
                return;
            }
        }
    }
}

