/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.omegat.gui.filelist.ProjectFrame;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.DockingUI;
import org.openide.awt.Mnemonics;

public class MainWindowUI {
    public static void createMainComponents(MainWindow mainWindow, Font font) {
        mainWindow.m_projWin = new ProjectFrame(mainWindow);
    }

    public static DockingDesktop initDocking(MainWindow mainWindow) {
        DockingUI.initialize();
        mainWindow.desktop = new DockingDesktop();
        mainWindow.desktop.addDockableStateWillChangeListener(new DockableStateWillChangeListener(){

            public void dockableStateWillChange(DockableStateWillChangeEvent dockableStateWillChangeEvent) {
                if (dockableStateWillChangeEvent.getFutureState().isClosed()) {
                    dockableStateWillChangeEvent.cancel();
                }
            }
        });
        return mainWindow.desktop;
    }

    public static JPanel createStatusBar(MainWindow mainWindow) {
        mainWindow.statusLabel = new JLabel();
        mainWindow.progressLabel = new JLabel();
        mainWindow.lengthLabel = new JLabel();
        mainWindow.statusLabel.setFont(new Font("MS Sans Serif", 0, 11));
        Mnemonics.setLocalizedText((JLabel)mainWindow.progressLabel, (String)OStrings.getString("MW_PROGRESS_DEFAULT"));
        mainWindow.progressLabel.setToolTipText(OStrings.getString("MW_PROGRESS_TOOLTIP"));
        mainWindow.progressLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        mainWindow.progressLabel.setHorizontalTextPosition(0);
        Mnemonics.setLocalizedText((JLabel)mainWindow.lengthLabel, (String)OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
        mainWindow.lengthLabel.setToolTipText(OStrings.getString("MW_SEGMENT_LENGTH_TOOLTIP"));
        mainWindow.lengthLabel.setAlignmentX(1.0f);
        mainWindow.lengthLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        mainWindow.lengthLabel.setFocusable(false);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(mainWindow.progressLabel);
        jPanel.add(mainWindow.lengthLabel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)mainWindow.statusLabel, "Center");
        jPanel2.add((Component)jPanel, "East");
        return jPanel2;
    }

    public static void loadScreenLayout(MainWindow mainWindow) {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = Integer.parseInt(Preferences.getPreference("screen_x"));
            n3 = Integer.parseInt(Preferences.getPreference("screen_y"));
            n2 = Integer.parseInt(Preferences.getPreference("screen_width"));
            n = Integer.parseInt(Preferences.getPreference("screen_height"));
        }
        catch (NumberFormatException numberFormatException) {
            object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
            object = ((GraphicsEnvironment)object2).getMaximumWindowBounds();
            if (((Rectangle)object).width < 900) {
                n4 = 0;
                n3 = 0;
                n2 = 580;
                n = 536;
            }
            n4 = 0;
            n3 = 0;
            n2 = 690;
            n = 700;
        }
        mainWindow.setBounds(n4, n3, n2, n);
        String string = Preferences.getPreference("docking_layout");
        if (string.length() > 0) {
            object2 = StaticUtils.uudecode(string);
            try {
                object = new ByteArrayInputStream((byte[])object2);
                mainWindow.desktop.readXML((InputStream)object);
                ((ByteArrayInputStream)object).close();
            }
            catch (Exception exception) {
                Log.log(exception);
            }
        }
    }

    public static void saveScreenLayout(MainWindow mainWindow) {
        Preferences.setPreference("screen_x", mainWindow.getX());
        Preferences.setPreference("screen_y", mainWindow.getY());
        Preferences.setPreference("screen_width", mainWindow.getWidth());
        Preferences.setPreference("screen_height", mainWindow.getHeight());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mainWindow.desktop.writeXML((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            String string = StaticUtils.uuencode(byArray);
            Preferences.setPreference("docking_layout", string);
        }
        catch (Exception exception) {
            Preferences.setPreference("docking_layout", new String());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDesktopLayout(MainWindow mainWindow) {
        try {
            InputStream inputStream = MainWindowUI.class.getResourceAsStream("DockingDefaults.xml");
            try {
                mainWindow.desktop.readXML(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }
}

