/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class XMLReader
extends Reader {
    private BufferedReader reader;
    boolean readFirstTime = true;

    public XMLReader(String string) throws IOException {
        this(string, null);
    }

    public XMLReader(String string, String string2) throws IOException {
        this.reader = new BufferedReader(this.createReader(string, string2));
    }

    private Reader createReader(String string, String string2) throws IOException {
        String string3;
        Matcher matcher;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        bufferedInputStream.mark(8192);
        int n = bufferedInputStream.read();
        int n2 = bufferedInputStream.read();
        int n3 = bufferedInputStream.read();
        String string4 = null;
        if (n == 254 && n2 == 255) {
            string4 = "UTF-16BE";
        }
        if (n == 255 && n2 == 254) {
            string4 = "UTF-16LE";
        }
        if (n == 239 && n2 == 187 && n3 == 191) {
            string4 = "UTF-8";
        }
        bufferedInputStream.reset();
        if (string4 != null) {
            return new InputStreamReader((InputStream)bufferedInputStream, string4);
        }
        bufferedInputStream.mark(8192);
        byte[] byArray = new byte[8192];
        int n4 = bufferedInputStream.read(byArray);
        if (n4 > 0 && (matcher = PatternConsts.XML_ENCODING.matcher(string3 = new String(byArray, 0, n4))).find()) {
            string4 = matcher.group(1);
        }
        bufferedInputStream.reset();
        if (string4 != null) {
            return new InputStreamReader((InputStream)bufferedInputStream, string4);
        }
        try {
            return new InputStreamReader((InputStream)bufferedInputStream, string2);
        }
        catch (Exception exception) {
            return new InputStreamReader(bufferedInputStream);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.readFirstTime) {
            this.readFirstTime = false;
            this.reader.mark(1);
            int n3 = this.reader.read();
            if (n3 != 65279) {
                this.reader.reset();
            }
        }
        return this.reader.read(cArray, n, n2);
    }
}

