/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.omegat.filters2.TranslationException;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.xml.DefaultEntityFilter;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamReader {
    private DefaultEntityFilter entityFilter;
    private boolean cdata_flag = false;
    private boolean end_cdata_flag = false;
    private static final int type_text = 1;
    private static final int type_ws = 2;
    private static final int type_apos = 3;
    private static final int type_quote = 4;
    private static final int type_lt = 5;
    private static final int type_gt = 6;
    private static final int type_amp = 7;
    private static final int type_equals = 8;
    private static final int type_ques = 9;
    private static final int type_opBrac = 10;
    private static final int type_clBrac = 11;
    private static final int type_slash = 12;
    private static final int type_backSlash = 13;
    private static final int type_dash = 14;
    private BufferedReader m_bufferedReader;
    private String m_stringStream = "";
    private XMLBlock m_headBlock = null;
    private int m_pos = -1;
    private Stack<Character> m_charStack = new Stack();
    private List<Character> m_charCache = new ArrayList<Character>();
    private boolean m_killEmptyBlocks = false;
    private boolean m_ignoreWhiteSpace = false;
    private boolean m_breakWhitespace = false;
    private boolean m_compressWhitespace = false;

    public void setStream(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(file, "UTF-8");
    }

    public void setStream(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(new File(string), string2);
    }

    private void setStream(File file, String string) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        XMLReader xMLReader = new XMLReader(file.getAbsolutePath(), string);
        this.m_bufferedReader = new BufferedReader(xMLReader);
        this._setStream();
    }

    public void setStream(BufferedReader bufferedReader) throws IOException, TranslationException {
        this.m_bufferedReader = bufferedReader;
        this._setStream();
    }

    private void _setStream() throws IOException, TranslationException {
        this.m_pos = -1;
        XMLBlock xMLBlock = this.getNextBlock();
        if (xMLBlock == null) {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + OStrings.getString("XSR_ERROR_UNABLE_INIT_READ_XML"));
        }
        if (xMLBlock.getTagName().equals("xml")) {
            String string = xMLBlock.getAttribute("version");
            if (string != null && !string.equals("") && !string.equals("1.0")) {
                throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + StaticUtils.format(OStrings.getString("XSR_ERROR_UNSUPPORTED_XML_VERSION"), string));
            }
        } else {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + OStrings.getString("XSR_ERROR_NONVALID_XML"));
        }
        this.m_headBlock = xMLBlock;
    }

    public XMLBlock getNextBlock() throws TranslationException {
        char c = this.getNextChar();
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            c = this.getNextChar();
            this.pushChar(c);
            if (c != ' ') {
                XMLBlock xMLBlock = this.getNextTag();
                return xMLBlock;
            }
        } else if (c == ']' && this.end_cdata_flag) {
            XMLBlock xMLBlock = this.getNextTagCDATAEnd();
            return xMLBlock;
        }
        this.pushChar(c);
        XMLBlock xMLBlock = this.getNextText();
        if (xMLBlock != null && this.m_killEmptyBlocks) {
            String string = xMLBlock.getText();
            if ((string = string.trim()).length() == 0) {
                xMLBlock = this.getNextBlock();
            }
        }
        return xMLBlock;
    }

    public void killEmptyBlocks() {
        this.m_killEmptyBlocks = true;
    }

    public void breakOnWhitespace(boolean bl) {
        this.m_breakWhitespace = bl;
    }

    public void compressWhitespace(boolean bl) {
        this.m_compressWhitespace = bl;
    }

    public void setEntityFilter(DefaultEntityFilter defaultEntityFilter) {
        this.entityFilter = defaultEntityFilter;
    }

    private void pushChar(char c) {
        this.m_charStack.push(new Character(c));
    }

    private char getNextCharCache() {
        char c = this.getNextChar();
        this.m_charCache.add(new Character(c));
        return c;
    }

    private void clearCache() {
        this.m_charCache.clear();
    }

    private void revertToCached() {
        for (int i = this.m_charCache.size() - 1; i >= 0; --i) {
            this.m_charStack.push(this.m_charCache.get(i));
        }
    }

    private char getNextChar() {
        if (!this.m_charStack.empty()) {
            Character c = this.m_charStack.pop();
            return c.charValue();
        }
        if (this.m_pos >= 0) {
            if (this.m_pos < this.m_stringStream.length()) {
                int n;
                if ((n = this.m_stringStream.charAt(this.m_pos++)) == 13) {
                    n = this.m_stringStream.charAt(this.m_pos);
                    if (n == 10) {
                        ++this.m_pos;
                    } else {
                        n = 10;
                    }
                }
                return (char)n;
            }
            return '\u0000';
        }
        char[] cArray = new char[2];
        try {
            char c;
            int n = this.m_bufferedReader.read(cArray, 0, 1);
            if (n > 0) {
                c = cArray[0];
                if (c == '\r') {
                    n = this.m_bufferedReader.read(cArray, 0, 1);
                    if (n > 0) {
                        c = cArray[0];
                        if (c != '\n' && c == '\r') {
                            this.pushChar('\n');
                        }
                    } else {
                        c = '\u0000';
                    }
                }
            } else {
                return '\u0000';
            }
            return c;
        }
        catch (IOException iOException) {
            Log.logErrorRB("XSR_ERROR_IOEXCEPTION", new Object[0]);
            Log.log(iOException);
            return '\u0000';
        }
    }

    private XMLBlock getNextText() throws TranslationException {
        char c;
        XMLBlock xMLBlock = new XMLBlock();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        while ((c = this.getNextChar()) != '<' && c != '\u0000') {
            char c2;
            if (c == '&') {
                bl = false;
                if (bl2) {
                    this.pushChar(c);
                    break;
                }
                c2 = this.getEscChar();
                if (c2 == '\u0000') {
                    stringBuffer.append('&');
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                if (this.m_ignoreWhiteSpace) continue;
                if (this.m_compressWhitespace) {
                    if (this.m_breakWhitespace) {
                        if (stringBuffer.length() > 0) {
                            if (bl2) continue;
                            this.pushChar(c);
                            break;
                        }
                        bl = true;
                        stringBuffer.setLength(0);
                        stringBuffer.append(" ");
                        bl2 = true;
                        continue;
                    }
                    if (bl) continue;
                    stringBuffer.append(' ');
                    bl = true;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            bl = false;
            if (bl2) {
                this.pushChar(c);
                break;
            }
            if (c == ']' && this.cdata_flag) {
                c2 = this.getNextChar();
                char c3 = this.getNextChar();
                this.pushChar(c3);
                this.pushChar(c2);
                if (c2 == ']' && c3 == '>') {
                    this.cdata_flag = false;
                    this.end_cdata_flag = true;
                    this.pushChar(c);
                    break;
                }
            }
            stringBuffer.append(c);
        }
        if (c == '<') {
            this.pushChar(c);
        }
        xMLBlock.setText(stringBuffer.toString());
        return xMLBlock;
    }

    private XMLBlock getNextTagCDATAEnd() {
        this.end_cdata_flag = false;
        XMLBlock xMLBlock = new XMLBlock();
        xMLBlock.setTypeChar('!');
        xMLBlock.setTagName("]]");
        this.getNextChar();
        this.getNextChar();
        return xMLBlock;
    }

    private XMLBlock getNextTagExclamation() throws TranslationException {
        char c;
        XMLBlock xMLBlock = new XMLBlock();
        xMLBlock.setTypeChar('!');
        String string = "";
        String string2 = "";
        int n = 1;
        boolean bl = false;
        String string3 = "";
        int n2 = 0;
        while ((c = this.getNextChar()) != '\u0000') {
            int n3 = this.getCharType(c);
            block0 : switch (n) {
                case 1: {
                    switch (n3) {
                        case 2: {
                            break block0;
                        }
                        case 1: {
                            n = 2;
                            string = string + c;
                            break block0;
                        }
                        case 10: {
                            xMLBlock.setTagName("CDATA");
                            n = 9;
                            break block0;
                        }
                        case 14: {
                            n = 10;
                            xMLBlock.setComment();
                            break block0;
                        }
                    }
                    bl = true;
                    string3 = StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n);
                    break;
                }
                case 10: {
                    if (c == '-') {
                        n = 11;
                        break;
                    }
                    bl = true;
                    string3 = OStrings.getString("XSR_ERROR_CONFUSED");
                    break;
                }
                case 11: {
                    switch (n3) {
                        case 14: {
                            if (n2 >= 2) {
                                string2 = string2 + c;
                                break block0;
                            }
                            ++n2;
                            break block0;
                        }
                        case 6: {
                            if (n2 < 2) break block0;
                            xMLBlock.setText(string2);
                            n = 3;
                            break block0;
                        }
                    }
                    if (n2 > 0) {
                        while (n2 > 0) {
                            string2 = string2 + '-';
                            --n2;
                        }
                    }
                    string2 = string2 + c;
                    break;
                }
                case 9: {
                    switch (n3) {
                        case 10: {
                            n = 3;
                            this.cdata_flag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 1: {
                            string = string + c;
                            break block0;
                        }
                        case 2: {
                            xMLBlock.setTagName(string);
                            n = 4;
                            break block0;
                        }
                        case 6: {
                            n = 3;
                            break block0;
                        }
                    }
                    bl = true;
                    string3 = StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n);
                    break;
                }
                case 4: {
                    switch (n3) {
                        case 3: {
                            n = 5;
                            string2 = string2 + c;
                            break block0;
                        }
                        case 4: {
                            n = 6;
                            string2 = string2 + c;
                            break block0;
                        }
                        case 6: {
                            n = 3;
                            xMLBlock.setAttribute(string2, "");
                            break block0;
                        }
                    }
                    string2 = string2 + c;
                    break;
                }
                case 5: {
                    switch (n3) {
                        case 3: {
                            n = 4;
                            string2 = string2 + c;
                            break block0;
                        }
                        case 13: {
                            n = 7;
                            string2 = string2 + c;
                            break block0;
                        }
                    }
                    string2 = string2 + c;
                    break;
                }
                case 7: {
                    string2 = string2 + c;
                    n = 5;
                    break;
                }
                case 6: {
                    switch (n3) {
                        case 4: {
                            n = 4;
                            string2 = string2 + c;
                            break block0;
                        }
                        case 13: {
                            n = 8;
                            string2 = string2 + c;
                            break block0;
                        }
                    }
                    string2 = string2 + c;
                    break;
                }
                case 8: {
                    string2 = string2 + c;
                    n = 6;
                }
            }
            if (bl) {
                String string4 = OStrings.getString("XSR_ERROR_TAG_NAME") + xMLBlock.getTagName() + " ";
                if (xMLBlock.isComment()) {
                    string4 = string4 + OStrings.getString("XSR_ERROR_COMMENT_TAG");
                }
                if (xMLBlock.numAttributes() > 0) {
                    string4 = string4 + xMLBlock.getAttribute((int)0).name;
                }
                throw new TranslationException(string3 + string4 + "::" + string2);
            }
            if (n != 3) continue;
            break;
        }
        return xMLBlock;
    }

    private void throwErrorInGetNextTag(XMLBlock xMLBlock, String string) throws TranslationException {
        String string2 = OStrings.getString("XSR_ERROR_TAG_NAME") + xMLBlock.getTagName() + " ";
        if (xMLBlock.isStandalone()) {
            string2 = string2 + OStrings.getString("XSR_ERROR_EMPTY_TAG");
        } else if (xMLBlock.isClose()) {
            string2 = string2 + OStrings.getString("XSR_ERROR_CLOSE_TAG");
        }
        if (xMLBlock.numAttributes() > 0) {
            string2 = string2 + OStrings.getString("XSR_ERROR_LOADED") + xMLBlock.numAttributes() + OStrings.getString("XSR_ERROR_ATTRIBUTES");
        }
        throw new TranslationException(string + string2);
    }

    private XMLBlock getNextTag() throws TranslationException {
        char c = this.getNextChar();
        if (c == '\u0000') {
            return null;
        }
        if (c == '!') {
            return this.getNextTagExclamation();
        }
        XMLBlock xMLBlock = new XMLBlock();
        if (c == '?') {
            c = this.getNextChar();
            xMLBlock.setTypeChar('?');
        }
        int n = 1;
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        while (c != '\u0000') {
            int n3 = this.getCharType(c);
            block0 : switch (n) {
                case 1: {
                    switch (n3) {
                        case 12: {
                            xMLBlock.setCloseFlag();
                            n = 3;
                            break block0;
                        }
                        case 1: {
                            string = string + c;
                            n = 2;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                case 2: {
                    switch (n3) {
                        case 1: 
                        case 14: {
                            string = string + c;
                            break block0;
                        }
                        case 2: {
                            n = 5;
                            xMLBlock.setTagName(string);
                            break block0;
                        }
                        case 12: {
                            xMLBlock.setTagName(string);
                            xMLBlock.setStandaloneFlag();
                            n = 4;
                            break block0;
                        }
                        case 6: {
                            xMLBlock.setTagName(string);
                            n = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                case 3: {
                    switch (n3) {
                        case 1: {
                            string = string + c;
                            n = 2;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                case 4: {
                    switch (n3) {
                        case 2: {
                            break block0;
                        }
                        case 6: {
                            n = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                case 5: {
                    switch (n3) {
                        case 1: {
                            string2 = string2 + c;
                            n = 6;
                            break block0;
                        }
                        case 9: {
                            n = 11;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            xMLBlock.setStandaloneFlag();
                            n = 4;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                case 11: {
                    if (c != '>') {
                        this.throwErrorInGetNextTag(xMLBlock, OStrings.getString("XSR_ERROR_FLOATING_QUESTION_MARK"));
                        break;
                    }
                    n = 10;
                    break;
                }
                case 6: {
                    switch (n3) {
                        case 1: 
                        case 14: {
                            string2 = string2 + c;
                            break block0;
                        }
                        case 8: {
                            n = 7;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                case 7: {
                    switch (n3) {
                        case 3: 
                        case 4: {
                            n = 8;
                            n2 = n3;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                case 8: {
                    switch (n3) {
                        case 3: 
                        case 4: {
                            if (n3 == n2) {
                                xMLBlock.setAttribute(string2, string3);
                                string2 = "";
                                string3 = "";
                                n = 9;
                                break block0;
                            }
                            string3 = string3 + c;
                            break block0;
                        }
                    }
                    string3 = string3 + c;
                    break;
                }
                case 9: {
                    switch (n3) {
                        case 1: {
                            string2 = string2 + c;
                            n = 6;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            xMLBlock.setStandaloneFlag();
                            n = 4;
                            break block0;
                        }
                        case 6: {
                            n = 10;
                            break block0;
                        }
                        case 9: {
                            n = 11;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(xMLBlock, StaticUtils.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), "" + c, "" + n));
                    break;
                }
                default: {
                    Log.log("INTERNAL ERROR untrapped parse state " + n);
                }
            }
            if (n == 10) break;
            c = this.getNextChar();
        }
        return xMLBlock;
    }

    private int getCharType(char c) {
        int n = 1;
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                n = 2;
                break;
            }
            case '\"': {
                n = 4;
                break;
            }
            case '\'': {
                n = 3;
                break;
            }
            case '&': {
                n = 7;
                break;
            }
            case '<': {
                n = 5;
                break;
            }
            case '>': {
                n = 6;
                break;
            }
            case '?': {
                n = 9;
                break;
            }
            case '/': {
                n = 12;
                break;
            }
            case '=': {
                n = 8;
                break;
            }
            case '[': {
                n = 10;
                break;
            }
            case ']': {
                n = 11;
                break;
            }
            case '-': {
                n = 14;
                break;
            }
            case '\\': {
                n = 13;
            }
        }
        return n;
    }

    public String makeValidXML(char c) {
        String string = StaticUtils.makeValidXML(c);
        if (string.length() == 1 && this.entityFilter != null) {
            return this.entityFilter.convertToEntity(c);
        }
        return string;
    }

    public String makeValidXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(this.makeValidXML(c));
        }
        return stringBuffer.toString();
    }

    public List<XMLBlock> closeBlock(XMLBlock xMLBlock) throws TranslationException {
        return this.closeBlock(xMLBlock, false);
    }

    public List<XMLBlock> closeBlock(XMLBlock xMLBlock, boolean bl) throws TranslationException {
        ArrayList<XMLBlock> arrayList = new ArrayList<XMLBlock>();
        if (xMLBlock == null) {
            return arrayList;
        }
        if (xMLBlock.isStandalone()) {
            return arrayList;
        }
        int n = 0;
        while (true) {
            XMLBlock xMLBlock2;
            if ((xMLBlock2 = this.getNextBlock()) == null) {
                throw new TranslationException(OStrings.getString("XSR_ERROR_END_OF_STREAM"));
            }
            if (xMLBlock2.isTag() && xMLBlock2.getTagName().equals(xMLBlock.getTagName())) {
                if (xMLBlock2.isClose()) {
                    if (n == 0) {
                        if (!bl) break;
                        arrayList.add(xMLBlock2);
                        break;
                    }
                    --n;
                } else {
                    ++n;
                }
                arrayList.add(xMLBlock2);
                continue;
            }
            arrayList.add(xMLBlock2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList;
    }

    public XMLBlock advanceToTag(String string) throws TranslationException {
        XMLBlock xMLBlock;
        while (!((xMLBlock = this.getNextBlock()) == null || xMLBlock.isTag() && xMLBlock.getTagName().equals(string))) {
        }
        return xMLBlock;
    }

    private char getEscChar() throws TranslationException {
        this.clearCache();
        char c = this.getNextCharCache();
        String string = "";
        boolean bl = false;
        if (c == '#') {
            c = this.getNextCharCache();
            if (c == 'x' || c == 'X') {
                c = this.getNextCharCache();
                bl = true;
            }
        } else if (c == ' ') {
            this.revertToCached();
            return '\u0000';
        }
        int n = 0;
        while (c != ';') {
            string = string + c;
            if (c == '\u0000') {
                throw new TranslationException(OStrings.getString("XSR_ERROR_UNTERMINATED_ESCAPE_CHAR"));
            }
            c = this.getNextCharCache();
            if (n++ <= 13) continue;
            this.revertToCached();
            return '\u0000';
        }
        this.clearCache();
        if (string.equals("amp")) {
            return '&';
        }
        if (string.equals("lt")) {
            return '<';
        }
        if (string.equals("gt")) {
            return '>';
        }
        if (string.equals("apos")) {
            return '\'';
        }
        if (string.equals("quot")) {
            return '\"';
        }
        if (this.entityFilter != null) {
            return this.entityFilter.convertToSymbol(string);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                c = (char)(c * 16);
                if (c2 >= '0' && c2 <= '9') {
                    c = (char)(c + (c2 - 48));
                    continue;
                }
                if (c2 >= 'A' && c2 <= 'F') {
                    c = (char)(c + 10);
                    c = (char)(c + (c2 - 65));
                    continue;
                }
                if (c2 >= 'a' && c2 <= 'f') {
                    c = (char)(c + 10);
                    c = (char)(c + (c2 - 97));
                    continue;
                }
                throw new TranslationException(StaticUtils.format(OStrings.getString("XSR_ERROR_BAD_BINARY_CHAR"), string));
            }
            c = (char)(c * 10);
            if (c2 >= '0' && c2 <= '9') {
                c = (char)(c + (c2 - 48));
                continue;
            }
            throw new TranslationException(StaticUtils.format(OStrings.getString("XSR_ERROR_BAD_DECIMAL_CHAR"), string));
        }
        return c;
    }

    public XMLBlock getHeadBlock() {
        return this.m_headBlock;
    }

    public void close() throws IOException {
        this.m_bufferedReader.close();
    }
}

