/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 */
public class ExecuteUpdateMethodPhp extends BlancoDbAbstractMethod {
    public ExecuteUpdateMethodPhp(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                "executeUpdate", "s^NGs܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setReturn(fCgFactory.createReturn("integer", "ꂽs"));

        /*
         * VOLłꍇɂ protectedƂ܂B
         */
        if (fSqlInfo.getSingle()) {
            cgMethod.setAccess("protected");
        } else {
            // publiĉ܂܂łB
        }

        cgMethod.getLangDoc().getDescriptionList().add(
                "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B");

        if (fSqlInfo.getSingle()) {
            cgMethod.getLangDoc().getDescriptionList().add("");
            cgMethod.getLangDoc().getDescriptionList().add(
                    "VOLȂ̂ŃXR[vprotectedƂ܂B");
            cgMethod.getLangDoc().getDescriptionList().add(
                    "̃\bh̑ ExecuteSingleUpdate\bh𗘗pĂB");
        }

        final List listLine = cgMethod.getLineList();

        // statementmۂł΂AIprepareStatementĂяo܂B
        listLine.add("if ($this->fStatement == NULL) {");
        listLine
                .add("// PreparedStatement擾̏ԂȂ̂ŁAExecuteNonQuery()sɐ旧PrepareStatement()\bhĂяoĎ擾܂B");
        listLine.add("$this->prepareStatement();");
        listLine.add("}");

        listLine.add("");

        String parameteres = "";
        for (int index = 0; index < fSqlInfo.getInParameterList().size(); index++) {
            final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) fSqlInfo
                    .getInParameterList().get(index);

            if (index != 0) {
                parameteres += ", ";
            }
            parameteres += "$this->f"
                    + BlancoNameAdjuster.toClassName(columnStructure.getName());
        }

        // O܂߂ēWJ܂B
        listLine.add("// TODO OĂ܂B");
        listLine.add("$result = $this->fStatement->execute();");
        listLine.add("return $this->fStatement->rowCount();");
    }
}