/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.valueobject;

import java.util.List;

/**
 * \bh\邽߂̃o[IuWFNgB
 *
 * |CgF\bh̖Oό`́AblancoCgɗ^OɎ{ĂKv܂B
 */
public class BlancoCgMethod {
    /**
     * ̃\bh̖OłB
     *
     * tB[h: [name]B
     */
    private String fName;

    /**
     * ̃\bh̐łB
     *
     * tB[h: [description]B
     */
    private String fDescription;

    /**
     * ̃\bh̃ANZXRg[w肵܂B
     *
     * public/protected/privateȂǂw肵܂B
     * tB[h: [access]B
     * ftHg: ["public"]B
     */
    private String fAccess = "public";

    /**
     * ۃNXǂB
     *
     * tB[h: [abstract]B
     * ftHg: [false]B
     */
    private boolean fAbstract = false;

    /**
     * staticǂB
     *
     * tB[h: [static]B
     * ftHg: [false]B
     */
    private boolean fStatic = false;

    /**
     * I[oChĂ邩ǂB
     *
     * tB[h: [override]B
     * ftHg: [false]B
     */
    private boolean fOverride = false;

    /**
     * finalǂB
     *
     * tB[h: [final]B
     * ftHg: [false]B
     */
    private boolean fFinal = false;

    /**
     * RXgN^ǂB
     *
     * tB[h: [constructor]B
     * ftHg: [false]B
     */
    private boolean fConstructor = false;

    /**
     * static initializer ǂB_(2009-05-18)ł Java ł̂ݗLłB
     *
     * tB[h: [staticInitializer]B
     * ftHg: [false]B
     */
    private boolean fStaticInitializer = false;

    /**
     * ̃\bh̃p[^̃XgłB
     *
     * tB[h: [parameterList]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgParameter>()]B
     */
    private List<blanco.cg.valueobject.BlancoCgParameter> fParameterList = new java.util.ArrayList<blanco.cg.valueobject.BlancoCgParameter>();

    /**
     * ̃\bh̖߂lłB
     *
     * tB[h: [return]B
     */
    private BlancoCgReturn fReturn;

    /**
     * ̃\bhÖꗗłB
     *
     * tB[h: [throwList]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgException>()]B
     */
    private List<blanco.cg.valueobject.BlancoCgException> fThrowList = new java.util.ArrayList<blanco.cg.valueobject.BlancoCgException>();

    /**
     * ̃\bhɕt^ĂAme[ṼXgłB
     *
     * tB[h: [annotationList]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     */
    private List<java.lang.String> fAnnotationList = new java.util.ArrayList<java.lang.String>();

    /**
     * ̃\bhɊ܂܂s̃XgłB
     *
     * tB[h: [lineList]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     */
    private List<java.lang.String> fLineList = new java.util.ArrayList<java.lang.String>();

    /**
     * RXgN^̏ꍇɂ́AJavaꂾ super()AC#.NET base()̕SĂw肵܂Bʃ\bh̏ꍇɂ́AJavaꂾ super()̕SĂw肵܂BZ~R͊܂݂܂B
     *
     * tB[h: [superclassInvocation]B
     */
    private String fSuperclassInvocation;

    /**
     * hLg~܂BftHgȏ̕\ǉꍇɂ́ACX^X𐶐ĒlZbgĂ玩܂B
     *
     * tB[h: [langDoc]B
     */
    private BlancoCgLangDoc fLangDoc;

    /**
     * tB[h [name] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bh̖OłB]B
     *
     * @param argName tB[h[name]ɐݒ肷lB
     */
    public void setName(final String argName) {
        fName = argName;
    }

    /**
     * tB[h [name] ̒l擾܂B
     *
     * tB[h̐: [̃\bh̖OłB]B
     *
     * @return tB[h[name]擾lB
     */
    public String getName() {
        return fName;
    }

    /**
     * tB[h [description] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bh̐łB]B
     *
     * @param argDescription tB[h[description]ɐݒ肷lB
     */
    public void setDescription(final String argDescription) {
        fDescription = argDescription;
    }

    /**
     * tB[h [description] ̒l擾܂B
     *
     * tB[h̐: [̃\bh̐łB]B
     *
     * @return tB[h[description]擾lB
     */
    public String getDescription() {
        return fDescription;
    }

    /**
     * tB[h [access] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bh̃ANZXRg[w肵܂B]B
     * public/protected/privateȂǂw肵܂B
     *
     * @param argAccess tB[h[access]ɐݒ肷lB
     */
    public void setAccess(final String argAccess) {
        fAccess = argAccess;
    }

    /**
     * tB[h [access] ̒l擾܂B
     *
     * tB[h̐: [̃\bh̃ANZXRg[w肵܂B]B
     * public/protected/privateȂǂw肵܂B
     * ftHg: ["public"]B
     *
     * @return tB[h[access]擾lB
     */
    public String getAccess() {
        return fAccess;
    }

    /**
     * tB[h [abstract] ̒lݒ肵܂B
     *
     * tB[h̐: [ۃNXǂB]B
     *
     * @param argAbstract tB[h[abstract]ɐݒ肷lB
     */
    public void setAbstract(final boolean argAbstract) {
        fAbstract = argAbstract;
    }

    /**
     * tB[h [abstract] ̒l擾܂B
     *
     * tB[h̐: [ۃNXǂB]B
     * ftHg: [false]B
     *
     * @return tB[h[abstract]擾lB
     */
    public boolean getAbstract() {
        return fAbstract;
    }

    /**
     * tB[h [static] ̒lݒ肵܂B
     *
     * tB[h̐: [staticǂB]B
     *
     * @param argStatic tB[h[static]ɐݒ肷lB
     */
    public void setStatic(final boolean argStatic) {
        fStatic = argStatic;
    }

    /**
     * tB[h [static] ̒l擾܂B
     *
     * tB[h̐: [staticǂB]B
     * ftHg: [false]B
     *
     * @return tB[h[static]擾lB
     */
    public boolean getStatic() {
        return fStatic;
    }

    /**
     * tB[h [override] ̒lݒ肵܂B
     *
     * tB[h̐: [I[oChĂ邩ǂB]B
     *
     * @param argOverride tB[h[override]ɐݒ肷lB
     */
    public void setOverride(final boolean argOverride) {
        fOverride = argOverride;
    }

    /**
     * tB[h [override] ̒l擾܂B
     *
     * tB[h̐: [I[oChĂ邩ǂB]B
     * ftHg: [false]B
     *
     * @return tB[h[override]擾lB
     */
    public boolean getOverride() {
        return fOverride;
    }

    /**
     * tB[h [final] ̒lݒ肵܂B
     *
     * tB[h̐: [finalǂB]B
     *
     * @param argFinal tB[h[final]ɐݒ肷lB
     */
    public void setFinal(final boolean argFinal) {
        fFinal = argFinal;
    }

    /**
     * tB[h [final] ̒l擾܂B
     *
     * tB[h̐: [finalǂB]B
     * ftHg: [false]B
     *
     * @return tB[h[final]擾lB
     */
    public boolean getFinal() {
        return fFinal;
    }

    /**
     * tB[h [constructor] ̒lݒ肵܂B
     *
     * tB[h̐: [RXgN^ǂB]B
     *
     * @param argConstructor tB[h[constructor]ɐݒ肷lB
     */
    public void setConstructor(final boolean argConstructor) {
        fConstructor = argConstructor;
    }

    /**
     * tB[h [constructor] ̒l擾܂B
     *
     * tB[h̐: [RXgN^ǂB]B
     * ftHg: [false]B
     *
     * @return tB[h[constructor]擾lB
     */
    public boolean getConstructor() {
        return fConstructor;
    }

    /**
     * tB[h [staticInitializer] ̒lݒ肵܂B
     *
     * tB[h̐: [static initializer ǂB_(2009-05-18)ł Java ł̂ݗLłB]B
     *
     * @param argStaticInitializer tB[h[staticInitializer]ɐݒ肷lB
     */
    public void setStaticInitializer(final boolean argStaticInitializer) {
        fStaticInitializer = argStaticInitializer;
    }

    /**
     * tB[h [staticInitializer] ̒l擾܂B
     *
     * tB[h̐: [static initializer ǂB_(2009-05-18)ł Java ł̂ݗLłB]B
     * ftHg: [false]B
     *
     * @return tB[h[staticInitializer]擾lB
     */
    public boolean getStaticInitializer() {
        return fStaticInitializer;
    }

    /**
     * tB[h [parameterList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bh̃p[^̃XgłB]B
     *
     * @param argParameterList tB[h[parameterList]ɐݒ肷lB
     */
    public void setParameterList(final List<blanco.cg.valueobject.BlancoCgParameter> argParameterList) {
        fParameterList = argParameterList;
    }

    /**
     * tB[h [parameterList] ̒l擾܂B
     *
     * tB[h̐: [̃\bh̃p[^̃XgłB]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgParameter>()]B
     *
     * @return tB[h[parameterList]擾lB
     */
    public List<blanco.cg.valueobject.BlancoCgParameter> getParameterList() {
        return fParameterList;
    }

    /**
     * tB[h [return] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bh̖߂lłB]B
     *
     * @param argReturn tB[h[return]ɐݒ肷lB
     */
    public void setReturn(final BlancoCgReturn argReturn) {
        fReturn = argReturn;
    }

    /**
     * tB[h [return] ̒l擾܂B
     *
     * tB[h̐: [̃\bh̖߂lłB]B
     *
     * @return tB[h[return]擾lB
     */
    public BlancoCgReturn getReturn() {
        return fReturn;
    }

    /**
     * tB[h [throwList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bhÖꗗłB]B
     *
     * @param argThrowList tB[h[throwList]ɐݒ肷lB
     */
    public void setThrowList(final List<blanco.cg.valueobject.BlancoCgException> argThrowList) {
        fThrowList = argThrowList;
    }

    /**
     * tB[h [throwList] ̒l擾܂B
     *
     * tB[h̐: [̃\bhÖꗗłB]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgException>()]B
     *
     * @return tB[h[throwList]擾lB
     */
    public List<blanco.cg.valueobject.BlancoCgException> getThrowList() {
        return fThrowList;
    }

    /**
     * tB[h [annotationList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bhɕt^ĂAme[ṼXgłB]B
     *
     * @param argAnnotationList tB[h[annotationList]ɐݒ肷lB
     */
    public void setAnnotationList(final List<java.lang.String> argAnnotationList) {
        fAnnotationList = argAnnotationList;
    }

    /**
     * tB[h [annotationList] ̒l擾܂B
     *
     * tB[h̐: [̃\bhɕt^ĂAme[ṼXgłB]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     *
     * @return tB[h[annotationList]擾lB
     */
    public List<java.lang.String> getAnnotationList() {
        return fAnnotationList;
    }

    /**
     * tB[h [lineList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃\bhɊ܂܂s̃XgłB]B
     *
     * @param argLineList tB[h[lineList]ɐݒ肷lB
     */
    public void setLineList(final List<java.lang.String> argLineList) {
        fLineList = argLineList;
    }

    /**
     * tB[h [lineList] ̒l擾܂B
     *
     * tB[h̐: [̃\bhɊ܂܂s̃XgłB]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     *
     * @return tB[h[lineList]擾lB
     */
    public List<java.lang.String> getLineList() {
        return fLineList;
    }

    /**
     * tB[h [superclassInvocation] ̒lݒ肵܂B
     *
     * tB[h̐: [RXgN^̏ꍇɂ́AJavaꂾ super()AC#.NET base()̕SĂw肵܂Bʃ\bh̏ꍇɂ́AJavaꂾ super()̕SĂw肵܂BZ~R͊܂݂܂B]B
     *
     * @param argSuperclassInvocation tB[h[superclassInvocation]ɐݒ肷lB
     */
    public void setSuperclassInvocation(final String argSuperclassInvocation) {
        fSuperclassInvocation = argSuperclassInvocation;
    }

    /**
     * tB[h [superclassInvocation] ̒l擾܂B
     *
     * tB[h̐: [RXgN^̏ꍇɂ́AJavaꂾ super()AC#.NET base()̕SĂw肵܂Bʃ\bh̏ꍇɂ́AJavaꂾ super()̕SĂw肵܂BZ~R͊܂݂܂B]B
     *
     * @return tB[h[superclassInvocation]擾lB
     */
    public String getSuperclassInvocation() {
        return fSuperclassInvocation;
    }

    /**
     * tB[h [langDoc] ̒lݒ肵܂B
     *
     * tB[h̐: [hLg~܂BftHgȏ̕\ǉꍇɂ́ACX^X𐶐ĒlZbgĂ玩܂B]B
     *
     * @param argLangDoc tB[h[langDoc]ɐݒ肷lB
     */
    public void setLangDoc(final BlancoCgLangDoc argLangDoc) {
        fLangDoc = argLangDoc;
    }

    /**
     * tB[h [langDoc] ̒l擾܂B
     *
     * tB[h̐: [hLg~܂BftHgȏ̕\ǉꍇɂ́ACX^X𐶐ĒlZbgĂ玩܂B]B
     *
     * @return tB[h[langDoc]擾lB
     */
    public BlancoCgLangDoc getLangDoc() {
        return fLangDoc;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.cg.valueobject.BlancoCgMethod[");
        buf.append("name=" + fName);
        buf.append(",description=" + fDescription);
        buf.append(",access=" + fAccess);
        buf.append(",abstract=" + fAbstract);
        buf.append(",static=" + fStatic);
        buf.append(",override=" + fOverride);
        buf.append(",final=" + fFinal);
        buf.append(",constructor=" + fConstructor);
        buf.append(",staticInitializer=" + fStaticInitializer);
        buf.append(",parameterList=" + fParameterList);
        buf.append(",return=" + fReturn);
        buf.append(",throwList=" + fThrowList);
        buf.append(",annotationList=" + fAnnotationList);
        buf.append(",lineList=" + fLineList);
        buf.append(",superclassInvocation=" + fSuperclassInvocation);
        buf.append(",langDoc=" + fLangDoc);
        buf.append("]");
        return buf.toString();
    }
}
