/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen;

import java.io.File;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoXmlUtil;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandDocumentProvider;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandEditor;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandManifest;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandPlugin;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandPluginUtil;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandPluginXml;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandWizard;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandWizardPage;
import blanco.eclipseplugingen.expand.BlancoEclipsePluginGenExpandWizardPage99;

/**
 * XMLt@C(^)Java\[XR[h܂B
 * 
 * XMLt@C͂JavaNXE\[XR[h܂B <br>
 * 
 * @author IGA Tosiki
 */
public class BlancoEclipsePluginGenXml2JavaClass {
    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * XMLt@CJava\[XR[h𐶐܂B
     * 
     * @param fileSource
     *            XML^̓t@C
     * @param directoryTarget
     *            \[XR[ho̓fBNg
     * @param directoryRoot
     *            [gfBNgBplugin.xml̏o͐Ƃėp܂B
     */
    public void process(final File fileSource, final File directoryTarget,
            final File directoryRoot) {
        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileSource);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                NodeList listCommon = elementSheet
                        .getElementsByTagName("blancoeclipseplugingen-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);
                final String taskName = BlancoXmlUtil.getTextContent(
                        elementCommon, "name");
                if (taskName == null || taskName.trim().length() == 0) {
                    // ^XNꍇɂ̓XLbv܂B
                    continue;
                }

                expandSheet(elementSheet, directoryTarget, directoryRoot);
            }
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param elementSheet
     *            ΏۂƂV[g
     * @param directoryTarget
     *            o͐fBNg
     * @param directoryRoot
     *            [gfBNgBplugin.xml̏o͐Ƃėp܂B
     */
    void expandSheet(final Element elementSheet, final File directoryTarget,
            final File directoryRoot) {
        final NodeList listCommon = elementSheet
                .getElementsByTagName("blancoeclipseplugingen-common");
        final Element elementCommon = (Element) listCommon.item(0);

        final NodeList listList = elementSheet
                .getElementsByTagName("blancoeclipseplugingen-list");
        if (listList.getLength() == 0) {
            return;
        }

        directoryTarget.mkdirs();
        final BlancoEclipsePluginGenExpandPlugin expandPlugin = new BlancoEclipsePluginGenExpandPlugin();
        expandPlugin.setEncoding(fEncoding);
        expandPlugin.expand(elementCommon, listList, directoryTarget);

        final BlancoEclipsePluginGenExpandDocumentProvider expandDocumentProvider = new BlancoEclipsePluginGenExpandDocumentProvider();
        expandDocumentProvider.setEncoding(fEncoding);
        expandDocumentProvider.expand(elementCommon, listList, directoryTarget);

        final BlancoEclipsePluginGenExpandEditor expandEditor = new BlancoEclipsePluginGenExpandEditor();
        expandEditor.setEncoding(fEncoding);
        expandEditor.expand(elementCommon, listList, directoryTarget);

        final BlancoEclipsePluginGenExpandPluginUtil expandPluginUtil = new BlancoEclipsePluginGenExpandPluginUtil();
        expandPluginUtil.setEncoding(fEncoding);
        expandPluginUtil.expand(elementCommon, listList, directoryTarget);

        // WizardWJ܂B
        final BlancoEclipsePluginGenExpandWizard expandWizard = new BlancoEclipsePluginGenExpandWizard();
        expandWizard.setEncoding(fEncoding);
        expandWizard.expand(elementCommon, listList, directoryTarget);

        final BlancoEclipsePluginGenExpandWizardPage expandWiazardPage = new BlancoEclipsePluginGenExpandWizardPage();
        expandWiazardPage.setEncoding(fEncoding);
        expandWiazardPage.expand(elementCommon, listList, directoryTarget);

        final BlancoEclipsePluginGenExpandWizardPage99 expandWizardPage99 = new BlancoEclipsePluginGenExpandWizardPage99();
        expandWizardPage99.setEncoding(fEncoding);
        expandWizardPage99.expand(elementCommon, listList, directoryTarget);

        // XMLt@CWJ܂B
        new BlancoEclipsePluginGenExpandPluginXml().expand(elementCommon,
                listList, directoryRoot);
        // MANIFEST.MFWJ܂B
        new BlancoEclipsePluginGenExpandManifest().expand(elementCommon,
                listList, directoryRoot);
    }
}