/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;

public class BlancoEclipsePluginGenExpandDocumentProvider {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(packageName + ".editors",
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.setEncoding(fEncoding);
        fCgSourceFile.getLangDoc().getDescriptionList().add(
                "EclipsevOC [" + pluginName + "]̃hLgvoC_NX");

        fCgClass = fCgFactory.createClass(BlancoNameAdjuster
                .toClassName(pluginName)
                + "DocumentProvider", "EclipsevOC [" + pluginName
                + "]̃hLgvoC_NXB");
        fCgSourceFile.getClassList().add(fCgClass);

        if (description != null) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    BlancoJavaSourceUtil.escapeStringAsJavaDoc(description)
                            + "<br>");
        }

        fCgClass
                .getExtendClassList()
                .add(
                        fCgFactory
                                .createType("org.eclipse.ui.editors.text.StorageDocumentProvider"));
        fCgSourceFile.getImportList().add("java.io.ByteArrayInputStream");

        fCgSourceFile.getImportList().add("java.io.InputStream");
        fCgSourceFile.getImportList().add(
                "java.io.UnsupportedEncodingException");
        fCgSourceFile.getImportList().add(
                "org.eclipse.core.runtime.CoreException");
        fCgSourceFile.getImportList().add(
                "org.eclipse.core.runtime.IProgressMonitor");
        fCgSourceFile.getImportList().add("org.eclipse.jface.text.IDocument");
        fCgSourceFile.getImportList().add("org.eclipse.ui.IFileEditorInput");
        fCgSourceFile.getImportList().add(
                "org.eclipse.ui.editors.text.StorageDocumentProvider");

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "setDocumentContent", "hLg̓ǂݍݏI[o[Ch܂B");
            fCgClass.getMethodList().add(method);
            method.setAccess("protected");

            method.getParameterList()
                    .add(
                            fCgFactory.createParameter("document",
                                    "org.eclipse.jface.text.IDocument",
                                    "hLgIuWFNg"));
            method.getParameterList().add(
                    fCgFactory.createParameter("contentStream",
                            "java.io.InputStream", "Rec̃Xg["));
            method.getParameterList().add(
                    fCgFactory.createParameter("encodingIgnored",
                            "java.lang.String",
                            "GR[fBOw肪Ăяon܂B̃p[^͖܂B"));
            method.getThrowList().add(
                    fCgFactory.createException(
                            "org.eclipse.core.runtime.CoreException", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("// GR[fBO͖ċI UTF-8Ƃ܂B");
            listLine
                    .add("super.setDocumentContent(document, contentStream, \"UTF-8\");");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "doSaveDocument", "hLg̕ۑI[o[Ch܂B");
            fCgClass.getMethodList().add(method);
            method.setAccess("protected");

            method.getParameterList().add(
                    fCgFactory.createParameter("monitor",
                            "org.eclipse.core.runtime.IProgressMonitor",
                            "Eclipse̐ij^"));
            method.getParameterList().add(
                    fCgFactory.createParameter("element", "java.lang.Object",
                            "Gg"));
            method.getParameterList()
                    .add(
                            fCgFactory.createParameter("document",
                                    "org.eclipse.jface.text.IDocument",
                                    "hLgIuWFNg"));
            method.getParameterList().add(
                    fCgFactory.createParameter("overwrite", "boolean",
                            "㏑ǂ"));

            method.getThrowList().add(
                    fCgFactory.createException(
                            "org.eclipse.core.runtime.CoreException", ""));

            final List<java.lang.String> listLine = method.getLineList();

            listLine.add("if (element instanceof IFileEditorInput) {");
            listLine.add("// ̏ꏊŕۑs܂B");
            listLine
                    .add("IFileEditorInput input = (IFileEditorInput) element;");
            listLine.add("String editorText = getDocument(input).get();");
            listLine.add("");
            listLine.add("try {");
            listLine
                    .add("input.getFile().setContents(new ByteArrayInputStream(editorText.getBytes(\"UTF-8\")), true, false, monitor);");
            listLine.add("} catch (UnsupportedEncodingException e) {");
            listLine.add("// ̃P[X݂͑܂B");
            listLine.add("e.printStackTrace();");
            listLine.add("}");
            listLine.add("}");
        }

        // \[XR[hۂɐ܂B
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}
