/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.List;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfStructure;
import blanco.xml.bind.BlancoXmlMarshaller;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * faces-config-logic-proxy.xml 𐶐܂B
 */
class BlancoJsfExpandFacesConfig {
    public void expandXmlFile(final List<BlancoJsfStructure> structureList,
            final BlancoJsfProcessInput input) {
        final BlancoXmlMarshaller marshaller = new BlancoXmlMarshaller();
        final BlancoXmlDocument document = new BlancoXmlDocument();
        final BlancoXmlElement eleRoot = new BlancoXmlElement();
        document.getChildNodes().add(eleRoot);
        eleRoot.setLocalName("faces-config");

        {
            final BlancoXmlAttribute attr = new BlancoXmlAttribute();
            eleRoot.getAtts().add(attr);
            attr.setQName("xmlns");
            attr.setValue("http://java.sun.com/xml/ns/javaee");
        }
        {
            final BlancoXmlAttribute attr = new BlancoXmlAttribute();
            eleRoot.getAtts().add(attr);
            attr.setQName("xmlns:xsi");
            attr.setValue("http://www.w3.org/2001/XMLSchema-instance");
        }
        {
            final BlancoXmlAttribute attr = new BlancoXmlAttribute();
            eleRoot.getAtts().add(attr);
            attr.setQName("xsi:schemaLocation");
            attr
                    .setValue("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-facesconfig_1_2.xsd");
        }
        {
            final BlancoXmlAttribute attr = new BlancoXmlAttribute();
            eleRoot.getAtts().add(attr);
            attr.setQName("version");
            attr.setValue("1.2");
        }

        for (BlancoJsfStructure structure : structureList) {
            {
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue("\n\t");
                eleRoot.getChildNodes().add(chars);
            }

            final BlancoXmlElement eleMBean = new BlancoXmlElement();
            eleRoot.getChildNodes().add(eleMBean);
            eleMBean.setLocalName("managed-bean");

            {
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue("\n\t\t");
                eleMBean.getChildNodes().add(chars);
            }

            final BlancoXmlElement eleBeanName = new BlancoXmlElement();
            eleMBean.getChildNodes().add(eleBeanName);
            eleBeanName.setLocalName("managed-bean-name");
            {
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue(BlancoNameAdjuster
                        .toLowerCaseTitle(BlancoNameAdjuster
                                .toClassName(structure.getName()))
                        + structure.getSuffix());
                eleBeanName.getChildNodes().add(chars);
            }

            {
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue("\n\t\t");
                eleMBean.getChildNodes().add(chars);
            }

            final BlancoXmlElement eleBeanClass = new BlancoXmlElement();
            eleMBean.getChildNodes().add(eleBeanClass);
            eleBeanClass.setLocalName("managed-bean-class");
            {
                // Proxy NXւ̖OǂݑւŎBꂪ邩 DI ł܂B
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue(structure.getPackage() + ".proxy."
                        + BlancoNameAdjuster.toClassName(structure.getName())
                        + structure.getSuffix() + "Proxy");
                eleBeanClass.getChildNodes().add(chars);
            }

            {
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue("\n\t\t");
                eleMBean.getChildNodes().add(chars);
            }

            final BlancoXmlElement eleBeanScope = new BlancoXmlElement();
            eleMBean.getChildNodes().add(eleBeanScope);
            eleBeanScope.setLocalName("managed-bean-scope");
            {
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue("request");
                eleBeanScope.getChildNodes().add(chars);
            }

            {
                final BlancoXmlCharacters chars = new BlancoXmlCharacters();
                chars.setValue("\n\t");
                eleMBean.getChildNodes().add(chars);
            }
        }

        {
            final BlancoXmlCharacters chars = new BlancoXmlCharacters();
            chars.setValue("\n");
            eleRoot.getChildNodes().add(chars);
        }

        marshaller.marshal(document, new File(
                new File(input.getTargetdirxml()),
                "faces-config-logic-proxy.xml"));
    }
}
