/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.csv.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import blanco.sample.csv.record.BlancoCsvSample3CsvRecord;

/**
 * t@C`[BlancoCsvSample3/̃NX͒PɃTvłBsPsځB(&lt;&gt;&quot;QƃGR[fBO)]̃[_NXB
 *
 * ̃NXblancoCsvt@C`玩ꂽ[_NXłB<br>
 * @1.񒷃`FbNɂ́AftHgGR[fBO𗘗p܂B<br>
 * @2.NX̗p͕K close()ĂяoĂB<br>
 */
public class BlancoCsvSample3CsvReader {
    /**
     * [_IuWFNg
     *
     * CSVŊ֘AÂAۂɓ͂s[_B
     */
    protected BufferedReader fReader;

    /**
     * ݏ̍sJE^B
     *
     * ݏsĂs̈ʒuB
     */
    protected long fLineCounter = 0;

    /**
     * ݏ̍sf[^B
     */
    protected String fLine;

    /**
     * ݏ̍ŝ߂̃[_B
     */
    protected StringReader fLineReader;

    /**
     * ^CgsꂽǂB
     */
    protected boolean fIsTitleProcessed = false;

    /**
     * [field_5]̓ǂݍ݂̍ۂɗptH[}b^[B
     *
     * CX^XĂƂɂ胁S~}܂B
     */
    protected SimpleDateFormat fSimpleDateFormatField5;

    /**
     * [field_15]̓ǂݍ݂̍ۂɗptH[}b^[B
     *
     * CX^XĂƂɂ胁S~}܂B
     */
    protected SimpleDateFormat fSimpleDateFormatField15;

    /**
     * CSV[_NX̃RXgN^B
     */
    public BlancoCsvSample3CsvReader() {
        init();
    }

    /**
     * CSV[_NX̃RXgN^B
     *
     * ^ꂽ[_֘AÂ܂B
     *
     * @param arg ֘AÂ郊[_B
     */
    public BlancoCsvSample3CsvReader(final BufferedReader arg) {
        fReader = arg;
        init();
    }

    /**
     * Ȃ܂B
     */
    protected void init() {
        fSimpleDateFormatField5 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        // t/͂ɂȂ܂B
        fSimpleDateFormatField5.setLenient(false);
        fSimpleDateFormatField15 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        // t/͂ɂȂ܂B
        fSimpleDateFormatField15.setLenient(false);
    }

    /**
     * ֘AÂꂽ[_Äsǂݍ݂܂B
     *
     * @return sIuWFNgԂ܂B[_I[ɒBA͂sꍇɂ nullԂ܂B
     * @throws BlancoCsvIOException ̓f[^sȏꍇȂǁB
     * @throws IOException ֘AÂꂽ[_ŗOꍇB
     */
    public BlancoCsvSample3CsvRecord readRecord() throws BlancoCsvIOException, IOException {
        if (fReader == null) {
            throw new IllegalArgumentException("[BlancoCsvSample3] [_ݒ肳ĂȂԂŃ\bh[readRecord]Ăяo܂B͋܂B[_ZbgĂĂтĂB");
        }

        if (fIsTitleProcessed == false) {
            // ^Cgsǂݔ΂B
            fReader.readLine();
            fIsTitleProcessed = true;
        }

        fLine = fReader.readLine();
        if (fLine == null) {
            // t@C̏I[ɓB܂B
            return null;
        }
        fLineCounter++;
        final BlancoCsvSample3CsvRecord record = new BlancoCsvSample3CsvRecord();
        fLineReader = new StringReader(fLine);
        String tokenString = null;

        // ڔԍ[1]ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 1ږځBڔԍ[1] ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // CӍځB
        if (tokenString.length() == 0) {
            // K{ڂł͂Ȃ񍀖ڂɒ0̒lǂݍ܂ꂽꍇɂ́Aǂݍ݌̒lƂĂ0̕Ƃ܂B
            record.setField1(tokenString);
        } else {
            if (tokenString.getBytes().length < 1) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 1ږځBڔԍ[1] ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + tokenString + "]m܂B");
            }
            if (tokenString.getBytes().length > 10) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 1ږځBڔԍ[1] ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(10)l[" + tokenString + "]m܂B");
            }
            record.setField1(tokenString);
        }

        // ڔԍ[2]ږ[field_2/tB[h2BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        // NI[glǂݍ݂s܂B
        tokenString = readTokenWithQuote('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 2ږځBڔԍ[2] ږ[field_2/tB[h2BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // CӍځB
        if (tokenString.length() == 0) {
            // K{ڂł͂Ȃ񍀖ڂɒ0̒lǂݍ܂ꂽꍇɂ́Aǂݍ݌̒lƂĂ0̕Ƃ܂B
            record.setField2(tokenString);
        } else {
            if (tokenString.getBytes().length < 4) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 2ږځBڔԍ[2] ږ[field_2/tB[h2BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(4)Zl[" + tokenString + "]m܂B");
            }
            if (tokenString.getBytes().length > 4) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 2ږځBڔԍ[2] ږ[field_2/tB[h2BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(4)l[" + tokenString + "]m܂B");
            }
            record.setField2(tokenString);
        }

        // ڔԍ[3]ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 3ږځBڔԍ[3] ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // CӍځB
        if (tokenString.length() == 0) {
            // K{ڂł͂Ȃڂɒ0̒lǂݍ܂ꂽꍇɂ́AlƂnull܂B
            record.setField3(null);
        } else {
            if (tokenString.getBytes().length < 1) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 3ږځBڔԍ[3] ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + tokenString + "]m܂B");
            }
            if (tokenString.getBytes().length > 3) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 3ږځBڔԍ[3] ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(3)l[" + tokenString + "]m܂B");
            }
            try {
                record.setField3(new Integer(tokenString));
            } catch (NumberFormatException ex) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 3ږځBڔԍ[3] ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĐl(int)ƂĂ͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
            }
        }

        // ڔԍ[4]ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 4ږځBڔԍ[4] ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // CӍځB
        if (tokenString.length() == 0) {
            // K{ڂł͂Ȃڂɒ0̒lǂݍ܂ꂽꍇɂ́AlƂnull܂B
            record.setField4(null);
        } else {
            if (tokenString.getBytes().length < 1) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 4ږځBڔԍ[4] ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + tokenString + "]m܂B");
            }
            if (tokenString.getBytes().length > 3) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 4ږځBڔԍ[4] ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(3)l[" + tokenString + "]m܂B");
            }
            try {
                record.setField4(new Long(tokenString));
            } catch (NumberFormatException ex) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 4ږځBڔԍ[4] ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĐl(long)ƂĂ͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
            }
        }

        // ڔԍ[5]ږ[field_5/tB[h5BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 5ږځBڔԍ[5] ږ[field_5/tB[h5BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // CӍځB
        if (tokenString.length() == 0) {
            // K{ڂł͂Ȃڂɒ0̒lǂݍ܂ꂽꍇɂ́AlƂnull܂B
            record.setField5(null);
        } else {
            try {
                record.setField5(fSimpleDateFormatField5.parse(tokenString));
            } catch (ParseException ex) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 5ږځBڔԍ[5] ږ[field_5/tB[h5BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂė^ꂽ`[" + fSimpleDateFormatField5.toPattern() + "]ł͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
            }
        }

        // ڔԍ[6]ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 6ږځBڔԍ[6] ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // CӍځB
        if (tokenString.length() == 0) {
            // K{ڂł͂Ȃڂɒ0̒lǂݍ܂ꂽꍇɂ́AlƂnull܂B
            record.setField6(null);
        } else {
            if (tokenString.getBytes().length < 1) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 6ږځBڔԍ[6] ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + tokenString + "]m܂B");
            }
            if (tokenString.getBytes().length > 3) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 6ږځBڔԍ[6] ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(3)l[" + tokenString + "]m܂B");
            }
            try {
                record.setField6(new BigDecimal(tokenString));
            } catch (NumberFormatException ex) {
                throw new BlancoCsvIOException("" + fLineCounter + "s 6ږځBڔԍ[6] ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĐl(decimal)ƂĂ͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
            }
        }

        // ڔԍ[7]ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 7ږځBڔԍ[7] ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // K{ځB
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 7ږځBڔԍ[7] ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒlĂȂƂm܂B");
        }
        record.setField11(tokenString);

        // ڔԍ[8]ږ[field_12/tB[h12BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        // NI[glǂݍ݂s܂B
        tokenString = readTokenWithQuote('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 8ږځBڔԍ[8] ږ[field_12/tB[h12BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // K{ځB
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 8ږځBڔԍ[8] ږ[field_12/tB[h12BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒlĂȂƂm܂B");
        }
        record.setField12(tokenString);

        // ڔԍ[9]ږ[field_13/tB[h13BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 9ږځBڔԍ[9] ږ[field_13/tB[h13BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // K{ځB
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 9ږځBڔԍ[9] ږ[field_13/tB[h13BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒlĂȂƂm܂B");
        }
        try {
            record.setField13(Integer.parseInt(tokenString));
        } catch (NumberFormatException ex) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 9ږځBڔԍ[9] ږ[field_13/tB[h13BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĐl(int)ƂĂ͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
        }

        // ڔԍ[10]ږ[field_14/tB[h14BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 10ږځBڔԍ[10] ږ[field_14/tB[h14BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // K{ځB
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 10ږځBڔԍ[10] ږ[field_14/tB[h14BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒlĂȂƂm܂B");
        }
        try {
            record.setField14(Long.parseLong(tokenString));
        } catch (NumberFormatException ex) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 10ږځBڔԍ[10] ږ[field_14/tB[h14BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĐl(long)ƂĂ͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
        }

        // ڔԍ[11]ږ[field_15/tB[h15BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 11ږځBڔԍ[11] ږ[field_15/tB[h15BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // K{ځB
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 11ږځBڔԍ[11] ږ[field_15/tB[h15BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒlĂȂƂm܂B");
        }
        try {
            record.setField15(fSimpleDateFormatField15.parse(tokenString));
        } catch (ParseException ex) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 11ږځBڔԍ[11] ږ[field_15/tB[h15BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂė^ꂽ`[" + fSimpleDateFormatField15.toPattern() + "]ł͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
        }

        // ڔԍ[12]ږ[field_16/tB[h16BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]
        tokenString = readToken('', true);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 12ږځBڔԍ[12] ږ[field_16/tB[h16BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕsȏI[m܂B");
        }
        // K{ځB
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 12ږځBڔԍ[12] ږ[field_16/tB[h16BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒlĂȂƂm܂B");
        }
        try {
            record.setField16(new BigDecimal(tokenString));
        } catch (NumberFormatException ex) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 12ږځBڔԍ[12] ږ[field_16/tB[h16BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĐl(decimal)ƂĂ͉͂łȂ[" + tokenString + "]m܂B:" + ex.toString(), ex);
        }
        return record;
    }

    /**
     * CSVŊ֘AÂ郊[_Ԃ܂B
     *
     * @return CSVŊ֘AÂ郊[_B
     */
    public BufferedReader getReader() {
        return fReader;
    }

    /**
     * CSVŊ֘AÂ郊[_ݒ肵܂B
     *
     * @param argReader CSVŊ֘AÂ郊[_B
     */
    public void setReader(final BufferedReader argReader) {
        fReader = argReader;
    }

    /**
     * ݏ̍sJE^Ԃ܂B
     *
     * @return ݏ̍sJE^B
     */
    public long getLineCounter() {
        return fLineCounter;
    }

    /**
     * ̃[_܂B
     *
     * ֘AÂꂽ[_ɑ΂Ăclose()Ăяo܂B
     *
     * @throws IOException ֘AÂꂽ[_close()ɎsꍇB
     */
    public void close() throws IOException {
        if (fReader != null) {
            fReader.close();
        }
    }

    /**
     * ֘AÂꂽReader ^ꂽf~^găg[No܂B
     *
     * @param delimiter f~^
     * @param isEndOfLine s̏I[ł̂ǂtO
     * @return oꂽg[NB͂⃊[_̏ꍇɂnullԂ܂B
     * @throws BlancoCsvIOException ڐȂȂǗ^ꂽɊւOꍇB
     * @throws IOException o͗OꍇB
     */
    protected String readToken(final char delimiter, final boolean isEndOfLine) throws BlancoCsvIOException, IOException {
        final StringBuffer buffer = new StringBuffer();
        for (;;) {
            final int iRead = fLineReader.read();
            if (iRead < 0) {
                // I[ɓBB
                if (isEndOfLine == false) {
                    throw new BlancoCsvIOException("s̏I[łȂ̂ɂւ炸f~^ꂸɍsIĂ܂܂B");
                }
                break;
            }
            if (iRead == delimiter) {
                if (isEndOfLine) {
                    throw new BlancoCsvIOException("s̏I[łׂɂւ炸f~^܂B");
                }
                break;
            } else {
                buffer.append((char) iRead);
            }
        }
        return buffer.toString();
    }

    /**
     * ֘AÂꂽReader _uNI[gt ^ꂽf~^găg[No܂B
     *
     * @param delimiter f~^
     * @param isEndOfLine s̏I[ł̂ǂtO
     * @return oꂽg[NB͂⃊[_̏ꍇɂnullԂ܂B
     * @throws BlancoCsvIOException _uNI[g̕svȂǗ^ꂽɊւOꍇB
     * @throws IOException o͗OꍇB
     */
    protected String readTokenWithQuote(final char delimiter, final boolean isEndOfLine) throws BlancoCsvIOException, IOException {
        final StringBuffer buffer = new StringBuffer();
        boolean isStringStarted = false;
        boolean isStringEnded = false;
        for (;;) {
            int iRead = fLineReader.read();
            if (iRead < 0) {
                // I[ɓBB
                if (isStringStarted && isStringEnded == false) {
                    // sóB
                    buffer.append('\n');
                    // _uNI[gB
                    fLine = fReader.readLine();
                    if (fLine == null) {
                        // _uNI[gł̂ɂ炸t@C̏I[ɓB܂B
                        break;
                    } else {
                        fLineReader = new StringReader(fLine);
                        continue;
                    }
                } else if (isEndOfLine == false) {
                    throw new BlancoCsvIOException("s̏I[łȂ̂ɂւ炸f~^ꂸɍsIĂ܂܂B");
                }
                break;
            }
            if (isStringStarted == false) {
                if (iRead != '"') {
                    throw new BlancoCsvIOException("_uNI[gŕ񂪊Jn܂B");
                }
                // _uNI[e[V͓ǂݔ΂܂B
                isStringStarted = true;
            } else if (isStringEnded) {
                if (iRead == delimiter) {
                    // I[ɓB܂B
                    if (isEndOfLine) {
                        throw new BlancoCsvIOException("s̏I[łׂɂւ炸f~^܂B");
                    }
                    break;
                }
                throw new BlancoCsvIOException("_uNI[gɂ镶Iɕ񂪗^܂B");
            } else {
                // ʏ̕GA
                if (iRead == '"') {
                    // _uNI[gd˂ꂽ̂łȂǂ`FbN܂B
                    fLineReader.mark(1);
                    if (fLineReader.read() == '"') {
                        // GXP[vꂽ_uNI[g
                        // 2łЂƂȂ̂ŁAЂƂ͓ǂݎ̂Ă܂B
                        buffer.append((char) iRead);
                    } else {
                        // _uNI[gɂGXP[vł͂܂łB
                        // ͏I[ӖĂ܂B
                        fLineReader.reset();
                        isStringEnded = true;
                    }
                } else {
                    buffer.append((char) iRead);
                }
            }
        }
        if (isStringStarted == false) {
            throw new BlancoCsvIOException("_uNI[gKvȕł̂Ƀ_uNI[gɂJn܂łB");
        }
        if (isStringEnded == false) {
            throw new BlancoCsvIOException("_uNI[gKvȕł̂Ƀ_uNI[gɂI܂łB");
        }
        return buffer.toString();
    }
}
