/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.csv.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;

import blanco.sample.csv.record.BlancoCsvSample3CsvRecord;
import blanco.sample.csv.util.BlancoCsvRuntimeUtil;

/**
 * t@C`[BlancoCsvSample3/̃NX͒PɃTvłBsPsځB(&lt;&gt;&quot;QƃGR[fBO)]̃C^NXB
 *
 * ̃NXblancoCsvt@C`玩ꂽC^NXłB<br>
 * @1.񒷃`FbNɂ́AftHgGR[fBO𗘗p܂B<br>
 * @2.NX̗p͕K close()ĂяoĂB<br>
 */
public class BlancoCsvSample3CsvWriter {
    /**
     * C^IuWFNgB
     *
     * CSVŊ֘AÂAۂɏo͂sC^B
     */
    protected BufferedWriter fWriter;

    /**
     * ݏ̍sJE^B
     *
     * ݏsĂs̈ʒuB
     */
    protected long fLineCounter = 0;

    /**
     * ^CgsꂽǂB
     */
    protected boolean fIsTitleProcessed = false;

    /**
     * [field_5]݂̏̍ۂɗptH[}b^[B
     *
     * CX^XĂƂɂ胁S~}܂B
     */
    protected SimpleDateFormat fSimpleDateFormatField5;

    /**
     * [field_15]݂̏̍ۂɗptH[}b^[B
     *
     * CX^XĂƂɂ胁S~}܂B
     */
    protected SimpleDateFormat fSimpleDateFormatField15;

    /**
     * CSVC^NX̃RXgN^B
     */
    public BlancoCsvSample3CsvWriter() {
        init();
    }

    /**
     * CSVC^NX̃RXgN^B
     *
     * ^ꂽC^Ɗ֘AÂ܂B
     *
     * @param arg ֘AÂ郉C^B
     */
    public BlancoCsvSample3CsvWriter(final BufferedWriter arg) {
        fWriter = arg;
        init();
    }

    /**
     * Ȃ܂B
     */
    protected void init() {
        fSimpleDateFormatField5 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        fSimpleDateFormatField15 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    /**
     * CSVt@C̃^Cgso܂B
     *
     * ^Cg̓f~^ŋ؂Ȃ烉C^ɏo͂AŌɉsR[ht^܂B<br>
     *
     * @throws IOException ֘AÂꂽC^o͂̍ۂɗOꍇB
     */
    public void writeTitle() throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("[BlancoCsvSample3] C^ݒ肳ĂȂԂŃ\bh[writeTitle]Ăяo܂B͋܂BC^ZbgĂĂтĂB");
        }

        fWriter.write("tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h2BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h5BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h12BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h13BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h14BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h15BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.write("tB[h16BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)");
        fWriter.newLine();
    }

    /**
     * ^ꂽso܂B
     *
     * f[^̓f~^ŋ؂Ȃ烉C^ɏo͂AŌɉsR[ht^܂B
     *
     * @param record R[hIuWFNgB
     * @throws BlancoCsvIOException ^ꂽR[h̍ڒlsȏꍇȂǁB
     * @throws IOException ֘AÂꂽC^o͂̍ۂɗOꍇB
     */
    public void writeRecord(final BlancoCsvSample3CsvRecord record) throws BlancoCsvIOException, IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("[BlancoCsvSample3] C^ݒ肳ĂȂԂŃ\bh[writeRecord]Ăяo܂B͋܂BC^ZbgĂĂтĂB");
        }

        if (fIsTitleProcessed == false) {
            // ^Cgs݁B
            writeTitle();
            fIsTitleProcessed = true;
        }

        String writeToken = null;

        // ڔԍ[1] ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getField1() == null ? "" : record.getField1();
        if (writeToken.length() > 0) {
            if (writeToken.getBytes().length < 1) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + writeToken + "]m܂B");
            }
            if (writeToken.getBytes().length > 10) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(10)l[" + writeToken + "]m܂B");
            }
        }
        if (writeToken.indexOf("") >= 0) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[field_1/tB[hBsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂăf[^[" + writeToken + "]ɍڂ̃f~^[]܂܂邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[2] ږ[field_2/tB[h2BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getField2() == null ? "" : record.getField2();
        if (writeToken.length() > 0) {
            if (writeToken.getBytes().length < 4) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 2ږځBڔԍ[2] ږ[field_2/tB[h2BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(4)Zl[" + writeToken + "]m܂B");
            }
            if (writeToken.getBytes().length > 4) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 2ږځBڔԍ[2] ږ[field_2/tB[h2BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(4)l[" + writeToken + "]m܂B");
            }
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write('');

        // ڔԍ[3] ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField3() == null) {
            writeToken = "";
        } else {
            writeToken = String.valueOf(record.getField3());
            if (writeToken.getBytes().length < 1) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 3ږځBڔԍ[3] ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + writeToken + "]m܂B");
            }
            if (writeToken.getBytes().length > 3) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 3ږځBڔԍ[3] ږ[field_3/tB[h3BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(3)l[" + writeToken + "]m܂B");
            }
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[4] ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField4() == null) {
            writeToken = "";
        } else {
            writeToken = String.valueOf(record.getField4());
            if (writeToken.getBytes().length < 1) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 4ږځBڔԍ[4] ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + writeToken + "]m܂B");
            }
            if (writeToken.getBytes().length > 3) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 4ږځBڔԍ[4] ږ[field_4/tB[h4BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(3)l[" + writeToken + "]m܂B");
            }
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[5] ږ[field_5/tB[h5BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField5() == null) {
            writeToken = "";
        } else {
            writeToken = fSimpleDateFormatField5.format(record.getField5());
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[6] ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField6() == null) {
            writeToken = "";
        } else {
            writeToken = record.getField6() == null ? "" : record.getField6().toString();
            if (writeToken.getBytes().length < 1) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 6ږځBڔԍ[6] ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMIN(1)Zl[" + writeToken + "]m܂B");
            }
            if (writeToken.getBytes().length > 3) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 6ږځBڔԍ[6] ږ[field_6/tB[h6BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂMAX(3)l[" + writeToken + "]m܂B");
            }
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[7] ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField11() == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 7ږځBڔԍ[7] ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        if (record.getField11().length() == 0) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 7ږځBڔԍ[7] ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒ0̕񂪗^Ă邱Ƃm܂B");
        }
        writeToken = record.getField11();
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 7ږځBڔԍ[7] ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        if (writeToken.indexOf("") >= 0) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 7ږځBڔԍ[7] ږ[field_11/tB[h11BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂăf[^[" + writeToken + "]ɍڂ̃f~^[]܂܂邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[8] ږ[field_12/tB[h12BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField12() == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 8ږځBڔԍ[8] ږ[field_12/tB[h12BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        if (record.getField12().length() == 0) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 8ږځBڔԍ[8] ږ[field_12/tB[h12BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂɒ0̕񂪗^Ă邱Ƃm܂B");
        }
        writeToken = record.getField12();
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 8ږځBڔԍ[8] ږ[field_12/tB[h12BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write('');

        // ڔԍ[9] ږ[field_13/tB[h13BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        writeToken = String.valueOf(record.getField13());
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 9ږځBڔԍ[9] ږ[field_13/tB[h13BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[10] ږ[field_14/tB[h14BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        writeToken = String.valueOf(record.getField14());
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 10ږځBڔԍ[10] ږ[field_14/tB[h14BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[11] ږ[field_15/tB[h15BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField15() == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 11ږځBڔԍ[11] ږ[field_15/tB[h15BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        writeToken = fSimpleDateFormatField15.format(record.getField15());
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 11ږځBڔԍ[11] ږ[field_15/tB[h15BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write('');

        // ڔԍ[12] ږ[field_16/tB[h16BsȂǎQƕ̎BPsځB(<>"QƃGR[fBO)]
        if (record.getField16() == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 12ږځBڔԍ[12] ږ[field_16/tB[h16BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        writeToken = record.getField16().toString();
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 12ږځBڔԍ[12] ږ[field_16/tB[h16BsȂǎQƕ̎BPsځB(<>\"QƃGR[fBO)]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);

        // ŌɉsR[ht^܂B
        fWriter.newLine();
        fLineCounter++;
    }

    /**
     * CSVŊ֘AÂ郉C^Ԃ܂B
     *
     * @return CSVŊ֘AÂ郉C^B
     */
    public BufferedWriter getWriter() {
        return fWriter;
    }

    /**
     * CSVŊ֘AÂ郉C^ݒ肵܂B
     *
     * @param argWriter CSVŊ֘AÂ郉C^B
     */
    public void setWriter(final BufferedWriter argWriter) {
        fWriter = argWriter;
    }

    /**
     * ݏ̍sJE^Ԃ܂B
     *
     * @return ݏ̍sJE^B
     */
    public long getLineCounter() {
        return fLineCounter;
    }

    /**
     * ̃C^tbV܂B
     *
     * ֘AÂꂽC^ɑ΂Ăflush()Ăяo܂B
     *
     * @throws IOException ֘AÂꂽC^flush()ɎsꍇB
     */
    public void flush() throws IOException {
        if (fWriter != null) {
            fWriter.flush();
        }
    }

    /**
     * ̃C^܂B
     *
     * ֘AÂꂽC^ɑ΂Ăclose()Ăяo܂B
     *
     * @throws IOException ֘AÂꂽC^close()ɎsꍇB
     */
    public void close() throws IOException {
        if (fWriter != null) {
            if (fIsTitleProcessed == false) {
                // ^Cgs݁B
                writeTitle();
                fIsTitleProcessed = true;
            }

            fWriter.close();
        }
    }
}
