/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.font;

import java.io.File;

import junit.framework.TestCase;
import blanco.pdf.font.valueobject.BlancoPdfFontDef;
import blanco.pdf.valueobject.BlancoPdfSetting;

public class BlancoPdfFontUtilTest extends TestCase {
    public void testTate() throws Exception {
        final BlancoPdfSetting setting = new BlancoPdfSetting();
        setting.setConfPath("test/conf/pdf");

        final File root = new File("test/conf/pdf/font");
        for (File look : root.listFiles()) {
            if (look == null) {
                continue;
            }
            if (look.isDirectory()) {
                continue;
            }
            if (look.getName().endsWith(".xml") == false) {
                continue;
            }

            final BlancoPdfFontDef fontDef = BlancoPdfFontUtil.read(setting,
                    look.getName().substring(0,
                            look.getName().length() - ".xml".length()));
            System.out.println(fontDef.toString());
        }
    }
}
