/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report.sample;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;
import blanco.pdf.valueobject.BlancoPdfSetting;
import blanco.sample.pdf.report.Yoko02PdfReport;
import blanco.sample.pdf.report.items.Yoko02PdfReportBlockItems;
import blanco.sample.pdf.report.items.Yoko02PdfReportItems;

/**
 * ꂽ\[XR[h𗘗p󎚂̗B
 */
public class BlancoPdfReportYoko02Test extends TestCase {
    List<Yoko02PdfReportItems> getItems() {
        final List<Yoko02PdfReportItems> itemsList = new ArrayList<Yoko02PdfReportItems>();

        for (int outer = 0; outer < 4; outer++) {
            int shohinNo = 5;
            int shohinGroup = 4;
            for (int inner = 0; inner < 13; inner++) {
                final Yoko02PdfReportItems pdfItems = new Yoko02PdfReportItems();
                itemsList.add(pdfItems);
                {
                    pdfItems.setField00("^Cg" + outer);
                    pdfItems.setField01("Tv");
                    pdfItems.setField02(BigDecimal.valueOf(123.456));
                    pdfItems.setField04("Z^O");

                    pdfItems.setHidden01("BtB[h");
                    pdfItems.setNextpage01("ɂy[W܂B");
                    pdfItems.setNextpage02("ŏIy[WłB");
                }

                {
                    final Yoko02PdfReportBlockItems block01 = new Yoko02PdfReportBlockItems();
                    pdfItems.getBlockList().add(block01);
                    block01.setBlock01("i" + (shohinNo++ / 4));
                    block01.setBlock02("" + (shohinGroup++ / 2));
                    block01.setBlock03("ubN" + inner);
                    block01.setBlock04("l" + inner);
                    block01.setGokei01("v(!)");
                }
            }
        }

        return itemsList;
    }

    public void testReport() throws Exception {
        final long start = System.currentTimeMillis();

        new File("./tmp/pdf/").mkdirs();
        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream("./tmp/pdf/yoko02result.pdf"));
        final BlancoPdfSetting setting = new BlancoPdfSetting();
        setting.setConfPath("./conf/pdf");
        final Yoko02PdfReport report = new Yoko02PdfReport(setting, outStream);

        final List<Yoko02PdfReportItems> itemsList = getItems();

        // K(!)
        // report.normalize(itemsList);
        report.consolidatePage(itemsList);
        report.dupRowByKey(itemsList);

        report.breakPageByRowCount(itemsList);
        report.processPageContinuity(itemsList);

        report.omitDitto(itemsList);
        report.applyPageNo(itemsList);

        // 󎚁B
        report.writeItemsList(itemsList);

        report.close();
        outStream.flush();
        outStream.close();

        final long end = System.currentTimeMillis();

        System.out.println(end - start + " ms");
    }
}
