/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
package blanco.xml.bind;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import blanco.xml.bind.valueobject.BlancoXmlDocument;

/**
 * XML  blancoXmlBinding o[IuWFNg\𐶐邽߂̃NXłB
 * 
 * ̃NX XML/o[IuWFNg}bsO (X/O}bsO) blancoXmlBinding ̈ꕔłB
 * 
 * @author IGA Tosiki
 */
public class BlancoXmlUnmarshaller {
    /**
     * XMLJavaIuWFNg𐶐܂B
     * 
     * Ql: http://java.sun.com/webservices/docs/1.6/api/javax/xml/bind/
     * Unmarshaller.html
     * 
     * @param fileInput
     *            XMLt@CB
     * @return blancoXmlƂẴIuWFNgB
     */
    public BlancoXmlDocument unmarshal(final File fileInput) {
        if (fileInput.exists() == false) {
            throw new IllegalArgumentException("t@C["
                    + fileInput.getAbsolutePath() + "]͌܂B");
        }
        if (fileInput.isDirectory()) {
            throw new IllegalArgumentException("t@C["
                    + fileInput.getAbsolutePath() + "]͎ۂɂ̓fBNgłB");
        }
        if (fileInput.canRead() == false) {
            throw new IllegalArgumentException("t@C["
                    + fileInput.getAbsolutePath() + "]͓ǂݍނƂł܂B");
        }

        InputStream inStream = null;

        try {
            inStream = new BufferedInputStream(new FileInputStream(fileInput));

            return unmarshal(inStream);
        } catch (IOException e) {
            throw new IllegalArgumentException("ɓo͗O܂B: "
                    + e.toString(), e);
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    throw new IllegalArgumentException(
                            "̓Xg[̃N[Yɓo͗O܂B: " + e.toString(), e);
                }
            }
        }
    }

    /**
     * XMLJavaIuWFNg𐶐܂B
     * 
     * Ql: http://java.sun.com/webservices/docs/1.6/api/javax/xml/bind/
     * Unmarshaller.html
     * 
     * @param inStream
     *            XML̓Xg[B
     * @return blancoXmlƂẴIuWFNgB
     */
    public BlancoXmlDocument unmarshal(final InputStream inStream) {
        if (inStream == null) {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshaller#unmarshal: ̓Xg[ null ^܂B");
        }

        final BlancoXmlUnmarshallerContentHandler handler = new BlancoXmlUnmarshallerContentHandler();

        try {
            // XMLp[T̐ݒRg[̂ŁAXMLReaderD悵ėpB
            XMLReader reader = null;
            try {
                reader = XMLReaderFactory.createXMLReader();
            } catch (SAXException e) {
                Logger.getLogger("blanco.xml.bind").fine(
                        "XMLReader ̎擾Ɏs܂: " + e.toString());

                // ɂĂ(JDK 1.4.2ŋH?) XMLReader̎擾Ɏsꍇ܂B

                // XMLReaderFactory.createXMLReader() ĂяoɁA
                // org.xml.sax.SAXException: System property org.xml.sax.driver
                // not specified 邱ƂmFĂ܂B
                final SAXResult result = new SAXResult(handler);
                result.setHandler(handler);
                result.setLexicalHandler(handler);
                final TransformerFactory tf = TransformerFactory.newInstance();
                try {
                    final Transformer transformer = tf.newTransformer();
                    transformer.transform(new StreamSource(inStream), result);
                    return handler.getDocument();

                } catch (TransformerException e2) {
                    throw new IllegalArgumentException(" XML ͗O܂B"
                            + e2.toString(), e2);
                }
            }

            // XMLReader𖳎Ɏ擾łꍇɂ́Aʂ܂B

            try {
                // ODTDǂݍ܂Ȃ邽߂̎B
                reader
                        .setFeature(
                                "http://apache.org/xml/features/nonvalidating/load-external-dtd",
                                false);
            } catch (SAXNotRecognizedException e) {
                Logger.getLogger("blanco.xml.bind").finest(
                        "O DTD ǂݍ܂Ȃ邽߂̐ݒ̎{ɗO܂: " + e.toString());
            }

            reader.setContentHandler(handler);
            reader.setDTDHandler(handler);
            // Rg邽߂ɃvpeBݒB
            reader.setProperty("http://xml.org/sax/properties/lexical-handler",
                    handler);

            // DTD 錾݂͌͏Ă܂B
            // ́Ȁ݂͈͂ javax.xml.transform.sax.TransformerHandler
            // ƌ肵Ă邽߂łB
            // reader.setProperty(
            // "http://xml.org/sax/properties/declaration-handler",
            // handler);

            reader.parse(new InputSource(inStream));
            return handler.getDocument();

        } catch (SAXException e) {
            throw new IllegalArgumentException(" XML ͗O܂B: "
                    + e.toString(), e);
        } catch (IOException e) {
            throw new IllegalArgumentException("ɓo͗O܂B: "
                    + e.toString(), e);
        } finally {
            if (inStream != null) {
                try {
                    inStream.close();
                } catch (IOException e) {
                    throw new IllegalArgumentException(
                            "̓Xg[̃N[Yɓo͗O܂B: " + e.toString(), e);
                }
            }
        }
    }
}
