/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.db.task;

import java.io.IOException;

import blanco.db.task.valueobject.BlancoDbDotNetProcessInput;

/**
 * ob`NX [BlancoDbDotNetBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.db.task.BlancoDbDotNetBatchProcess -help
 * </code>
 */
public class BlancoDbDotNetBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoDbDotNetBatchProcess batchProcess = new BlancoDbDotNetBatchProcess();

        // ob`̈B
        final BlancoDbDotNetProcessInput input = new BlancoDbDotNetProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldJdbcdriverProcessed = false;
        boolean isFieldJdbcurlProcessed = false;
        boolean isFieldJdbcuserProcessed = false;
        boolean isFieldJdbcpasswordProcessed = false;
        boolean isFieldMetadirProcessed = false;
        boolean isFieldBasepackageProcessed = false;
        boolean isFieldDataaccessProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-jdbcdriver=")) {
                input.setJdbcdriver(arg.substring(12));
                isFieldJdbcdriverProcessed = true;
            } else if (arg.startsWith("-jdbcurl=")) {
                input.setJdbcurl(arg.substring(9));
                isFieldJdbcurlProcessed = true;
            } else if (arg.startsWith("-jdbcuser=")) {
                input.setJdbcuser(arg.substring(10));
                isFieldJdbcuserProcessed = true;
            } else if (arg.startsWith("-jdbcpassword=")) {
                input.setJdbcpassword(arg.substring(14));
                isFieldJdbcpasswordProcessed = true;
            } else if (arg.startsWith("-jdbcdriverfile=")) {
                input.setJdbcdriverfile(arg.substring(16));
            } else if (arg.startsWith("-metadir=")) {
                input.setMetadir(arg.substring(9));
                isFieldMetadirProcessed = true;
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-basepackage=")) {
                input.setBasepackage(arg.substring(13));
                isFieldBasepackageProcessed = true;
            } else if (arg.startsWith("-runtimepackage=")) {
                input.setRuntimepackage(arg.substring(16));
            } else if (arg.startsWith("-schema=")) {
                input.setSchema(arg.substring(8));
            } else if (arg.startsWith("-table=")) {
                input.setTable(Boolean.valueOf(arg.substring(7)).booleanValue());
            } else if (arg.startsWith("-sql=")) {
                input.setSql(Boolean.valueOf(arg.substring(5)).booleanValue());
            } else if (arg.startsWith("-log=")) {
                input.setLog(Boolean.valueOf(arg.substring(5)).booleanValue());
            } else if (arg.startsWith("-statementtimeout=")) {
                input.setStatementtimeout(arg.substring(18));
            } else if (arg.startsWith("-executesql=")) {
                input.setExecutesql(arg.substring(12));
            } else if (arg.startsWith("-encoding=")) {
                input.setEncoding(arg.substring(10));
            } else if (arg.startsWith("-cache=")) {
                input.setCache(Boolean.valueOf(arg.substring(7)).booleanValue());
            } else if (arg.startsWith("-dataaccess=")) {
                input.setDataaccess(arg.substring(12));
                isFieldDataaccessProcessed = true;
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoDbDotNetBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldJdbcdriverProcessed == false) {
            System.out.println("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcdriver]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcurlProcessed == false) {
            System.out.println("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcurl]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcuserProcessed == false) {
            System.out.println("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcuser]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldJdbcpasswordProcessed == false) {
            System.out.println("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcpassword]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldMetadirProcessed == false) {
            System.out.println("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[metadir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldBasepackageProcessed == false) {
            System.out.println("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[basepackage]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldDataaccessProcessed == false) {
            System.out.println("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[dataaccess]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoDbDotNetProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoDbDotNetProcessC^tF[X blanco.db.taskpbP[W BlancoDbDotNetProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoDbDotNetProcess process = new BlancoDbDotNetProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoDbDotNetProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoDbDotNetBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoDbDotNetBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoDbDotNetBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoDbDotNetBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoDbDotNetBatchProcess: Usage:");
        System.out.println("  java blanco.db.task.BlancoDbDotNetBatchProcess -verbose=l1 -jdbcdriver=l2 -jdbcurl=l3 -jdbcuser=l4 -jdbcpassword=l5 -jdbcdriverfile=l6 -metadir=l7 -tmpdir=l8 -targetdir=l9 -basepackage=l10 -runtimepackage=l11 -schema=l12 -table=l13 -sql=l14 -log=l15 -statementtimeout=l16 -executesql=l17 -encoding=l18 -cache=l19 -dataaccess=l20");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -jdbcdriver");
        System.out.println("      [JDBChCõNXw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcurl");
        System.out.println("      [JDBCڑURLw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcuser");
        System.out.println("      [JDBCf[^x[Xڑsۂ̃[Uw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcpassword");
        System.out.println("      [JDBCf[^x[Xڑsۂ̃pX[hw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -jdbcdriverfile");
        System.out.println("      [JDBChCo jar t@Cw肵܂Bʏ͗p܂B]");
        System.out.println("      ^[]");
        System.out.println("    -metadir");
        System.out.println("      [SQL`^t@Ci[ĂfBNgw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -tmpdir");
        System.out.println("      [e|tH_w肵܂Bw̏ꍇɂ̓JgtmptH_𗘗p܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[tmp]");
        System.out.println("    -targetdir");
        System.out.println("      [blancoDbC#.NET\[XR[ho͂fBNgw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[blanco.cs]");
        System.out.println("    -basepackage");
        System.out.println("      [blancoDbC#.NET\[XR[h𐶐ۂ̊ƂȂpbP[Ww肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -runtimepackage");
        System.out.println("      [^CNX𐶐鐶w肵܂Bw̏ꍇɂ basepackageɐ܂B]");
        System.out.println("      ^[]");
        System.out.println("    -schema");
        System.out.println("      [P\擾ۂ̃XL[}B{IɖwłBOraclȅꍇɂ̂݁A[U啶̂w肵܂BOraclȅꍇ w肵ȂƁAVXe\܂ŌĂ܂s邽߂łB_ł̓T|[gȂIvVłB]");
        System.out.println("      ^[]");
        System.out.println("    -table");
        System.out.println("      [trueݒ肷ƒP\̂߂̃ANZTER[h𐶐܂B]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sql");
        System.out.println("      [trueݒ肷SQL`R[h𐶐܂B]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -log");
        System.out.println("      [trueݒ肷 Log4Netp̃MOR[h𐶐܂B_ł̓T|[gȂIvVłB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -statementtimeout");
        System.out.println("      [Xe[gg̃^CAEglBSQL̃^CAEglݒ肵܂BCommandTimeout vpeBɔf܂Bw̏ꍇɂAPIftHgB]");
        System.out.println("      ^[]");
        System.out.println("    -executesql");
        System.out.println("      [\[XR[hSQL`SQLs邩ǂݒ肷tOBftHg iteratorBiterator:^̂SQLsČ؂Bnone:SQL͎sȂB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[iterator]");
        System.out.println("    -encoding");
        System.out.println("      [\[Xt@C̕GR[fBOw肵܂B]");
        System.out.println("      ^[]");
        System.out.println("    -cache");
        System.out.println("      [`^t@C璆XMLt@Cւ̕ϊLbVōς܂ǂ̃tOB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -dataaccess");
        System.out.println("      [o͂f[^ANZX^Cvw肵܂BADO.NET̏ꍇ\"ado.net\"AODP.NET̏ꍇ\"odp.net\"w肵܂B]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoDbDotNetProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getJdbcdriver() == null) {
            throw new IllegalArgumentException("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcdriver]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcurl() == null) {
            throw new IllegalArgumentException("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcurl]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcuser() == null) {
            throw new IllegalArgumentException("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcuser]ɒlݒ肳Ă܂B");
        }
        if (input.getJdbcpassword() == null) {
            throw new IllegalArgumentException("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[jdbcpassword]ɒlݒ肳Ă܂B");
        }
        if (input.getMetadir() == null) {
            throw new IllegalArgumentException("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[metadir]ɒlݒ肳Ă܂B");
        }
        if (input.getBasepackage() == null) {
            throw new IllegalArgumentException("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[basepackage]ɒlݒ肳Ă܂B");
        }
        if (input.getDataaccess() == null) {
            throw new IllegalArgumentException("BlancoDbDotNetBatchProcess: JnsB̓p[^[input]̕K{tB[hl[dataaccess]ɒlݒ肳Ă܂B");
        }
    }
}
