/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobjectdotnet.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.valueobjectdotnet.BlancoValueObjectDotNetMeta2Xml;
import blanco.valueobjectdotnet.BlancoValueObjectDotNetXml2SourceFile;
import blanco.valueobjectdotnet.resourcebundle.BlancoValueObjectDotNetResourceBundle;
import blanco.valueobjectdotnet.task.valueobject.BlancoValueObjectDotNetProcessInput;

public class BlancoValueObjectDotNetProcessImpl implements
        BlancoValueObjectDotNetProcess {
    private final BlancoValueObjectDotNetResourceBundle bundle = new BlancoValueObjectDotNetResourceBundle();

    public int execute(final BlancoValueObjectDotNetProcessInput input)
            throws IOException, IllegalArgumentException {
        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg["
                        + input.getMetadir() + "]݂܂B");
            }

            // e|fBNg쐬B
            new File(input.getTmpdir() + bundle.getTargetDirectory()).mkdirs();

            new BlancoValueObjectDotNetMeta2Xml().processDirectory(fileMetadir,
                    input.getTmpdir() + bundle.getTargetDirectory());

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + bundle.getTargetDirectory()).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                BlancoValueObjectDotNetXml2SourceFile xml2CsClass = new BlancoValueObjectDotNetXml2SourceFile();
                xml2CsClass.setEncoding(input.getEncoding());
                xml2CsClass.setNameAdjust(input.getNameAdjust());
                xml2CsClass.process(fileMeta2[index], new File(input
                        .getTargetdir()));
            }

            // Ƀ^fBNgƂĎw肳ĂfBNg𑖍
            final File[] fileMeta3 = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta3.length; index++) {
                if (fileMeta3[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                BlancoValueObjectDotNetXml2SourceFile xml2CsClass = new BlancoValueObjectDotNetXml2SourceFile();
                xml2CsClass.setEncoding(input.getEncoding());
                xml2CsClass.setNameAdjust(input.getNameAdjust());
                xml2CsClass.process(fileMeta3[index], new File(input
                        .getTargetdir()));
            }

            return BlancoValueObjectDotNetBatchProcess.END_SUCCESS;
        } catch (TransformerException e) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + e.toString());
        }
    }

    @Override
    public boolean progress(final String argProgressMessage) {
        System.out.println(argProgressMessage);
        return false;
    }
}
